package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface UserFluent<A extends UserFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(int[] arg1,int arg2,int arg3);
    public A withNewApiVersion(char[] arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A withNewApiVersion(byte[] arg1,int arg2);
    public A withNewApiVersion(byte[] arg1);
    public A withNewApiVersion(char[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewApiVersion(String arg1);
    public String getFullName();
    public A withFullName(String fullName);
    public Boolean hasFullName();
    public A withNewFullName(StringBuilder arg1);
    public A withNewFullName(int[] arg1,int arg2,int arg3);
    public A withNewFullName(char[] arg1);
    public A withNewFullName(StringBuffer arg1);
    public A withNewFullName(byte[] arg1,int arg2);
    public A withNewFullName(byte[] arg1);
    public A withNewFullName(char[] arg1,int arg2,int arg3);
    public A withNewFullName(byte[] arg1,int arg2,int arg3);
    public A withNewFullName(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewFullName(String arg1);
    public A addToGroups(int index,String item);
    public A setToGroups(int index,String item);
    public A addToGroups(String... items);
    public A addAllToGroups(Collection<String> items);
    public A removeFromGroups(String... items);
    public A removeAllFromGroups(Collection<String> items);
    public List<String> getGroups();
    public String getGroup(int index);
    public String getFirstGroup();
    public String getLastGroup();
    public String getMatchingGroup(Predicate<String> predicate);
    public Boolean hasMatchingGroup(Predicate<String> predicate);
    public A withGroups(List<String> groups);
    public A withGroups(String... groups);
    public Boolean hasGroups();
    public A addNewGroup(StringBuilder arg1);
    public A addNewGroup(int[] arg1,int arg2,int arg3);
    public A addNewGroup(char[] arg1);
    public A addNewGroup(StringBuffer arg1);
    public A addNewGroup(byte[] arg1,int arg2);
    public A addNewGroup(byte[] arg1);
    public A addNewGroup(char[] arg1,int arg2,int arg3);
    public A addNewGroup(byte[] arg1,int arg2,int arg3);
    public A addNewGroup(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewGroup(String arg1);
    public A addToIdentities(int index,String item);
    public A setToIdentities(int index,String item);
    public A addToIdentities(String... items);
    public A addAllToIdentities(Collection<String> items);
    public A removeFromIdentities(String... items);
    public A removeAllFromIdentities(Collection<String> items);
    public List<String> getIdentities();
    public String getIdentity(int index);
    public String getFirstIdentity();
    public String getLastIdentity();
    public String getMatchingIdentity(Predicate<String> predicate);
    public Boolean hasMatchingIdentity(Predicate<String> predicate);
    public A withIdentities(List<String> identities);
    public A withIdentities(String... identities);
    public Boolean hasIdentities();
    public A addNewIdentity(StringBuilder arg1);
    public A addNewIdentity(int[] arg1,int arg2,int arg3);
    public A addNewIdentity(char[] arg1);
    public A addNewIdentity(StringBuffer arg1);
    public A addNewIdentity(byte[] arg1,int arg2);
    public A addNewIdentity(byte[] arg1);
    public A addNewIdentity(char[] arg1,int arg2,int arg3);
    public A addNewIdentity(byte[] arg1,int arg2,int arg3);
    public A addNewIdentity(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewIdentity(String arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(int[] arg1,int arg2,int arg3);
    public A withNewKind(char[] arg1);
    public A withNewKind(StringBuffer arg1);
    public A withNewKind(byte[] arg1,int arg2);
    public A withNewKind(byte[] arg1);
    public A withNewKind(char[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewKind(String arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public io.fabric8.openshift.api.model.UserFluent.MetadataNested<A> withNewMetadata();
    public io.fabric8.openshift.api.model.UserFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public io.fabric8.openshift.api.model.UserFluent.MetadataNested<A> editMetadata();
    public io.fabric8.openshift.api.model.UserFluent.MetadataNested<A> editOrNewMetadata();
    public io.fabric8.openshift.api.model.UserFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<io.fabric8.openshift.api.model.UserFluent.MetadataNested<N>> {

            public N and();
            public N endMetadata();    }


}
