package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SubjectRulesReviewSpecBuilder extends SubjectRulesReviewSpecFluentImpl<SubjectRulesReviewSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<SubjectRulesReviewSpec,SubjectRulesReviewSpecBuilder> {

    SubjectRulesReviewSpecFluent<?> fluent;
    Boolean validationEnabled;

    public SubjectRulesReviewSpecBuilder() {
        this(true);
    }

    public SubjectRulesReviewSpecBuilder(Boolean validationEnabled) {
        this(new SubjectRulesReviewSpec(), validationEnabled);
    }

    public SubjectRulesReviewSpecBuilder(SubjectRulesReviewSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public SubjectRulesReviewSpecBuilder(SubjectRulesReviewSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new SubjectRulesReviewSpec(), validationEnabled);
    }

    public SubjectRulesReviewSpecBuilder(SubjectRulesReviewSpecFluent<?> fluent,SubjectRulesReviewSpec instance) {
        this(fluent, instance, true);
    }

    public SubjectRulesReviewSpecBuilder(SubjectRulesReviewSpecFluent<?> fluent,SubjectRulesReviewSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withGroups(instance.getGroups()); 
        fluent.withScopes(instance.getScopes()); 
        fluent.withUser(instance.getUser()); 
        this.validationEnabled = validationEnabled; 
    }

    public SubjectRulesReviewSpecBuilder(SubjectRulesReviewSpec instance) {
        this(instance,true);
    }

    public SubjectRulesReviewSpecBuilder(SubjectRulesReviewSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withGroups(instance.getGroups()); 
        this.withScopes(instance.getScopes()); 
        this.withUser(instance.getUser()); 
        this.validationEnabled = validationEnabled; 
    }

    public SubjectRulesReviewSpec build() {
        SubjectRulesReviewSpec buildable = new SubjectRulesReviewSpec(fluent.getGroups(),fluent.getScopes(),fluent.getUser());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        SubjectRulesReviewSpecBuilder that = (SubjectRulesReviewSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
