package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface StageInfoFluent<A extends StageInfoFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public Long getDurationMilliseconds();
    public A withDurationMilliseconds(Long durationMilliseconds);
    public Boolean hasDurationMilliseconds();
    public A withNewDurationMilliseconds(long arg1);
    public String getName();
    public A withName(String name);
    public Boolean hasName();
    public A withNewName(StringBuilder arg1);
    public A withNewName(int[] arg1,int arg2,int arg3);
    public A withNewName(char[] arg1);
    public A withNewName(StringBuffer arg1);
    public A withNewName(byte[] arg1,int arg2);
    public A withNewName(byte[] arg1);
    public A withNewName(char[] arg1,int arg2,int arg3);
    public A withNewName(byte[] arg1,int arg2,int arg3);
    public A withNewName(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewName(String arg1);
    public String getStartTime();
    public A withStartTime(String startTime);
    public Boolean hasStartTime();
    public A withNewStartTime(StringBuilder arg1);
    public A withNewStartTime(int[] arg1,int arg2,int arg3);
    public A withNewStartTime(char[] arg1);
    public A withNewStartTime(StringBuffer arg1);
    public A withNewStartTime(byte[] arg1,int arg2);
    public A withNewStartTime(byte[] arg1);
    public A withNewStartTime(char[] arg1,int arg2,int arg3);
    public A withNewStartTime(byte[] arg1,int arg2,int arg3);
    public A withNewStartTime(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewStartTime(String arg1);
    public A addToSteps(int index,StepInfo item);
    public A setToSteps(int index,StepInfo item);
    public A addToSteps(StepInfo... items);
    public A addAllToSteps(Collection<StepInfo> items);
    public A removeFromSteps(StepInfo... items);
    public A removeAllFromSteps(Collection<StepInfo> items);
    public A removeMatchingFromSteps(Predicate<StepInfoBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildSteps instead.
 * @return The buildable object.
 */
@Deprecated public List<StepInfo> getSteps();
    public List<StepInfo> buildSteps();
    public StepInfo buildStep(int index);
    public StepInfo buildFirstStep();
    public StepInfo buildLastStep();
    public StepInfo buildMatchingStep(Predicate<StepInfoBuilder> predicate);
    public Boolean hasMatchingStep(Predicate<StepInfoBuilder> predicate);
    public A withSteps(List<StepInfo> steps);
    public A withSteps(StepInfo... steps);
    public Boolean hasSteps();
    public A addNewStep(Long durationMilliseconds,String name,String startTime);
    public io.fabric8.openshift.api.model.StageInfoFluent.StepsNested<A> addNewStep();
    public io.fabric8.openshift.api.model.StageInfoFluent.StepsNested<A> addNewStepLike(StepInfo item);
    public io.fabric8.openshift.api.model.StageInfoFluent.StepsNested<A> setNewStepLike(int index,StepInfo item);
    public io.fabric8.openshift.api.model.StageInfoFluent.StepsNested<A> editStep(int index);
    public io.fabric8.openshift.api.model.StageInfoFluent.StepsNested<A> editFirstStep();
    public io.fabric8.openshift.api.model.StageInfoFluent.StepsNested<A> editLastStep();
    public io.fabric8.openshift.api.model.StageInfoFluent.StepsNested<A> editMatchingStep(Predicate<StepInfoBuilder> predicate);
    public interface StepsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,StepInfoFluent<io.fabric8.openshift.api.model.StageInfoFluent.StepsNested<N>> {

            public N and();
            public N endStep();    }


}
