package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.Collection;
import java.lang.Object;

public class SourceBuildStrategyFluentImpl<A extends SourceBuildStrategyFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SourceBuildStrategyFluent<A> {

    private List<EnvVar> env = new ArrayList<EnvVar>();
    private Boolean forcePull;
    private io.fabric8.kubernetes.api.model.ObjectReferenceBuilder from;
    private Boolean incremental;
    private LocalObjectReferenceBuilder pullSecret;
    private String scripts;

    public SourceBuildStrategyFluentImpl() {
    }

    public SourceBuildStrategyFluentImpl(SourceBuildStrategy instance) {
        this.withEnv(instance.getEnv()); 
        this.withForcePull(instance.getForcePull()); 
        this.withFrom(instance.getFrom()); 
        this.withIncremental(instance.getIncremental()); 
        this.withPullSecret(instance.getPullSecret()); 
        this.withScripts(instance.getScripts()); 
    }

    public A addToEnv(int index,EnvVar item) {
        if (this.env == null) {this.env = new ArrayList<EnvVar>();}
        this.env.add(index, item);
        return (A)this;
    }

    public A setToEnv(int index,EnvVar item) {
        if (this.env == null) {this.env = new ArrayList<EnvVar>();}
        this.env.set(index, item); return (A)this;
    }

    public A addToEnv(EnvVar... items) {
        if (this.env == null) {this.env = new ArrayList<EnvVar>();}
        for (EnvVar item : items) {this.env.add(item);} return (A)this;
    }

    public A addAllToEnv(Collection<EnvVar> items) {
        if (this.env == null) {this.env = new ArrayList<EnvVar>();}
        for (EnvVar item : items) {this.env.add(item);} return (A)this;
    }

    public A removeFromEnv(EnvVar... items) {
        for (EnvVar item : items) {if (this.env!= null){ this.env.remove(item);}} return (A)this;
    }

    public A removeAllFromEnv(Collection<EnvVar> items) {
        for (EnvVar item : items) {if (this.env!= null){ this.env.remove(item);}} return (A)this;
    }

    public List<EnvVar> getEnv() {
        return this.env;
    }

    public EnvVar getEnv(int index) {
        return this.env.get(index);
    }

    public EnvVar getFirstEnv() {
        return this.env.get(0);
    }

    public EnvVar getLastEnv() {
        return this.env.get(env.size() - 1);
    }

    public EnvVar getMatchingEnv(Predicate<EnvVar> predicate) {
        for (EnvVar item: env) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingEnv(Predicate<EnvVar> predicate) {
        for (EnvVar item: env) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withEnv(List<EnvVar> env) {
        if (this.env != null) { _visitables.get("env").removeAll(this.env);}
        if (env != null) {this.env = new ArrayList<EnvVar>(); for (EnvVar item : env){this.addToEnv(item);}} else { this.env = null;} return (A) this;
    }

    public A withEnv(EnvVar... env) {
        if (this.env != null) {this.env.clear();}
        if (env != null) {for (EnvVar item :env){ this.addToEnv(item);}} return (A) this;
    }

    public Boolean hasEnv() {
        return env != null && !env.isEmpty();
    }

    public Boolean getForcePull() {
        return this.forcePull;
    }

    public A withForcePull(Boolean forcePull) {
        this.forcePull=forcePull; return (A) this;
    }

    public Boolean hasForcePull() {
        return this.forcePull != null;
    }

    public A withNewForcePull(String arg1) {
        return (A)withForcePull(new Boolean(arg1));
    }

    public A withNewForcePull(boolean arg1) {
        return (A)withForcePull(new Boolean(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildFrom instead.
 * @return The buildable object.
 */
@Deprecated public io.fabric8.kubernetes.api.model.ObjectReference getFrom() {
        return this.from!=null?this.from.build():null;
    }

    public io.fabric8.kubernetes.api.model.ObjectReference buildFrom() {
        return this.from!=null?this.from.build():null;
    }

    public A withFrom(io.fabric8.kubernetes.api.model.ObjectReference from) {
        _visitables.get("from").remove(this.from);
        if (from!=null){ this.from= new ObjectReferenceBuilder(from); _visitables.get("from").add(this.from);} return (A) this;
    }

    public Boolean hasFrom() {
        return this.from != null;
    }

    public io.fabric8.openshift.api.model.SourceBuildStrategyFluent.FromNested<A> withNewFrom() {
        return new FromNestedImpl();
    }

    public io.fabric8.openshift.api.model.SourceBuildStrategyFluent.FromNested<A> withNewFromLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
        return new FromNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.SourceBuildStrategyFluent.FromNested<A> editFrom() {
        return withNewFromLike(getFrom());
    }

    public io.fabric8.openshift.api.model.SourceBuildStrategyFluent.FromNested<A> editOrNewFrom() {
        return withNewFromLike(getFrom() != null ? getFrom(): new ObjectReferenceBuilder().build());
    }

    public io.fabric8.openshift.api.model.SourceBuildStrategyFluent.FromNested<A> editOrNewFromLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
        return withNewFromLike(getFrom() != null ? getFrom(): item);
    }

    public Boolean getIncremental() {
        return this.incremental;
    }

    public A withIncremental(Boolean incremental) {
        this.incremental=incremental; return (A) this;
    }

    public Boolean hasIncremental() {
        return this.incremental != null;
    }

    public A withNewIncremental(String arg1) {
        return (A)withIncremental(new Boolean(arg1));
    }

    public A withNewIncremental(boolean arg1) {
        return (A)withIncremental(new Boolean(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildPullSecret instead.
 * @return The buildable object.
 */
@Deprecated public LocalObjectReference getPullSecret() {
        return this.pullSecret!=null?this.pullSecret.build():null;
    }

    public LocalObjectReference buildPullSecret() {
        return this.pullSecret!=null?this.pullSecret.build():null;
    }

    public A withPullSecret(LocalObjectReference pullSecret) {
        _visitables.get("pullSecret").remove(this.pullSecret);
        if (pullSecret!=null){ this.pullSecret= new LocalObjectReferenceBuilder(pullSecret); _visitables.get("pullSecret").add(this.pullSecret);} return (A) this;
    }

    public Boolean hasPullSecret() {
        return this.pullSecret != null;
    }

    public A withNewPullSecret(String name) {
        return (A)withPullSecret(new LocalObjectReference(name));
    }

    public io.fabric8.openshift.api.model.SourceBuildStrategyFluent.PullSecretNested<A> withNewPullSecret() {
        return new PullSecretNestedImpl();
    }

    public io.fabric8.openshift.api.model.SourceBuildStrategyFluent.PullSecretNested<A> withNewPullSecretLike(LocalObjectReference item) {
        return new PullSecretNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.SourceBuildStrategyFluent.PullSecretNested<A> editPullSecret() {
        return withNewPullSecretLike(getPullSecret());
    }

    public io.fabric8.openshift.api.model.SourceBuildStrategyFluent.PullSecretNested<A> editOrNewPullSecret() {
        return withNewPullSecretLike(getPullSecret() != null ? getPullSecret(): new LocalObjectReferenceBuilder().build());
    }

    public io.fabric8.openshift.api.model.SourceBuildStrategyFluent.PullSecretNested<A> editOrNewPullSecretLike(LocalObjectReference item) {
        return withNewPullSecretLike(getPullSecret() != null ? getPullSecret(): item);
    }

    public String getScripts() {
        return this.scripts;
    }

    public A withScripts(String scripts) {
        this.scripts=scripts; return (A) this;
    }

    public Boolean hasScripts() {
        return this.scripts != null;
    }

    public A withNewScripts(StringBuilder arg1) {
        return (A)withScripts(new String(arg1));
    }

    public A withNewScripts(int[] arg1,int arg2,int arg3) {
        return (A)withScripts(new String(arg1, arg2, arg3));
    }

    public A withNewScripts(char[] arg1) {
        return (A)withScripts(new String(arg1));
    }

    public A withNewScripts(StringBuffer arg1) {
        return (A)withScripts(new String(arg1));
    }

    public A withNewScripts(byte[] arg1,int arg2) {
        return (A)withScripts(new String(arg1, arg2));
    }

    public A withNewScripts(byte[] arg1) {
        return (A)withScripts(new String(arg1));
    }

    public A withNewScripts(char[] arg1,int arg2,int arg3) {
        return (A)withScripts(new String(arg1, arg2, arg3));
    }

    public A withNewScripts(byte[] arg1,int arg2,int arg3) {
        return (A)withScripts(new String(arg1, arg2, arg3));
    }

    public A withNewScripts(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withScripts(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewScripts(String arg1) {
        return (A)withScripts(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SourceBuildStrategyFluentImpl that = (SourceBuildStrategyFluentImpl) o;
        if (env != null ? !env.equals(that.env) :that.env != null) return false;
        if (forcePull != null ? !forcePull.equals(that.forcePull) :that.forcePull != null) return false;
        if (from != null ? !from.equals(that.from) :that.from != null) return false;
        if (incremental != null ? !incremental.equals(that.incremental) :that.incremental != null) return false;
        if (pullSecret != null ? !pullSecret.equals(that.pullSecret) :that.pullSecret != null) return false;
        if (scripts != null ? !scripts.equals(that.scripts) :that.scripts != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(env,  forcePull,  from,  incremental,  pullSecret,  scripts,  super.hashCode());
    }

    public class FromNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl<io.fabric8.openshift.api.model.SourceBuildStrategyFluent.FromNested<N>> implements io.fabric8.openshift.api.model.SourceBuildStrategyFluent.FromNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.ObjectReferenceBuilder builder;

            FromNestedImpl(io.fabric8.kubernetes.api.model.ObjectReference item) {
                this.builder = new ObjectReferenceBuilder(this, item);
                        
            }

            FromNestedImpl() {
                this.builder = new ObjectReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) SourceBuildStrategyFluentImpl.this.withFrom(builder.build());
            }

            public N endFrom() {
                return and();
            }
    }


    public class PullSecretNestedImpl<N> extends LocalObjectReferenceFluentImpl<io.fabric8.openshift.api.model.SourceBuildStrategyFluent.PullSecretNested<N>> implements io.fabric8.openshift.api.model.SourceBuildStrategyFluent.PullSecretNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final LocalObjectReferenceBuilder builder;

            PullSecretNestedImpl(LocalObjectReference item) {
                this.builder = new LocalObjectReferenceBuilder(this, item);
                        
            }

            PullSecretNestedImpl() {
                this.builder = new LocalObjectReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) SourceBuildStrategyFluentImpl.this.withPullSecret(builder.build());
            }

            public N endPullSecret() {
                return and();
            }
    }


}
