package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface SourceBuildStrategyFluent<A extends SourceBuildStrategyFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public A addToEnv(int index,EnvVar item);
    public A setToEnv(int index,EnvVar item);
    public A addToEnv(EnvVar... items);
    public A addAllToEnv(Collection<EnvVar> items);
    public A removeFromEnv(EnvVar... items);
    public A removeAllFromEnv(Collection<EnvVar> items);
    public List<EnvVar> getEnv();
    public EnvVar getEnv(int index);
    public EnvVar getFirstEnv();
    public EnvVar getLastEnv();
    public EnvVar getMatchingEnv(Predicate<EnvVar> predicate);
    public Boolean hasMatchingEnv(Predicate<EnvVar> predicate);
    public A withEnv(List<EnvVar> env);
    public A withEnv(EnvVar... env);
    public Boolean hasEnv();
    public Boolean getForcePull();
    public A withForcePull(Boolean forcePull);
    public Boolean hasForcePull();
    public A withNewForcePull(String arg1);
    public A withNewForcePull(boolean arg1);
    
/**
 * This method has been deprecated, please use method buildFrom instead.
 * @return The buildable object.
 */
@Deprecated public io.fabric8.kubernetes.api.model.ObjectReference getFrom();
    public io.fabric8.kubernetes.api.model.ObjectReference buildFrom();
    public A withFrom(io.fabric8.kubernetes.api.model.ObjectReference from);
    public Boolean hasFrom();
    public io.fabric8.openshift.api.model.SourceBuildStrategyFluent.FromNested<A> withNewFrom();
    public io.fabric8.openshift.api.model.SourceBuildStrategyFluent.FromNested<A> withNewFromLike(io.fabric8.kubernetes.api.model.ObjectReference item);
    public io.fabric8.openshift.api.model.SourceBuildStrategyFluent.FromNested<A> editFrom();
    public io.fabric8.openshift.api.model.SourceBuildStrategyFluent.FromNested<A> editOrNewFrom();
    public io.fabric8.openshift.api.model.SourceBuildStrategyFluent.FromNested<A> editOrNewFromLike(io.fabric8.kubernetes.api.model.ObjectReference item);
    public Boolean getIncremental();
    public A withIncremental(Boolean incremental);
    public Boolean hasIncremental();
    public A withNewIncremental(String arg1);
    public A withNewIncremental(boolean arg1);
    
/**
 * This method has been deprecated, please use method buildPullSecret instead.
 * @return The buildable object.
 */
@Deprecated public LocalObjectReference getPullSecret();
    public LocalObjectReference buildPullSecret();
    public A withPullSecret(LocalObjectReference pullSecret);
    public Boolean hasPullSecret();
    public A withNewPullSecret(String name);
    public io.fabric8.openshift.api.model.SourceBuildStrategyFluent.PullSecretNested<A> withNewPullSecret();
    public io.fabric8.openshift.api.model.SourceBuildStrategyFluent.PullSecretNested<A> withNewPullSecretLike(LocalObjectReference item);
    public io.fabric8.openshift.api.model.SourceBuildStrategyFluent.PullSecretNested<A> editPullSecret();
    public io.fabric8.openshift.api.model.SourceBuildStrategyFluent.PullSecretNested<A> editOrNewPullSecret();
    public io.fabric8.openshift.api.model.SourceBuildStrategyFluent.PullSecretNested<A> editOrNewPullSecretLike(LocalObjectReference item);
    public String getScripts();
    public A withScripts(String scripts);
    public Boolean hasScripts();
    public A withNewScripts(StringBuilder arg1);
    public A withNewScripts(int[] arg1,int arg2,int arg3);
    public A withNewScripts(char[] arg1);
    public A withNewScripts(StringBuffer arg1);
    public A withNewScripts(byte[] arg1,int arg2);
    public A withNewScripts(byte[] arg1);
    public A withNewScripts(char[] arg1,int arg2,int arg3);
    public A withNewScripts(byte[] arg1,int arg2,int arg3);
    public A withNewScripts(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewScripts(String arg1);
    public interface FromNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectReferenceFluent<io.fabric8.openshift.api.model.SourceBuildStrategyFluent.FromNested<N>> {

            public N and();
            public N endFrom();    }


    public interface PullSecretNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LocalObjectReferenceFluent<io.fabric8.openshift.api.model.SourceBuildStrategyFluent.PullSecretNested<N>> {

            public N and();
            public N endPullSecret();    }


}
