package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SchedulerSpecBuilder extends SchedulerSpecFluentImpl<SchedulerSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<SchedulerSpec,SchedulerSpecBuilder> {

    SchedulerSpecFluent<?> fluent;
    Boolean validationEnabled;

    public SchedulerSpecBuilder() {
        this(true);
    }

    public SchedulerSpecBuilder(Boolean validationEnabled) {
        this(new SchedulerSpec(), validationEnabled);
    }

    public SchedulerSpecBuilder(SchedulerSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public SchedulerSpecBuilder(SchedulerSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new SchedulerSpec(), validationEnabled);
    }

    public SchedulerSpecBuilder(SchedulerSpecFluent<?> fluent,SchedulerSpec instance) {
        this(fluent, instance, true);
    }

    public SchedulerSpecBuilder(SchedulerSpecFluent<?> fluent,SchedulerSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withDefaultNodeSelector(instance.getDefaultNodeSelector()); 
        fluent.withMastersSchedulable(instance.getMastersSchedulable()); 
        fluent.withPolicy(instance.getPolicy()); 
        this.validationEnabled = validationEnabled; 
    }

    public SchedulerSpecBuilder(SchedulerSpec instance) {
        this(instance,true);
    }

    public SchedulerSpecBuilder(SchedulerSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withDefaultNodeSelector(instance.getDefaultNodeSelector()); 
        this.withMastersSchedulable(instance.getMastersSchedulable()); 
        this.withPolicy(instance.getPolicy()); 
        this.validationEnabled = validationEnabled; 
    }

    public SchedulerSpec build() {
        SchedulerSpec buildable = new SchedulerSpec(fluent.getDefaultNodeSelector(),fluent.getMastersSchedulable(),fluent.getPolicy());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        SchedulerSpecBuilder that = (SchedulerSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
