package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SchedulerBuilder extends SchedulerFluentImpl<SchedulerBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<Scheduler,SchedulerBuilder> {

    SchedulerFluent<?> fluent;
    Boolean validationEnabled;

    public SchedulerBuilder() {
        this(true);
    }

    public SchedulerBuilder(Boolean validationEnabled) {
        this(new Scheduler(), validationEnabled);
    }

    public SchedulerBuilder(SchedulerFluent<?> fluent) {
        this(fluent, true);
    }

    public SchedulerBuilder(SchedulerFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new Scheduler(), validationEnabled);
    }

    public SchedulerBuilder(SchedulerFluent<?> fluent,Scheduler instance) {
        this(fluent, instance, true);
    }

    public SchedulerBuilder(SchedulerFluent<?> fluent,Scheduler instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public SchedulerBuilder(Scheduler instance) {
        this(instance,true);
    }

    public SchedulerBuilder(Scheduler instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public Scheduler build() {
        Scheduler buildable = new Scheduler(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        SchedulerBuilder that = (SchedulerBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
