package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ResourceAccessReviewBuilder extends ResourceAccessReviewFluentImpl<ResourceAccessReviewBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<ResourceAccessReview,ResourceAccessReviewBuilder> {

    ResourceAccessReviewFluent<?> fluent;
    Boolean validationEnabled;

    public ResourceAccessReviewBuilder() {
        this(true);
    }

    public ResourceAccessReviewBuilder(Boolean validationEnabled) {
        this(new ResourceAccessReview(), validationEnabled);
    }

    public ResourceAccessReviewBuilder(ResourceAccessReviewFluent<?> fluent) {
        this(fluent, true);
    }

    public ResourceAccessReviewBuilder(ResourceAccessReviewFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ResourceAccessReview(), validationEnabled);
    }

    public ResourceAccessReviewBuilder(ResourceAccessReviewFluent<?> fluent,ResourceAccessReview instance) {
        this(fluent, instance, true);
    }

    public ResourceAccessReviewBuilder(ResourceAccessReviewFluent<?> fluent,ResourceAccessReview instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withContent(instance.getContent()); 
        fluent.withIsNonResourceURL(instance.getIsNonResourceURL()); 
        fluent.withKind(instance.getKind()); 
        fluent.withNamespace(instance.getNamespace()); 
        fluent.withPath(instance.getPath()); 
        fluent.withResource(instance.getResource()); 
        fluent.withResourceAPIGroup(instance.getResourceAPIGroup()); 
        fluent.withResourceAPIVersion(instance.getResourceAPIVersion()); 
        fluent.withResourceName(instance.getResourceName()); 
        fluent.withVerb(instance.getVerb()); 
        this.validationEnabled = validationEnabled; 
    }

    public ResourceAccessReviewBuilder(ResourceAccessReview instance) {
        this(instance,true);
    }

    public ResourceAccessReviewBuilder(ResourceAccessReview instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withContent(instance.getContent()); 
        this.withIsNonResourceURL(instance.getIsNonResourceURL()); 
        this.withKind(instance.getKind()); 
        this.withNamespace(instance.getNamespace()); 
        this.withPath(instance.getPath()); 
        this.withResource(instance.getResource()); 
        this.withResourceAPIGroup(instance.getResourceAPIGroup()); 
        this.withResourceAPIVersion(instance.getResourceAPIVersion()); 
        this.withResourceName(instance.getResourceName()); 
        this.withVerb(instance.getVerb()); 
        this.validationEnabled = validationEnabled; 
    }

    public ResourceAccessReview build() {
        ResourceAccessReview buildable = new ResourceAccessReview(fluent.getApiVersion(),fluent.getContent(),fluent.getIsNonResourceURL(),fluent.getKind(),fluent.getNamespace(),fluent.getPath(),fluent.getResource(),fluent.getResourceAPIGroup(),fluent.getResourceAPIVersion(),fluent.getResourceName(),fluent.getVerb());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ResourceAccessReviewBuilder that = (ResourceAccessReviewBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
