package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class InfrastructureStatusFluentImpl<A extends InfrastructureStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements InfrastructureStatusFluent<A> {

    private String apiServerInternalURI;
    private String apiServerURL;
    private String etcdDiscoveryDomain;
    private String infrastructureName;
    private String platform;
    private PlatformStatusBuilder platformStatus;

    public InfrastructureStatusFluentImpl() {
    }

    public InfrastructureStatusFluentImpl(InfrastructureStatus instance) {
        this.withApiServerInternalURI(instance.getApiServerInternalURI()); 
        this.withApiServerURL(instance.getApiServerURL()); 
        this.withEtcdDiscoveryDomain(instance.getEtcdDiscoveryDomain()); 
        this.withInfrastructureName(instance.getInfrastructureName()); 
        this.withPlatform(instance.getPlatform()); 
        this.withPlatformStatus(instance.getPlatformStatus()); 
    }

    public String getApiServerInternalURI() {
        return this.apiServerInternalURI;
    }

    public A withApiServerInternalURI(String apiServerInternalURI) {
        this.apiServerInternalURI=apiServerInternalURI; return (A) this;
    }

    public Boolean hasApiServerInternalURI() {
        return this.apiServerInternalURI != null;
    }

    public A withNewApiServerInternalURI(StringBuilder arg1) {
        return (A)withApiServerInternalURI(new String(arg1));
    }

    public A withNewApiServerInternalURI(int[] arg1,int arg2,int arg3) {
        return (A)withApiServerInternalURI(new String(arg1, arg2, arg3));
    }

    public A withNewApiServerInternalURI(char[] arg1) {
        return (A)withApiServerInternalURI(new String(arg1));
    }

    public A withNewApiServerInternalURI(StringBuffer arg1) {
        return (A)withApiServerInternalURI(new String(arg1));
    }

    public A withNewApiServerInternalURI(byte[] arg1,int arg2) {
        return (A)withApiServerInternalURI(new String(arg1, arg2));
    }

    public A withNewApiServerInternalURI(byte[] arg1) {
        return (A)withApiServerInternalURI(new String(arg1));
    }

    public A withNewApiServerInternalURI(char[] arg1,int arg2,int arg3) {
        return (A)withApiServerInternalURI(new String(arg1, arg2, arg3));
    }

    public A withNewApiServerInternalURI(byte[] arg1,int arg2,int arg3) {
        return (A)withApiServerInternalURI(new String(arg1, arg2, arg3));
    }

    public A withNewApiServerInternalURI(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withApiServerInternalURI(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewApiServerInternalURI(String arg1) {
        return (A)withApiServerInternalURI(new String(arg1));
    }

    public String getApiServerURL() {
        return this.apiServerURL;
    }

    public A withApiServerURL(String apiServerURL) {
        this.apiServerURL=apiServerURL; return (A) this;
    }

    public Boolean hasApiServerURL() {
        return this.apiServerURL != null;
    }

    public A withNewApiServerURL(StringBuilder arg1) {
        return (A)withApiServerURL(new String(arg1));
    }

    public A withNewApiServerURL(int[] arg1,int arg2,int arg3) {
        return (A)withApiServerURL(new String(arg1, arg2, arg3));
    }

    public A withNewApiServerURL(char[] arg1) {
        return (A)withApiServerURL(new String(arg1));
    }

    public A withNewApiServerURL(StringBuffer arg1) {
        return (A)withApiServerURL(new String(arg1));
    }

    public A withNewApiServerURL(byte[] arg1,int arg2) {
        return (A)withApiServerURL(new String(arg1, arg2));
    }

    public A withNewApiServerURL(byte[] arg1) {
        return (A)withApiServerURL(new String(arg1));
    }

    public A withNewApiServerURL(char[] arg1,int arg2,int arg3) {
        return (A)withApiServerURL(new String(arg1, arg2, arg3));
    }

    public A withNewApiServerURL(byte[] arg1,int arg2,int arg3) {
        return (A)withApiServerURL(new String(arg1, arg2, arg3));
    }

    public A withNewApiServerURL(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withApiServerURL(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewApiServerURL(String arg1) {
        return (A)withApiServerURL(new String(arg1));
    }

    public String getEtcdDiscoveryDomain() {
        return this.etcdDiscoveryDomain;
    }

    public A withEtcdDiscoveryDomain(String etcdDiscoveryDomain) {
        this.etcdDiscoveryDomain=etcdDiscoveryDomain; return (A) this;
    }

    public Boolean hasEtcdDiscoveryDomain() {
        return this.etcdDiscoveryDomain != null;
    }

    public A withNewEtcdDiscoveryDomain(StringBuilder arg1) {
        return (A)withEtcdDiscoveryDomain(new String(arg1));
    }

    public A withNewEtcdDiscoveryDomain(int[] arg1,int arg2,int arg3) {
        return (A)withEtcdDiscoveryDomain(new String(arg1, arg2, arg3));
    }

    public A withNewEtcdDiscoveryDomain(char[] arg1) {
        return (A)withEtcdDiscoveryDomain(new String(arg1));
    }

    public A withNewEtcdDiscoveryDomain(StringBuffer arg1) {
        return (A)withEtcdDiscoveryDomain(new String(arg1));
    }

    public A withNewEtcdDiscoveryDomain(byte[] arg1,int arg2) {
        return (A)withEtcdDiscoveryDomain(new String(arg1, arg2));
    }

    public A withNewEtcdDiscoveryDomain(byte[] arg1) {
        return (A)withEtcdDiscoveryDomain(new String(arg1));
    }

    public A withNewEtcdDiscoveryDomain(char[] arg1,int arg2,int arg3) {
        return (A)withEtcdDiscoveryDomain(new String(arg1, arg2, arg3));
    }

    public A withNewEtcdDiscoveryDomain(byte[] arg1,int arg2,int arg3) {
        return (A)withEtcdDiscoveryDomain(new String(arg1, arg2, arg3));
    }

    public A withNewEtcdDiscoveryDomain(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withEtcdDiscoveryDomain(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewEtcdDiscoveryDomain(String arg1) {
        return (A)withEtcdDiscoveryDomain(new String(arg1));
    }

    public String getInfrastructureName() {
        return this.infrastructureName;
    }

    public A withInfrastructureName(String infrastructureName) {
        this.infrastructureName=infrastructureName; return (A) this;
    }

    public Boolean hasInfrastructureName() {
        return this.infrastructureName != null;
    }

    public A withNewInfrastructureName(StringBuilder arg1) {
        return (A)withInfrastructureName(new String(arg1));
    }

    public A withNewInfrastructureName(int[] arg1,int arg2,int arg3) {
        return (A)withInfrastructureName(new String(arg1, arg2, arg3));
    }

    public A withNewInfrastructureName(char[] arg1) {
        return (A)withInfrastructureName(new String(arg1));
    }

    public A withNewInfrastructureName(StringBuffer arg1) {
        return (A)withInfrastructureName(new String(arg1));
    }

    public A withNewInfrastructureName(byte[] arg1,int arg2) {
        return (A)withInfrastructureName(new String(arg1, arg2));
    }

    public A withNewInfrastructureName(byte[] arg1) {
        return (A)withInfrastructureName(new String(arg1));
    }

    public A withNewInfrastructureName(char[] arg1,int arg2,int arg3) {
        return (A)withInfrastructureName(new String(arg1, arg2, arg3));
    }

    public A withNewInfrastructureName(byte[] arg1,int arg2,int arg3) {
        return (A)withInfrastructureName(new String(arg1, arg2, arg3));
    }

    public A withNewInfrastructureName(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withInfrastructureName(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewInfrastructureName(String arg1) {
        return (A)withInfrastructureName(new String(arg1));
    }

    public String getPlatform() {
        return this.platform;
    }

    public A withPlatform(String platform) {
        this.platform=platform; return (A) this;
    }

    public Boolean hasPlatform() {
        return this.platform != null;
    }

    public A withNewPlatform(StringBuilder arg1) {
        return (A)withPlatform(new String(arg1));
    }

    public A withNewPlatform(int[] arg1,int arg2,int arg3) {
        return (A)withPlatform(new String(arg1, arg2, arg3));
    }

    public A withNewPlatform(char[] arg1) {
        return (A)withPlatform(new String(arg1));
    }

    public A withNewPlatform(StringBuffer arg1) {
        return (A)withPlatform(new String(arg1));
    }

    public A withNewPlatform(byte[] arg1,int arg2) {
        return (A)withPlatform(new String(arg1, arg2));
    }

    public A withNewPlatform(byte[] arg1) {
        return (A)withPlatform(new String(arg1));
    }

    public A withNewPlatform(char[] arg1,int arg2,int arg3) {
        return (A)withPlatform(new String(arg1, arg2, arg3));
    }

    public A withNewPlatform(byte[] arg1,int arg2,int arg3) {
        return (A)withPlatform(new String(arg1, arg2, arg3));
    }

    public A withNewPlatform(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withPlatform(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewPlatform(String arg1) {
        return (A)withPlatform(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildPlatformStatus instead.
 * @return The buildable object.
 */
@Deprecated public PlatformStatus getPlatformStatus() {
        return this.platformStatus!=null?this.platformStatus.build():null;
    }

    public PlatformStatus buildPlatformStatus() {
        return this.platformStatus!=null?this.platformStatus.build():null;
    }

    public A withPlatformStatus(PlatformStatus platformStatus) {
        _visitables.get("platformStatus").remove(this.platformStatus);
        if (platformStatus!=null){ this.platformStatus= new PlatformStatusBuilder(platformStatus); _visitables.get("platformStatus").add(this.platformStatus);} return (A) this;
    }

    public Boolean hasPlatformStatus() {
        return this.platformStatus != null;
    }

    public io.fabric8.openshift.api.model.InfrastructureStatusFluent.PlatformStatusNested<A> withNewPlatformStatus() {
        return new PlatformStatusNestedImpl();
    }

    public io.fabric8.openshift.api.model.InfrastructureStatusFluent.PlatformStatusNested<A> withNewPlatformStatusLike(PlatformStatus item) {
        return new PlatformStatusNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.InfrastructureStatusFluent.PlatformStatusNested<A> editPlatformStatus() {
        return withNewPlatformStatusLike(getPlatformStatus());
    }

    public io.fabric8.openshift.api.model.InfrastructureStatusFluent.PlatformStatusNested<A> editOrNewPlatformStatus() {
        return withNewPlatformStatusLike(getPlatformStatus() != null ? getPlatformStatus(): new PlatformStatusBuilder().build());
    }

    public io.fabric8.openshift.api.model.InfrastructureStatusFluent.PlatformStatusNested<A> editOrNewPlatformStatusLike(PlatformStatus item) {
        return withNewPlatformStatusLike(getPlatformStatus() != null ? getPlatformStatus(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        InfrastructureStatusFluentImpl that = (InfrastructureStatusFluentImpl) o;
        if (apiServerInternalURI != null ? !apiServerInternalURI.equals(that.apiServerInternalURI) :that.apiServerInternalURI != null) return false;
        if (apiServerURL != null ? !apiServerURL.equals(that.apiServerURL) :that.apiServerURL != null) return false;
        if (etcdDiscoveryDomain != null ? !etcdDiscoveryDomain.equals(that.etcdDiscoveryDomain) :that.etcdDiscoveryDomain != null) return false;
        if (infrastructureName != null ? !infrastructureName.equals(that.infrastructureName) :that.infrastructureName != null) return false;
        if (platform != null ? !platform.equals(that.platform) :that.platform != null) return false;
        if (platformStatus != null ? !platformStatus.equals(that.platformStatus) :that.platformStatus != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiServerInternalURI,  apiServerURL,  etcdDiscoveryDomain,  infrastructureName,  platform,  platformStatus,  super.hashCode());
    }

    public class PlatformStatusNestedImpl<N> extends PlatformStatusFluentImpl<io.fabric8.openshift.api.model.InfrastructureStatusFluent.PlatformStatusNested<N>> implements io.fabric8.openshift.api.model.InfrastructureStatusFluent.PlatformStatusNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PlatformStatusBuilder builder;

            PlatformStatusNestedImpl(PlatformStatus item) {
                this.builder = new PlatformStatusBuilder(this, item);
                        
            }

            PlatformStatusNestedImpl() {
                this.builder = new PlatformStatusBuilder(this);
                        
            }

            public N and() {
                return (N) InfrastructureStatusFluentImpl.this.withPlatformStatus(builder.build());
            }

            public N endPlatformStatus() {
                return and();
            }
    }


}
