package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ImageTagListBuilder extends ImageTagListFluentImpl<ImageTagListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<ImageTagList,ImageTagListBuilder> {

    ImageTagListFluent<?> fluent;
    Boolean validationEnabled;

    public ImageTagListBuilder() {
        this(true);
    }

    public ImageTagListBuilder(Boolean validationEnabled) {
        this(new ImageTagList(), validationEnabled);
    }

    public ImageTagListBuilder(ImageTagListFluent<?> fluent) {
        this(fluent, true);
    }

    public ImageTagListBuilder(ImageTagListFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ImageTagList(), validationEnabled);
    }

    public ImageTagListBuilder(ImageTagListFluent<?> fluent,ImageTagList instance) {
        this(fluent, instance, true);
    }

    public ImageTagListBuilder(ImageTagListFluent<?> fluent,ImageTagList instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public ImageTagListBuilder(ImageTagList instance) {
        this(instance,true);
    }

    public ImageTagListBuilder(ImageTagList instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public ImageTagList build() {
        ImageTagList buildable = new ImageTagList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ImageTagListBuilder that = (ImageTagListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
