package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface ImageStreamTagFluent<A extends ImageStreamTagFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(int[] arg1,int arg2,int arg3);
    public A withNewApiVersion(char[] arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A withNewApiVersion(byte[] arg1,int arg2);
    public A withNewApiVersion(byte[] arg1);
    public A withNewApiVersion(char[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewApiVersion(String arg1);
    public A addToConditions(int index,TagEventCondition item);
    public A setToConditions(int index,TagEventCondition item);
    public A addToConditions(TagEventCondition... items);
    public A addAllToConditions(Collection<TagEventCondition> items);
    public A removeFromConditions(TagEventCondition... items);
    public A removeAllFromConditions(Collection<TagEventCondition> items);
    public A removeMatchingFromConditions(Predicate<TagEventConditionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<TagEventCondition> getConditions();
    public List<TagEventCondition> buildConditions();
    public TagEventCondition buildCondition(int index);
    public TagEventCondition buildFirstCondition();
    public TagEventCondition buildLastCondition();
    public TagEventCondition buildMatchingCondition(Predicate<TagEventConditionBuilder> predicate);
    public Boolean hasMatchingCondition(Predicate<TagEventConditionBuilder> predicate);
    public A withConditions(List<TagEventCondition> conditions);
    public A withConditions(TagEventCondition... conditions);
    public Boolean hasConditions();
    public io.fabric8.openshift.api.model.ImageStreamTagFluent.ConditionsNested<A> addNewCondition();
    public io.fabric8.openshift.api.model.ImageStreamTagFluent.ConditionsNested<A> addNewConditionLike(TagEventCondition item);
    public io.fabric8.openshift.api.model.ImageStreamTagFluent.ConditionsNested<A> setNewConditionLike(int index,TagEventCondition item);
    public io.fabric8.openshift.api.model.ImageStreamTagFluent.ConditionsNested<A> editCondition(int index);
    public io.fabric8.openshift.api.model.ImageStreamTagFluent.ConditionsNested<A> editFirstCondition();
    public io.fabric8.openshift.api.model.ImageStreamTagFluent.ConditionsNested<A> editLastCondition();
    public io.fabric8.openshift.api.model.ImageStreamTagFluent.ConditionsNested<A> editMatchingCondition(Predicate<TagEventConditionBuilder> predicate);
    public Long getGeneration();
    public A withGeneration(Long generation);
    public Boolean hasGeneration();
    public A withNewGeneration(long arg1);
    
/**
 * This method has been deprecated, please use method buildImage instead.
 * @return The buildable object.
 */
@Deprecated public Image getImage();
    public Image buildImage();
    public A withImage(Image image);
    public Boolean hasImage();
    public io.fabric8.openshift.api.model.ImageStreamTagFluent.ImageNested<A> withNewImage();
    public io.fabric8.openshift.api.model.ImageStreamTagFluent.ImageNested<A> withNewImageLike(Image item);
    public io.fabric8.openshift.api.model.ImageStreamTagFluent.ImageNested<A> editImage();
    public io.fabric8.openshift.api.model.ImageStreamTagFluent.ImageNested<A> editOrNewImage();
    public io.fabric8.openshift.api.model.ImageStreamTagFluent.ImageNested<A> editOrNewImageLike(Image item);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(int[] arg1,int arg2,int arg3);
    public A withNewKind(char[] arg1);
    public A withNewKind(StringBuffer arg1);
    public A withNewKind(byte[] arg1,int arg2);
    public A withNewKind(byte[] arg1);
    public A withNewKind(char[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewKind(String arg1);
    
/**
 * This method has been deprecated, please use method buildLookupPolicy instead.
 * @return The buildable object.
 */
@Deprecated public ImageLookupPolicy getLookupPolicy();
    public ImageLookupPolicy buildLookupPolicy();
    public A withLookupPolicy(ImageLookupPolicy lookupPolicy);
    public Boolean hasLookupPolicy();
    public A withNewLookupPolicy(Boolean local);
    public io.fabric8.openshift.api.model.ImageStreamTagFluent.LookupPolicyNested<A> withNewLookupPolicy();
    public io.fabric8.openshift.api.model.ImageStreamTagFluent.LookupPolicyNested<A> withNewLookupPolicyLike(ImageLookupPolicy item);
    public io.fabric8.openshift.api.model.ImageStreamTagFluent.LookupPolicyNested<A> editLookupPolicy();
    public io.fabric8.openshift.api.model.ImageStreamTagFluent.LookupPolicyNested<A> editOrNewLookupPolicy();
    public io.fabric8.openshift.api.model.ImageStreamTagFluent.LookupPolicyNested<A> editOrNewLookupPolicyLike(ImageLookupPolicy item);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public io.fabric8.openshift.api.model.ImageStreamTagFluent.MetadataNested<A> withNewMetadata();
    public io.fabric8.openshift.api.model.ImageStreamTagFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public io.fabric8.openshift.api.model.ImageStreamTagFluent.MetadataNested<A> editMetadata();
    public io.fabric8.openshift.api.model.ImageStreamTagFluent.MetadataNested<A> editOrNewMetadata();
    public io.fabric8.openshift.api.model.ImageStreamTagFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildTag instead.
 * @return The buildable object.
 */
@Deprecated public TagReference getTag();
    public TagReference buildTag();
    public A withTag(TagReference tag);
    public Boolean hasTag();
    public io.fabric8.openshift.api.model.ImageStreamTagFluent.TagNested<A> withNewTag();
    public io.fabric8.openshift.api.model.ImageStreamTagFluent.TagNested<A> withNewTagLike(TagReference item);
    public io.fabric8.openshift.api.model.ImageStreamTagFluent.TagNested<A> editTag();
    public io.fabric8.openshift.api.model.ImageStreamTagFluent.TagNested<A> editOrNewTag();
    public io.fabric8.openshift.api.model.ImageStreamTagFluent.TagNested<A> editOrNewTagLike(TagReference item);
    public interface ConditionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TagEventConditionFluent<io.fabric8.openshift.api.model.ImageStreamTagFluent.ConditionsNested<N>> {

            public N and();
            public N endCondition();    }


    public interface ImageNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageFluent<io.fabric8.openshift.api.model.ImageStreamTagFluent.ImageNested<N>> {

            public N and();
            public N endImage();    }


    public interface LookupPolicyNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageLookupPolicyFluent<io.fabric8.openshift.api.model.ImageStreamTagFluent.LookupPolicyNested<N>> {

            public N and();
            public N endLookupPolicy();    }


    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<io.fabric8.openshift.api.model.ImageStreamTagFluent.MetadataNested<N>> {

            public N and();
            public N endMetadata();    }


    public interface TagNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TagReferenceFluent<io.fabric8.openshift.api.model.ImageStreamTagFluent.TagNested<N>> {

            public N and();
            public N endTag();    }


}
