package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface ImageSourceFluent<A extends ImageSourceFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public A addToAs(int index,String item);
    public A setToAs(int index,String item);
    public A addToAs(String... items);
    public A addAllToAs(Collection<String> items);
    public A removeFromAs(String... items);
    public A removeAllFromAs(Collection<String> items);
    public List<String> getAs();
    public String getA(int index);
    public String getFirstA();
    public String getLastA();
    public String getMatchingA(Predicate<String> predicate);
    public Boolean hasMatchingA(Predicate<String> predicate);
    public A withAs(List<String> as);
    public A withAs(String... as);
    public Boolean hasAs();
    public A addNewA(StringBuilder arg1);
    public A addNewA(int[] arg1,int arg2,int arg3);
    public A addNewA(char[] arg1);
    public A addNewA(StringBuffer arg1);
    public A addNewA(byte[] arg1,int arg2);
    public A addNewA(byte[] arg1);
    public A addNewA(char[] arg1,int arg2,int arg3);
    public A addNewA(byte[] arg1,int arg2,int arg3);
    public A addNewA(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewA(String arg1);
    
/**
 * This method has been deprecated, please use method buildFrom instead.
 * @return The buildable object.
 */
@Deprecated public io.fabric8.kubernetes.api.model.ObjectReference getFrom();
    public io.fabric8.kubernetes.api.model.ObjectReference buildFrom();
    public A withFrom(io.fabric8.kubernetes.api.model.ObjectReference from);
    public Boolean hasFrom();
    public io.fabric8.openshift.api.model.ImageSourceFluent.FromNested<A> withNewFrom();
    public io.fabric8.openshift.api.model.ImageSourceFluent.FromNested<A> withNewFromLike(io.fabric8.kubernetes.api.model.ObjectReference item);
    public io.fabric8.openshift.api.model.ImageSourceFluent.FromNested<A> editFrom();
    public io.fabric8.openshift.api.model.ImageSourceFluent.FromNested<A> editOrNewFrom();
    public io.fabric8.openshift.api.model.ImageSourceFluent.FromNested<A> editOrNewFromLike(io.fabric8.kubernetes.api.model.ObjectReference item);
    public A addToPaths(int index,ImageSourcePath item);
    public A setToPaths(int index,ImageSourcePath item);
    public A addToPaths(ImageSourcePath... items);
    public A addAllToPaths(Collection<ImageSourcePath> items);
    public A removeFromPaths(ImageSourcePath... items);
    public A removeAllFromPaths(Collection<ImageSourcePath> items);
    public A removeMatchingFromPaths(Predicate<ImageSourcePathBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildPaths instead.
 * @return The buildable object.
 */
@Deprecated public List<ImageSourcePath> getPaths();
    public List<ImageSourcePath> buildPaths();
    public ImageSourcePath buildPath(int index);
    public ImageSourcePath buildFirstPath();
    public ImageSourcePath buildLastPath();
    public ImageSourcePath buildMatchingPath(Predicate<ImageSourcePathBuilder> predicate);
    public Boolean hasMatchingPath(Predicate<ImageSourcePathBuilder> predicate);
    public A withPaths(List<ImageSourcePath> paths);
    public A withPaths(ImageSourcePath... paths);
    public Boolean hasPaths();
    public A addNewPath(String destinationDir,String sourcePath);
    public io.fabric8.openshift.api.model.ImageSourceFluent.PathsNested<A> addNewPath();
    public io.fabric8.openshift.api.model.ImageSourceFluent.PathsNested<A> addNewPathLike(ImageSourcePath item);
    public io.fabric8.openshift.api.model.ImageSourceFluent.PathsNested<A> setNewPathLike(int index,ImageSourcePath item);
    public io.fabric8.openshift.api.model.ImageSourceFluent.PathsNested<A> editPath(int index);
    public io.fabric8.openshift.api.model.ImageSourceFluent.PathsNested<A> editFirstPath();
    public io.fabric8.openshift.api.model.ImageSourceFluent.PathsNested<A> editLastPath();
    public io.fabric8.openshift.api.model.ImageSourceFluent.PathsNested<A> editMatchingPath(Predicate<ImageSourcePathBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildPullSecret instead.
 * @return The buildable object.
 */
@Deprecated public LocalObjectReference getPullSecret();
    public LocalObjectReference buildPullSecret();
    public A withPullSecret(LocalObjectReference pullSecret);
    public Boolean hasPullSecret();
    public A withNewPullSecret(String name);
    public io.fabric8.openshift.api.model.ImageSourceFluent.PullSecretNested<A> withNewPullSecret();
    public io.fabric8.openshift.api.model.ImageSourceFluent.PullSecretNested<A> withNewPullSecretLike(LocalObjectReference item);
    public io.fabric8.openshift.api.model.ImageSourceFluent.PullSecretNested<A> editPullSecret();
    public io.fabric8.openshift.api.model.ImageSourceFluent.PullSecretNested<A> editOrNewPullSecret();
    public io.fabric8.openshift.api.model.ImageSourceFluent.PullSecretNested<A> editOrNewPullSecretLike(LocalObjectReference item);
    public interface FromNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectReferenceFluent<io.fabric8.openshift.api.model.ImageSourceFluent.FromNested<N>> {

            public N and();
            public N endFrom();    }


    public interface PathsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageSourcePathFluent<io.fabric8.openshift.api.model.ImageSourceFluent.PathsNested<N>> {

            public N and();
            public N endPath();    }


    public interface PullSecretNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LocalObjectReferenceFluent<io.fabric8.openshift.api.model.ImageSourceFluent.PullSecretNested<N>> {

            public N and();
            public N endPullSecret();    }


}
