package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class GroupFluentImpl<A extends GroupFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements GroupFluent<A> {

    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private List<String> users = new ArrayList<String>();

    public GroupFluentImpl() {
    }

    public GroupFluentImpl(io.fabric8.openshift.api.model.Group instance) {
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withUsers(instance.getUsers()); 
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A withNewApiVersion(StringBuilder arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(int[] arg1,int arg2,int arg3) {
        return (A)withApiVersion(new String(arg1, arg2, arg3));
    }

    public A withNewApiVersion(char[] arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(byte[] arg1,int arg2) {
        return (A)withApiVersion(new String(arg1, arg2));
    }

    public A withNewApiVersion(byte[] arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(char[] arg1,int arg2,int arg3) {
        return (A)withApiVersion(new String(arg1, arg2, arg3));
    }

    public A withNewApiVersion(byte[] arg1,int arg2,int arg3) {
        return (A)withApiVersion(new String(arg1, arg2, arg3));
    }

    public A withNewApiVersion(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withApiVersion(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewApiVersion(String arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind=kind; return (A) this;
    }

    public Boolean hasKind() {
        return this.kind != null;
    }

    public A withNewKind(StringBuilder arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(int[] arg1,int arg2,int arg3) {
        return (A)withKind(new String(arg1, arg2, arg3));
    }

    public A withNewKind(char[] arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(byte[] arg1,int arg2) {
        return (A)withKind(new String(arg1, arg2));
    }

    public A withNewKind(byte[] arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(char[] arg1,int arg2,int arg3) {
        return (A)withKind(new String(arg1, arg2, arg3));
    }

    public A withNewKind(byte[] arg1,int arg2,int arg3) {
        return (A)withKind(new String(arg1, arg2, arg3));
    }

    public A withNewKind(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withKind(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewKind(String arg1) {
        return (A)withKind(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata) {
        _visitables.get("metadata").remove(this.metadata);
        if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    public io.fabric8.openshift.api.model.GroupFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    public io.fabric8.openshift.api.model.GroupFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.GroupFluent.MetadataNested<A> editMetadata() {
        return withNewMetadataLike(getMetadata());
    }

    public io.fabric8.openshift.api.model.GroupFluent.MetadataNested<A> editOrNewMetadata() {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
    }

    public io.fabric8.openshift.api.model.GroupFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public A addToUsers(int index,String item) {
        if (this.users == null) {this.users = new ArrayList<String>();}
        this.users.add(index, item);
        return (A)this;
    }

    public A setToUsers(int index,String item) {
        if (this.users == null) {this.users = new ArrayList<String>();}
        this.users.set(index, item); return (A)this;
    }

    public A addToUsers(String... items) {
        if (this.users == null) {this.users = new ArrayList<String>();}
        for (String item : items) {this.users.add(item);} return (A)this;
    }

    public A addAllToUsers(Collection<String> items) {
        if (this.users == null) {this.users = new ArrayList<String>();}
        for (String item : items) {this.users.add(item);} return (A)this;
    }

    public A removeFromUsers(String... items) {
        for (String item : items) {if (this.users!= null){ this.users.remove(item);}} return (A)this;
    }

    public A removeAllFromUsers(Collection<String> items) {
        for (String item : items) {if (this.users!= null){ this.users.remove(item);}} return (A)this;
    }

    public List<String> getUsers() {
        return this.users;
    }

    public String getUser(int index) {
        return this.users.get(index);
    }

    public String getFirstUser() {
        return this.users.get(0);
    }

    public String getLastUser() {
        return this.users.get(users.size() - 1);
    }

    public String getMatchingUser(Predicate<String> predicate) {
        for (String item: users) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingUser(Predicate<String> predicate) {
        for (String item: users) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withUsers(List<String> users) {
        if (this.users != null) { _visitables.get("users").removeAll(this.users);}
        if (users != null) {this.users = new ArrayList<String>(); for (String item : users){this.addToUsers(item);}} else { this.users = null;} return (A) this;
    }

    public A withUsers(String... users) {
        if (this.users != null) {this.users.clear();}
        if (users != null) {for (String item :users){ this.addToUsers(item);}} return (A) this;
    }

    public Boolean hasUsers() {
        return users != null && !users.isEmpty();
    }

    public A addNewUser(StringBuilder arg1) {
        return (A)addToUsers(new String(arg1));
    }

    public A addNewUser(int[] arg1,int arg2,int arg3) {
        return (A)addToUsers(new String(arg1, arg2, arg3));
    }

    public A addNewUser(char[] arg1) {
        return (A)addToUsers(new String(arg1));
    }

    public A addNewUser(StringBuffer arg1) {
        return (A)addToUsers(new String(arg1));
    }

    public A addNewUser(byte[] arg1,int arg2) {
        return (A)addToUsers(new String(arg1, arg2));
    }

    public A addNewUser(byte[] arg1) {
        return (A)addToUsers(new String(arg1));
    }

    public A addNewUser(char[] arg1,int arg2,int arg3) {
        return (A)addToUsers(new String(arg1, arg2, arg3));
    }

    public A addNewUser(byte[] arg1,int arg2,int arg3) {
        return (A)addToUsers(new String(arg1, arg2, arg3));
    }

    public A addNewUser(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToUsers(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewUser(String arg1) {
        return (A)addToUsers(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GroupFluentImpl that = (GroupFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        if (users != null ? !users.equals(that.users) :that.users != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  kind,  metadata,  users,  super.hashCode());
    }

    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<io.fabric8.openshift.api.model.GroupFluent.MetadataNested<N>> implements io.fabric8.openshift.api.model.GroupFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ObjectMetaBuilder builder;

            MetadataNestedImpl(ObjectMeta item) {
                this.builder = new ObjectMetaBuilder(this, item);
                        
            }

            MetadataNestedImpl() {
                this.builder = new ObjectMetaBuilder(this);
                        
            }

            public N and() {
                return (N) GroupFluentImpl.this.withMetadata(builder.build());
            }

            public N endMetadata() {
                return and();
            }
    }


}
