package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class EgressNetworkPolicyRuleBuilder extends EgressNetworkPolicyRuleFluentImpl<EgressNetworkPolicyRuleBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<EgressNetworkPolicyRule,EgressNetworkPolicyRuleBuilder> {

    EgressNetworkPolicyRuleFluent<?> fluent;
    Boolean validationEnabled;

    public EgressNetworkPolicyRuleBuilder() {
        this(true);
    }

    public EgressNetworkPolicyRuleBuilder(Boolean validationEnabled) {
        this(new EgressNetworkPolicyRule(), validationEnabled);
    }

    public EgressNetworkPolicyRuleBuilder(EgressNetworkPolicyRuleFluent<?> fluent) {
        this(fluent, true);
    }

    public EgressNetworkPolicyRuleBuilder(EgressNetworkPolicyRuleFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new EgressNetworkPolicyRule(), validationEnabled);
    }

    public EgressNetworkPolicyRuleBuilder(EgressNetworkPolicyRuleFluent<?> fluent,EgressNetworkPolicyRule instance) {
        this(fluent, instance, true);
    }

    public EgressNetworkPolicyRuleBuilder(EgressNetworkPolicyRuleFluent<?> fluent,EgressNetworkPolicyRule instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withTo(instance.getTo()); 
        fluent.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public EgressNetworkPolicyRuleBuilder(EgressNetworkPolicyRule instance) {
        this(instance,true);
    }

    public EgressNetworkPolicyRuleBuilder(EgressNetworkPolicyRule instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withTo(instance.getTo()); 
        this.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public EgressNetworkPolicyRule build() {
        EgressNetworkPolicyRule buildable = new EgressNetworkPolicyRule(fluent.getTo(),fluent.getType());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        EgressNetworkPolicyRuleBuilder that = (EgressNetworkPolicyRuleBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
