package io.fabric8.openshift.api.model;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class EgressNetworkPolicyPeerFluentImpl<A extends EgressNetworkPolicyPeerFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements EgressNetworkPolicyPeerFluent<A> {

    private String cidrSelector;
    private String dnsName;

    public EgressNetworkPolicyPeerFluentImpl() {
    }

    public EgressNetworkPolicyPeerFluentImpl(EgressNetworkPolicyPeer instance) {
        this.withCidrSelector(instance.getCidrSelector()); 
        this.withDnsName(instance.getDnsName()); 
    }

    public String getCidrSelector() {
        return this.cidrSelector;
    }

    public A withCidrSelector(String cidrSelector) {
        this.cidrSelector=cidrSelector; return (A) this;
    }

    public Boolean hasCidrSelector() {
        return this.cidrSelector != null;
    }

    public A withNewCidrSelector(StringBuilder arg1) {
        return (A)withCidrSelector(new String(arg1));
    }

    public A withNewCidrSelector(int[] arg1,int arg2,int arg3) {
        return (A)withCidrSelector(new String(arg1, arg2, arg3));
    }

    public A withNewCidrSelector(char[] arg1) {
        return (A)withCidrSelector(new String(arg1));
    }

    public A withNewCidrSelector(StringBuffer arg1) {
        return (A)withCidrSelector(new String(arg1));
    }

    public A withNewCidrSelector(byte[] arg1,int arg2) {
        return (A)withCidrSelector(new String(arg1, arg2));
    }

    public A withNewCidrSelector(byte[] arg1) {
        return (A)withCidrSelector(new String(arg1));
    }

    public A withNewCidrSelector(char[] arg1,int arg2,int arg3) {
        return (A)withCidrSelector(new String(arg1, arg2, arg3));
    }

    public A withNewCidrSelector(byte[] arg1,int arg2,int arg3) {
        return (A)withCidrSelector(new String(arg1, arg2, arg3));
    }

    public A withNewCidrSelector(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withCidrSelector(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewCidrSelector(String arg1) {
        return (A)withCidrSelector(new String(arg1));
    }

    public String getDnsName() {
        return this.dnsName;
    }

    public A withDnsName(String dnsName) {
        this.dnsName=dnsName; return (A) this;
    }

    public Boolean hasDnsName() {
        return this.dnsName != null;
    }

    public A withNewDnsName(StringBuilder arg1) {
        return (A)withDnsName(new String(arg1));
    }

    public A withNewDnsName(int[] arg1,int arg2,int arg3) {
        return (A)withDnsName(new String(arg1, arg2, arg3));
    }

    public A withNewDnsName(char[] arg1) {
        return (A)withDnsName(new String(arg1));
    }

    public A withNewDnsName(StringBuffer arg1) {
        return (A)withDnsName(new String(arg1));
    }

    public A withNewDnsName(byte[] arg1,int arg2) {
        return (A)withDnsName(new String(arg1, arg2));
    }

    public A withNewDnsName(byte[] arg1) {
        return (A)withDnsName(new String(arg1));
    }

    public A withNewDnsName(char[] arg1,int arg2,int arg3) {
        return (A)withDnsName(new String(arg1, arg2, arg3));
    }

    public A withNewDnsName(byte[] arg1,int arg2,int arg3) {
        return (A)withDnsName(new String(arg1, arg2, arg3));
    }

    public A withNewDnsName(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withDnsName(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewDnsName(String arg1) {
        return (A)withDnsName(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        EgressNetworkPolicyPeerFluentImpl that = (EgressNetworkPolicyPeerFluentImpl) o;
        if (cidrSelector != null ? !cidrSelector.equals(that.cidrSelector) :that.cidrSelector != null) return false;
        if (dnsName != null ? !dnsName.equals(that.dnsName) :that.dnsName != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(cidrSelector,  dnsName,  super.hashCode());
    }

}
