package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CustomFeatureGatesBuilder extends CustomFeatureGatesFluentImpl<CustomFeatureGatesBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<CustomFeatureGates,CustomFeatureGatesBuilder> {

    CustomFeatureGatesFluent<?> fluent;
    Boolean validationEnabled;

    public CustomFeatureGatesBuilder() {
        this(true);
    }

    public CustomFeatureGatesBuilder(Boolean validationEnabled) {
        this(new CustomFeatureGates(), validationEnabled);
    }

    public CustomFeatureGatesBuilder(CustomFeatureGatesFluent<?> fluent) {
        this(fluent, true);
    }

    public CustomFeatureGatesBuilder(CustomFeatureGatesFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new CustomFeatureGates(), validationEnabled);
    }

    public CustomFeatureGatesBuilder(CustomFeatureGatesFluent<?> fluent,CustomFeatureGates instance) {
        this(fluent, instance, true);
    }

    public CustomFeatureGatesBuilder(CustomFeatureGatesFluent<?> fluent,CustomFeatureGates instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withDisabled(instance.getDisabled()); 
        fluent.withEnabled(instance.getEnabled()); 
        this.validationEnabled = validationEnabled; 
    }

    public CustomFeatureGatesBuilder(CustomFeatureGates instance) {
        this(instance,true);
    }

    public CustomFeatureGatesBuilder(CustomFeatureGates instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withDisabled(instance.getDisabled()); 
        this.withEnabled(instance.getEnabled()); 
        this.validationEnabled = validationEnabled; 
    }

    public CustomFeatureGates build() {
        CustomFeatureGates buildable = new CustomFeatureGates(fluent.getDisabled(),fluent.getEnabled());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CustomFeatureGatesBuilder that = (CustomFeatureGatesBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
