package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ConfigMapFileReferenceBuilder extends ConfigMapFileReferenceFluentImpl<ConfigMapFileReferenceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<ConfigMapFileReference,ConfigMapFileReferenceBuilder> {

    ConfigMapFileReferenceFluent<?> fluent;
    Boolean validationEnabled;

    public ConfigMapFileReferenceBuilder() {
        this(true);
    }

    public ConfigMapFileReferenceBuilder(Boolean validationEnabled) {
        this(new ConfigMapFileReference(), validationEnabled);
    }

    public ConfigMapFileReferenceBuilder(ConfigMapFileReferenceFluent<?> fluent) {
        this(fluent, true);
    }

    public ConfigMapFileReferenceBuilder(ConfigMapFileReferenceFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ConfigMapFileReference(), validationEnabled);
    }

    public ConfigMapFileReferenceBuilder(ConfigMapFileReferenceFluent<?> fluent,ConfigMapFileReference instance) {
        this(fluent, instance, true);
    }

    public ConfigMapFileReferenceBuilder(ConfigMapFileReferenceFluent<?> fluent,ConfigMapFileReference instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withKey(instance.getKey()); 
        fluent.withName(instance.getName()); 
        this.validationEnabled = validationEnabled; 
    }

    public ConfigMapFileReferenceBuilder(ConfigMapFileReference instance) {
        this(instance,true);
    }

    public ConfigMapFileReferenceBuilder(ConfigMapFileReference instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withKey(instance.getKey()); 
        this.withName(instance.getName()); 
        this.validationEnabled = validationEnabled; 
    }

    public ConfigMapFileReference build() {
        ConfigMapFileReference buildable = new ConfigMapFileReference(fluent.getKey(),fluent.getName());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ConfigMapFileReferenceBuilder that = (ConfigMapFileReferenceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
