package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.lang.Deprecated;
import java.util.function.Predicate;
import java.util.List;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.util.Iterator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.Collection;
import io.fabric8.kubernetes.api.builder.Nested;

public interface ClusterOperatorStatusFluent<A extends ClusterOperatorStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public A addToConditions(int index,ClusterOperatorStatusCondition item);
    public A setToConditions(int index,ClusterOperatorStatusCondition item);
    public A addToConditions(ClusterOperatorStatusCondition... items);
    public A addAllToConditions(Collection<ClusterOperatorStatusCondition> items);
    public A removeFromConditions(ClusterOperatorStatusCondition... items);
    public A removeAllFromConditions(Collection<ClusterOperatorStatusCondition> items);
    public A removeMatchingFromConditions(Predicate<ClusterOperatorStatusConditionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<ClusterOperatorStatusCondition> getConditions();
    public List<ClusterOperatorStatusCondition> buildConditions();
    public ClusterOperatorStatusCondition buildCondition(int index);
    public ClusterOperatorStatusCondition buildFirstCondition();
    public ClusterOperatorStatusCondition buildLastCondition();
    public ClusterOperatorStatusCondition buildMatchingCondition(Predicate<ClusterOperatorStatusConditionBuilder> predicate);
    public Boolean hasMatchingCondition(Predicate<ClusterOperatorStatusConditionBuilder> predicate);
    public A withConditions(List<ClusterOperatorStatusCondition> conditions);
    public A withConditions(ClusterOperatorStatusCondition... conditions);
    public Boolean hasConditions();
    public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ConditionsNested<A> addNewCondition();
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ConditionsNested<A> addNewConditionLike(ClusterOperatorStatusCondition item);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ConditionsNested<A> setNewConditionLike(int index,ClusterOperatorStatusCondition item);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ConditionsNested<A> editCondition(int index);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ConditionsNested<A> editFirstCondition();
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ConditionsNested<A> editLastCondition();
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<ClusterOperatorStatusConditionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildExtension instead.
 * @return The buildable object.
 */
@Deprecated public HasMetadata getExtension();
    public HasMetadata buildExtension();
    public A withExtension(HasMetadata extension);
    public Boolean hasExtension();
    public A withClusterVersionExtension(ClusterVersion clusterVersionExtension);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ClusterVersionExtensionNested<A> withNewClusterVersionExtension();
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ClusterVersionExtensionNested<A> withNewClusterVersionExtensionLike(ClusterVersion item);
    public A withImageStreamImportExtension(ImageStreamImport imageStreamImportExtension);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageStreamImportExtensionNested<A> withNewImageStreamImportExtension();
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageStreamImportExtensionNested<A> withNewImageStreamImportExtensionLike(ImageStreamImport item);
    public A withProxyExtension(Proxy proxyExtension);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ProxyExtensionNested<A> withNewProxyExtension();
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ProxyExtensionNested<A> withNewProxyExtensionLike(Proxy item);
    public A withProjectExtension(Project projectExtension);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ProjectExtensionNested<A> withNewProjectExtension();
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ProjectExtensionNested<A> withNewProjectExtensionLike(Project item);
    public A withClusterOperatorExtension(ClusterOperator clusterOperatorExtension);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ClusterOperatorExtensionNested<A> withNewClusterOperatorExtension();
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ClusterOperatorExtensionNested<A> withNewClusterOperatorExtensionLike(ClusterOperator item);
    public A withBuildConfigExtension(BuildConfig buildConfigExtension);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.BuildConfigExtensionNested<A> withNewBuildConfigExtension();
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.BuildConfigExtensionNested<A> withNewBuildConfigExtensionLike(BuildConfig item);
    public A withInfrastructureExtension(Infrastructure infrastructureExtension);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.InfrastructureExtensionNested<A> withNewInfrastructureExtension();
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.InfrastructureExtensionNested<A> withNewInfrastructureExtensionLike(Infrastructure item);
    public A withSchedulerExtension(Scheduler schedulerExtension);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.SchedulerExtensionNested<A> withNewSchedulerExtension();
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.SchedulerExtensionNested<A> withNewSchedulerExtensionLike(Scheduler item);
    public A withRangeAllocationExtension(RangeAllocation rangeAllocationExtension);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RangeAllocationExtensionNested<A> withNewRangeAllocationExtension();
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RangeAllocationExtensionNested<A> withNewRangeAllocationExtensionLike(RangeAllocation item);
    public A withRouteExtension(Route routeExtension);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RouteExtensionNested<A> withNewRouteExtension();
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RouteExtensionNested<A> withNewRouteExtensionLike(Route item);
    public A withClusterNetworkExtension(ClusterNetwork clusterNetworkExtension);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ClusterNetworkExtensionNested<A> withNewClusterNetworkExtension();
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ClusterNetworkExtensionNested<A> withNewClusterNetworkExtensionLike(ClusterNetwork item);
    public A withOAuthAuthorizeTokenExtension(OAuthAuthorizeToken oAuthAuthorizeTokenExtension);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.OAuthAuthorizeTokenExtensionNested<A> withNewOAuthAuthorizeTokenExtension();
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.OAuthAuthorizeTokenExtensionNested<A> withNewOAuthAuthorizeTokenExtensionLike(OAuthAuthorizeToken item);
    public A withIngressExtension(Ingress ingressExtension);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.IngressExtensionNested<A> withNewIngressExtension();
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.IngressExtensionNested<A> withNewIngressExtensionLike(Ingress item);
    public A withOAuthExtension(OAuth oAuthExtension);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.OAuthExtensionNested<A> withNewOAuthExtension();
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.OAuthExtensionNested<A> withNewOAuthExtensionLike(OAuth item);
    public A withOperatorHubExtension(OperatorHub operatorHubExtension);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.OperatorHubExtensionNested<A> withNewOperatorHubExtension();
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.OperatorHubExtensionNested<A> withNewOperatorHubExtensionLike(OperatorHub item);
    public A withClusterRoleBindingExtension(ClusterRoleBinding clusterRoleBindingExtension);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ClusterRoleBindingExtensionNested<A> withNewClusterRoleBindingExtension();
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ClusterRoleBindingExtensionNested<A> withNewClusterRoleBindingExtensionLike(ClusterRoleBinding item);
    public A withClusterResourceQuotaExtension(ClusterResourceQuota clusterResourceQuotaExtension);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ClusterResourceQuotaExtensionNested<A> withNewClusterResourceQuotaExtension();
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ClusterResourceQuotaExtensionNested<A> withNewClusterResourceQuotaExtensionLike(ClusterResourceQuota item);
    public A withProjectRequestExtension(ProjectRequest projectRequestExtension);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ProjectRequestExtensionNested<A> withNewProjectRequestExtension();
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ProjectRequestExtensionNested<A> withNewProjectRequestExtensionLike(ProjectRequest item);
    public A withTemplateExtension(Template templateExtension);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.TemplateExtensionNested<A> withNewTemplateExtension();
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.TemplateExtensionNested<A> withNewTemplateExtensionLike(Template item);
    public A withOAuthClientAuthorizationExtension(OAuthClientAuthorization oAuthClientAuthorizationExtension);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.OAuthClientAuthorizationExtensionNested<A> withNewOAuthClientAuthorizationExtension();
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.OAuthClientAuthorizationExtensionNested<A> withNewOAuthClientAuthorizationExtensionLike(OAuthClientAuthorization item);
    public A withClusterRoleExtension(ClusterRole clusterRoleExtension);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ClusterRoleExtensionNested<A> withNewClusterRoleExtension();
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ClusterRoleExtensionNested<A> withNewClusterRoleExtensionLike(ClusterRole item);
    public A withImageTagExtension(ImageTag imageTagExtension);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageTagExtensionNested<A> withNewImageTagExtension();
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageTagExtensionNested<A> withNewImageTagExtensionLike(ImageTag item);
    public A withDeploymentConfigExtension(DeploymentConfig deploymentConfigExtension);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.DeploymentConfigExtensionNested<A> withNewDeploymentConfigExtension();
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.DeploymentConfigExtensionNested<A> withNewDeploymentConfigExtensionLike(DeploymentConfig item);
    public A withOAuthAccessTokenExtension(OAuthAccessToken oAuthAccessTokenExtension);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.OAuthAccessTokenExtensionNested<A> withNewOAuthAccessTokenExtension();
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.OAuthAccessTokenExtensionNested<A> withNewOAuthAccessTokenExtensionLike(OAuthAccessToken item);
    public A withRoleBindingExtension(RoleBinding roleBindingExtension);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RoleBindingExtensionNested<A> withNewRoleBindingExtension();
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RoleBindingExtensionNested<A> withNewRoleBindingExtensionLike(RoleBinding item);
    public A withImageExtension(Image imageExtension);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageExtensionNested<A> withNewImageExtension();
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageExtensionNested<A> withNewImageExtensionLike(Image item);
    public A withAPIServerExtension(APIServer aPIServerExtension);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.APIServerExtensionNested<A> withNewAPIServerExtension();
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.APIServerExtensionNested<A> withNewAPIServerExtensionLike(APIServer item);
    public A withPersistentVolumeClaimExtension(PersistentVolumeClaim persistentVolumeClaimExtension);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.PersistentVolumeClaimExtensionNested<A> withNewPersistentVolumeClaimExtension();
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.PersistentVolumeClaimExtensionNested<A> withNewPersistentVolumeClaimExtensionLike(PersistentVolumeClaim item);
    public A withImageStreamMappingExtension(ImageStreamMapping imageStreamMappingExtension);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageStreamMappingExtensionNested<A> withNewImageStreamMappingExtension();
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageStreamMappingExtensionNested<A> withNewImageStreamMappingExtensionLike(ImageStreamMapping item);
    public A withRoleExtension(Role roleExtension);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RoleExtensionNested<A> withNewRoleExtension();
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RoleExtensionNested<A> withNewRoleExtensionLike(Role item);
    public A withFeatureGateExtension(FeatureGate featureGateExtension);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.FeatureGateExtensionNested<A> withNewFeatureGateExtension();
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.FeatureGateExtensionNested<A> withNewFeatureGateExtensionLike(FeatureGate item);
    public A withUserExtension(User userExtension);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.UserExtensionNested<A> withNewUserExtension();
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.UserExtensionNested<A> withNewUserExtensionLike(User item);
    public A withImageStreamImageExtension(ImageStreamImage imageStreamImageExtension);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageStreamImageExtensionNested<A> withNewImageStreamImageExtension();
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageStreamImageExtensionNested<A> withNewImageStreamImageExtensionLike(ImageStreamImage item);
    public A withBuildExtension(Build buildExtension);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.BuildExtensionNested<A> withNewBuildExtension();
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.BuildExtensionNested<A> withNewBuildExtensionLike(Build item);
    public A withRoleBindingRestrictionExtension(RoleBindingRestriction roleBindingRestrictionExtension);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RoleBindingRestrictionExtensionNested<A> withNewRoleBindingRestrictionExtension();
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RoleBindingRestrictionExtensionNested<A> withNewRoleBindingRestrictionExtensionLike(RoleBindingRestriction item);
    public A withImageStreamTagExtension(ImageStreamTag imageStreamTagExtension);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageStreamTagExtensionNested<A> withNewImageStreamTagExtension();
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageStreamTagExtensionNested<A> withNewImageStreamTagExtensionLike(ImageStreamTag item);
    public A withGroupExtension(io.fabric8.openshift.api.model.Group groupExtension);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.GroupExtensionNested<A> withNewGroupExtension();
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.GroupExtensionNested<A> withNewGroupExtensionLike(io.fabric8.openshift.api.model.Group item);
    public A withImageSignatureExtension(ImageSignature imageSignatureExtension);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageSignatureExtensionNested<A> withNewImageSignatureExtension();
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageSignatureExtensionNested<A> withNewImageSignatureExtensionLike(ImageSignature item);
    public A withAppliedClusterResourceQuotaExtension(AppliedClusterResourceQuota appliedClusterResourceQuotaExtension);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.AppliedClusterResourceQuotaExtensionNested<A> withNewAppliedClusterResourceQuotaExtension();
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.AppliedClusterResourceQuotaExtensionNested<A> withNewAppliedClusterResourceQuotaExtensionLike(AppliedClusterResourceQuota item);
    public A withSecurityContextConstraintsExtension(SecurityContextConstraints securityContextConstraintsExtension);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.SecurityContextConstraintsExtensionNested<A> withNewSecurityContextConstraintsExtension();
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.SecurityContextConstraintsExtensionNested<A> withNewSecurityContextConstraintsExtensionLike(SecurityContextConstraints item);
    public A withBuildRequestExtension(BuildRequest buildRequestExtension);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.BuildRequestExtensionNested<A> withNewBuildRequestExtension();
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.BuildRequestExtensionNested<A> withNewBuildRequestExtensionLike(BuildRequest item);
    public A withEgressNetworkPolicyExtension(EgressNetworkPolicy egressNetworkPolicyExtension);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.EgressNetworkPolicyExtensionNested<A> withNewEgressNetworkPolicyExtension();
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.EgressNetworkPolicyExtensionNested<A> withNewEgressNetworkPolicyExtensionLike(EgressNetworkPolicy item);
    public A withNetNamespaceExtension(NetNamespace netNamespaceExtension);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.NetNamespaceExtensionNested<A> withNewNetNamespaceExtension();
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.NetNamespaceExtensionNested<A> withNewNetNamespaceExtensionLike(NetNamespace item);
    public A withImageStreamExtension(ImageStream imageStreamExtension);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageStreamExtensionNested<A> withNewImageStreamExtension();
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageStreamExtensionNested<A> withNewImageStreamExtensionLike(ImageStream item);
    public A withOAuthClientExtension(OAuthClient oAuthClientExtension);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.OAuthClientExtensionNested<A> withNewOAuthClientExtension();
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.OAuthClientExtensionNested<A> withNewOAuthClientExtensionLike(OAuthClient item);
    public A withIdentityExtension(Identity identityExtension);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.IdentityExtensionNested<A> withNewIdentityExtension();
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.IdentityExtensionNested<A> withNewIdentityExtensionLike(Identity item);
    public A addToRelatedObjects(int index,io.fabric8.openshift.api.model.ObjectReference item);
    public A setToRelatedObjects(int index,io.fabric8.openshift.api.model.ObjectReference item);
    public A addToRelatedObjects(io.fabric8.openshift.api.model.ObjectReference... items);
    public A addAllToRelatedObjects(Collection<io.fabric8.openshift.api.model.ObjectReference> items);
    public A removeFromRelatedObjects(io.fabric8.openshift.api.model.ObjectReference... items);
    public A removeAllFromRelatedObjects(Collection<io.fabric8.openshift.api.model.ObjectReference> items);
    public A removeMatchingFromRelatedObjects(Predicate<io.fabric8.openshift.api.model.ObjectReferenceBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildRelatedObjects instead.
 * @return The buildable object.
 */
@Deprecated public List<io.fabric8.openshift.api.model.ObjectReference> getRelatedObjects();
    public List<io.fabric8.openshift.api.model.ObjectReference> buildRelatedObjects();
    public io.fabric8.openshift.api.model.ObjectReference buildRelatedObject(int index);
    public io.fabric8.openshift.api.model.ObjectReference buildFirstRelatedObject();
    public io.fabric8.openshift.api.model.ObjectReference buildLastRelatedObject();
    public io.fabric8.openshift.api.model.ObjectReference buildMatchingRelatedObject(Predicate<io.fabric8.openshift.api.model.ObjectReferenceBuilder> predicate);
    public Boolean hasMatchingRelatedObject(Predicate<io.fabric8.openshift.api.model.ObjectReferenceBuilder> predicate);
    public A withRelatedObjects(List<io.fabric8.openshift.api.model.ObjectReference> relatedObjects);
    public A withRelatedObjects(io.fabric8.openshift.api.model.ObjectReference... relatedObjects);
    public Boolean hasRelatedObjects();
    public A addNewRelatedObject(String group,String name,String namespace,String resource);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RelatedObjectsNested<A> addNewRelatedObject();
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RelatedObjectsNested<A> addNewRelatedObjectLike(io.fabric8.openshift.api.model.ObjectReference item);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RelatedObjectsNested<A> setNewRelatedObjectLike(int index,io.fabric8.openshift.api.model.ObjectReference item);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RelatedObjectsNested<A> editRelatedObject(int index);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RelatedObjectsNested<A> editFirstRelatedObject();
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RelatedObjectsNested<A> editLastRelatedObject();
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RelatedObjectsNested<A> editMatchingRelatedObject(Predicate<io.fabric8.openshift.api.model.ObjectReferenceBuilder> predicate);
    public A addToVersions(int index,OperandVersion item);
    public A setToVersions(int index,OperandVersion item);
    public A addToVersions(OperandVersion... items);
    public A addAllToVersions(Collection<OperandVersion> items);
    public A removeFromVersions(OperandVersion... items);
    public A removeAllFromVersions(Collection<OperandVersion> items);
    public A removeMatchingFromVersions(Predicate<OperandVersionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildVersions instead.
 * @return The buildable object.
 */
@Deprecated public List<OperandVersion> getVersions();
    public List<OperandVersion> buildVersions();
    public OperandVersion buildVersion(int index);
    public OperandVersion buildFirstVersion();
    public OperandVersion buildLastVersion();
    public OperandVersion buildMatchingVersion(Predicate<OperandVersionBuilder> predicate);
    public Boolean hasMatchingVersion(Predicate<OperandVersionBuilder> predicate);
    public A withVersions(List<OperandVersion> versions);
    public A withVersions(OperandVersion... versions);
    public Boolean hasVersions();
    public A addNewVersion(String name,String version);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.VersionsNested<A> addNewVersion();
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.VersionsNested<A> addNewVersionLike(OperandVersion item);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.VersionsNested<A> setNewVersionLike(int index,OperandVersion item);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.VersionsNested<A> editVersion(int index);
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.VersionsNested<A> editFirstVersion();
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.VersionsNested<A> editLastVersion();
    public io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.VersionsNested<A> editMatchingVersion(Predicate<OperandVersionBuilder> predicate);
    public interface ConditionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterOperatorStatusConditionFluent<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ConditionsNested<N>> {

            public N and();
            public N endCondition();    }


    public interface ClusterVersionExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterVersionFluent<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ClusterVersionExtensionNested<N>> {

            public N and();
            public N endClusterVersionExtension();    }


    public interface ImageStreamImportExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageStreamImportFluent<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageStreamImportExtensionNested<N>> {

            public N and();
            public N endImageStreamImportExtension();    }


    public interface ProxyExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ProxyFluent<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ProxyExtensionNested<N>> {

            public N and();
            public N endProxyExtension();    }


    public interface ProjectExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ProjectFluent<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ProjectExtensionNested<N>> {

            public N and();
            public N endProjectExtension();    }


    public interface ClusterOperatorExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterOperatorFluent<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ClusterOperatorExtensionNested<N>> {

            public N and();
            public N endClusterOperatorExtension();    }


    public interface BuildConfigExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BuildConfigFluent<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.BuildConfigExtensionNested<N>> {

            public N and();
            public N endBuildConfigExtension();    }


    public interface InfrastructureExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,InfrastructureFluent<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.InfrastructureExtensionNested<N>> {

            public N and();
            public N endInfrastructureExtension();    }


    public interface SchedulerExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SchedulerFluent<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.SchedulerExtensionNested<N>> {

            public N and();
            public N endSchedulerExtension();    }


    public interface RangeAllocationExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RangeAllocationFluent<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RangeAllocationExtensionNested<N>> {

            public N and();
            public N endRangeAllocationExtension();    }


    public interface RouteExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RouteFluent<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RouteExtensionNested<N>> {

            public N and();
            public N endRouteExtension();    }


    public interface ClusterNetworkExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterNetworkFluent<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ClusterNetworkExtensionNested<N>> {

            public N and();
            public N endClusterNetworkExtension();    }


    public interface OAuthAuthorizeTokenExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OAuthAuthorizeTokenFluent<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.OAuthAuthorizeTokenExtensionNested<N>> {

            public N and();
            public N endOAuthAuthorizeTokenExtension();    }


    public interface IngressExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,IngressFluent<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.IngressExtensionNested<N>> {

            public N and();
            public N endIngressExtension();    }


    public interface OAuthExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OAuthFluent<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.OAuthExtensionNested<N>> {

            public N and();
            public N endOAuthExtension();    }


    public interface OperatorHubExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OperatorHubFluent<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.OperatorHubExtensionNested<N>> {

            public N and();
            public N endOperatorHubExtension();    }


    public interface ClusterRoleBindingExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterRoleBindingFluent<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ClusterRoleBindingExtensionNested<N>> {

            public N and();
            public N endClusterRoleBindingExtension();    }


    public interface ClusterResourceQuotaExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterResourceQuotaFluent<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ClusterResourceQuotaExtensionNested<N>> {

            public N and();
            public N endClusterResourceQuotaExtension();    }


    public interface ProjectRequestExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ProjectRequestFluent<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ProjectRequestExtensionNested<N>> {

            public N and();
            public N endProjectRequestExtension();    }


    public interface TemplateExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TemplateFluent<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.TemplateExtensionNested<N>> {

            public N and();
            public N endTemplateExtension();    }


    public interface OAuthClientAuthorizationExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OAuthClientAuthorizationFluent<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.OAuthClientAuthorizationExtensionNested<N>> {

            public N and();
            public N endOAuthClientAuthorizationExtension();    }


    public interface ClusterRoleExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterRoleFluent<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ClusterRoleExtensionNested<N>> {

            public N and();
            public N endClusterRoleExtension();    }


    public interface ImageTagExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageTagFluent<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageTagExtensionNested<N>> {

            public N and();
            public N endImageTagExtension();    }


    public interface DeploymentConfigExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DeploymentConfigFluent<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.DeploymentConfigExtensionNested<N>> {

            public N and();
            public N endDeploymentConfigExtension();    }


    public interface OAuthAccessTokenExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OAuthAccessTokenFluent<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.OAuthAccessTokenExtensionNested<N>> {

            public N and();
            public N endOAuthAccessTokenExtension();    }


    public interface RoleBindingExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RoleBindingFluent<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RoleBindingExtensionNested<N>> {

            public N and();
            public N endRoleBindingExtension();    }


    public interface ImageExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageFluent<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageExtensionNested<N>> {

            public N and();
            public N endImageExtension();    }


    public interface APIServerExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,APIServerFluent<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.APIServerExtensionNested<N>> {

            public N and();
            public N endAPIServerExtension();    }


    public interface PersistentVolumeClaimExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PersistentVolumeClaimFluent<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.PersistentVolumeClaimExtensionNested<N>> {

            public N and();
            public N endPersistentVolumeClaimExtension();    }


    public interface ImageStreamMappingExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageStreamMappingFluent<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageStreamMappingExtensionNested<N>> {

            public N and();
            public N endImageStreamMappingExtension();    }


    public interface RoleExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RoleFluent<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RoleExtensionNested<N>> {

            public N and();
            public N endRoleExtension();    }


    public interface FeatureGateExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,FeatureGateFluent<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.FeatureGateExtensionNested<N>> {

            public N and();
            public N endFeatureGateExtension();    }


    public interface UserExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,UserFluent<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.UserExtensionNested<N>> {

            public N and();
            public N endUserExtension();    }


    public interface ImageStreamImageExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageStreamImageFluent<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageStreamImageExtensionNested<N>> {

            public N and();
            public N endImageStreamImageExtension();    }


    public interface BuildExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BuildFluent<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.BuildExtensionNested<N>> {

            public N and();
            public N endBuildExtension();    }


    public interface RoleBindingRestrictionExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RoleBindingRestrictionFluent<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RoleBindingRestrictionExtensionNested<N>> {

            public N and();
            public N endRoleBindingRestrictionExtension();    }


    public interface ImageStreamTagExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageStreamTagFluent<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageStreamTagExtensionNested<N>> {

            public N and();
            public N endImageStreamTagExtension();    }


    public interface GroupExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,GroupFluent<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.GroupExtensionNested<N>> {

            public N and();
            public N endGroupExtension();    }


    public interface ImageSignatureExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageSignatureFluent<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageSignatureExtensionNested<N>> {

            public N and();
            public N endImageSignatureExtension();    }


    public interface AppliedClusterResourceQuotaExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,AppliedClusterResourceQuotaFluent<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.AppliedClusterResourceQuotaExtensionNested<N>> {

            public N and();
            public N endAppliedClusterResourceQuotaExtension();    }


    public interface SecurityContextConstraintsExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SecurityContextConstraintsFluent<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.SecurityContextConstraintsExtensionNested<N>> {

            public N and();
            public N endSecurityContextConstraintsExtension();    }


    public interface BuildRequestExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BuildRequestFluent<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.BuildRequestExtensionNested<N>> {

            public N and();
            public N endBuildRequestExtension();    }


    public interface EgressNetworkPolicyExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EgressNetworkPolicyFluent<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.EgressNetworkPolicyExtensionNested<N>> {

            public N and();
            public N endEgressNetworkPolicyExtension();    }


    public interface NetNamespaceExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NetNamespaceFluent<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.NetNamespaceExtensionNested<N>> {

            public N and();
            public N endNetNamespaceExtension();    }


    public interface ImageStreamExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageStreamFluent<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.ImageStreamExtensionNested<N>> {

            public N and();
            public N endImageStreamExtension();    }


    public interface OAuthClientExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OAuthClientFluent<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.OAuthClientExtensionNested<N>> {

            public N and();
            public N endOAuthClientExtension();    }


    public interface IdentityExtensionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,IdentityFluent<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.IdentityExtensionNested<N>> {

            public N and();
            public N endIdentityExtension();    }


    public interface RelatedObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.ObjectReferenceFluent<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.RelatedObjectsNested<N>> {

            public N and();
            public N endRelatedObject();    }


    public interface VersionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OperandVersionFluent<io.fabric8.openshift.api.model.ClusterOperatorStatusFluent.VersionsNested<N>> {

            public N and();
            public N endVersion();    }


}
