package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.lang.Object;

public class BuildStrategyFluentImpl<A extends BuildStrategyFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements BuildStrategyFluent<A> {

    private CustomBuildStrategyBuilder customStrategy;
    private DockerBuildStrategyBuilder dockerStrategy;
    private JenkinsPipelineBuildStrategyBuilder jenkinsPipelineStrategy;
    private SourceBuildStrategyBuilder sourceStrategy;
    private String type;

    public BuildStrategyFluentImpl() {
    }

    public BuildStrategyFluentImpl(BuildStrategy instance) {
        this.withCustomStrategy(instance.getCustomStrategy()); 
        this.withDockerStrategy(instance.getDockerStrategy()); 
        this.withJenkinsPipelineStrategy(instance.getJenkinsPipelineStrategy()); 
        this.withSourceStrategy(instance.getSourceStrategy()); 
        this.withType(instance.getType()); 
    }

    
/**
 * This method has been deprecated, please use method buildCustomStrategy instead.
 * @return The buildable object.
 */
@Deprecated public CustomBuildStrategy getCustomStrategy() {
        return this.customStrategy!=null?this.customStrategy.build():null;
    }

    public CustomBuildStrategy buildCustomStrategy() {
        return this.customStrategy!=null?this.customStrategy.build():null;
    }

    public A withCustomStrategy(CustomBuildStrategy customStrategy) {
        _visitables.get("customStrategy").remove(this.customStrategy);
        if (customStrategy!=null){ this.customStrategy= new CustomBuildStrategyBuilder(customStrategy); _visitables.get("customStrategy").add(this.customStrategy);} return (A) this;
    }

    public Boolean hasCustomStrategy() {
        return this.customStrategy != null;
    }

    public io.fabric8.openshift.api.model.BuildStrategyFluent.CustomStrategyNested<A> withNewCustomStrategy() {
        return new CustomStrategyNestedImpl();
    }

    public io.fabric8.openshift.api.model.BuildStrategyFluent.CustomStrategyNested<A> withNewCustomStrategyLike(CustomBuildStrategy item) {
        return new CustomStrategyNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.BuildStrategyFluent.CustomStrategyNested<A> editCustomStrategy() {
        return withNewCustomStrategyLike(getCustomStrategy());
    }

    public io.fabric8.openshift.api.model.BuildStrategyFluent.CustomStrategyNested<A> editOrNewCustomStrategy() {
        return withNewCustomStrategyLike(getCustomStrategy() != null ? getCustomStrategy(): new CustomBuildStrategyBuilder().build());
    }

    public io.fabric8.openshift.api.model.BuildStrategyFluent.CustomStrategyNested<A> editOrNewCustomStrategyLike(CustomBuildStrategy item) {
        return withNewCustomStrategyLike(getCustomStrategy() != null ? getCustomStrategy(): item);
    }

    
/**
 * This method has been deprecated, please use method buildDockerStrategy instead.
 * @return The buildable object.
 */
@Deprecated public DockerBuildStrategy getDockerStrategy() {
        return this.dockerStrategy!=null?this.dockerStrategy.build():null;
    }

    public DockerBuildStrategy buildDockerStrategy() {
        return this.dockerStrategy!=null?this.dockerStrategy.build():null;
    }

    public A withDockerStrategy(DockerBuildStrategy dockerStrategy) {
        _visitables.get("dockerStrategy").remove(this.dockerStrategy);
        if (dockerStrategy!=null){ this.dockerStrategy= new DockerBuildStrategyBuilder(dockerStrategy); _visitables.get("dockerStrategy").add(this.dockerStrategy);} return (A) this;
    }

    public Boolean hasDockerStrategy() {
        return this.dockerStrategy != null;
    }

    public io.fabric8.openshift.api.model.BuildStrategyFluent.DockerStrategyNested<A> withNewDockerStrategy() {
        return new DockerStrategyNestedImpl();
    }

    public io.fabric8.openshift.api.model.BuildStrategyFluent.DockerStrategyNested<A> withNewDockerStrategyLike(DockerBuildStrategy item) {
        return new DockerStrategyNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.BuildStrategyFluent.DockerStrategyNested<A> editDockerStrategy() {
        return withNewDockerStrategyLike(getDockerStrategy());
    }

    public io.fabric8.openshift.api.model.BuildStrategyFluent.DockerStrategyNested<A> editOrNewDockerStrategy() {
        return withNewDockerStrategyLike(getDockerStrategy() != null ? getDockerStrategy(): new DockerBuildStrategyBuilder().build());
    }

    public io.fabric8.openshift.api.model.BuildStrategyFluent.DockerStrategyNested<A> editOrNewDockerStrategyLike(DockerBuildStrategy item) {
        return withNewDockerStrategyLike(getDockerStrategy() != null ? getDockerStrategy(): item);
    }

    
/**
 * This method has been deprecated, please use method buildJenkinsPipelineStrategy instead.
 * @return The buildable object.
 */
@Deprecated public JenkinsPipelineBuildStrategy getJenkinsPipelineStrategy() {
        return this.jenkinsPipelineStrategy!=null?this.jenkinsPipelineStrategy.build():null;
    }

    public JenkinsPipelineBuildStrategy buildJenkinsPipelineStrategy() {
        return this.jenkinsPipelineStrategy!=null?this.jenkinsPipelineStrategy.build():null;
    }

    public A withJenkinsPipelineStrategy(JenkinsPipelineBuildStrategy jenkinsPipelineStrategy) {
        _visitables.get("jenkinsPipelineStrategy").remove(this.jenkinsPipelineStrategy);
        if (jenkinsPipelineStrategy!=null){ this.jenkinsPipelineStrategy= new JenkinsPipelineBuildStrategyBuilder(jenkinsPipelineStrategy); _visitables.get("jenkinsPipelineStrategy").add(this.jenkinsPipelineStrategy);} return (A) this;
    }

    public Boolean hasJenkinsPipelineStrategy() {
        return this.jenkinsPipelineStrategy != null;
    }

    public io.fabric8.openshift.api.model.BuildStrategyFluent.JenkinsPipelineStrategyNested<A> withNewJenkinsPipelineStrategy() {
        return new JenkinsPipelineStrategyNestedImpl();
    }

    public io.fabric8.openshift.api.model.BuildStrategyFluent.JenkinsPipelineStrategyNested<A> withNewJenkinsPipelineStrategyLike(JenkinsPipelineBuildStrategy item) {
        return new JenkinsPipelineStrategyNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.BuildStrategyFluent.JenkinsPipelineStrategyNested<A> editJenkinsPipelineStrategy() {
        return withNewJenkinsPipelineStrategyLike(getJenkinsPipelineStrategy());
    }

    public io.fabric8.openshift.api.model.BuildStrategyFluent.JenkinsPipelineStrategyNested<A> editOrNewJenkinsPipelineStrategy() {
        return withNewJenkinsPipelineStrategyLike(getJenkinsPipelineStrategy() != null ? getJenkinsPipelineStrategy(): new JenkinsPipelineBuildStrategyBuilder().build());
    }

    public io.fabric8.openshift.api.model.BuildStrategyFluent.JenkinsPipelineStrategyNested<A> editOrNewJenkinsPipelineStrategyLike(JenkinsPipelineBuildStrategy item) {
        return withNewJenkinsPipelineStrategyLike(getJenkinsPipelineStrategy() != null ? getJenkinsPipelineStrategy(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSourceStrategy instead.
 * @return The buildable object.
 */
@Deprecated public SourceBuildStrategy getSourceStrategy() {
        return this.sourceStrategy!=null?this.sourceStrategy.build():null;
    }

    public SourceBuildStrategy buildSourceStrategy() {
        return this.sourceStrategy!=null?this.sourceStrategy.build():null;
    }

    public A withSourceStrategy(SourceBuildStrategy sourceStrategy) {
        _visitables.get("sourceStrategy").remove(this.sourceStrategy);
        if (sourceStrategy!=null){ this.sourceStrategy= new SourceBuildStrategyBuilder(sourceStrategy); _visitables.get("sourceStrategy").add(this.sourceStrategy);} return (A) this;
    }

    public Boolean hasSourceStrategy() {
        return this.sourceStrategy != null;
    }

    public io.fabric8.openshift.api.model.BuildStrategyFluent.SourceStrategyNested<A> withNewSourceStrategy() {
        return new SourceStrategyNestedImpl();
    }

    public io.fabric8.openshift.api.model.BuildStrategyFluent.SourceStrategyNested<A> withNewSourceStrategyLike(SourceBuildStrategy item) {
        return new SourceStrategyNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.BuildStrategyFluent.SourceStrategyNested<A> editSourceStrategy() {
        return withNewSourceStrategyLike(getSourceStrategy());
    }

    public io.fabric8.openshift.api.model.BuildStrategyFluent.SourceStrategyNested<A> editOrNewSourceStrategy() {
        return withNewSourceStrategyLike(getSourceStrategy() != null ? getSourceStrategy(): new SourceBuildStrategyBuilder().build());
    }

    public io.fabric8.openshift.api.model.BuildStrategyFluent.SourceStrategyNested<A> editOrNewSourceStrategyLike(SourceBuildStrategy item) {
        return withNewSourceStrategyLike(getSourceStrategy() != null ? getSourceStrategy(): item);
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type=type; return (A) this;
    }

    public Boolean hasType() {
        return this.type != null;
    }

    public A withNewType(StringBuilder arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(int[] arg1,int arg2,int arg3) {
        return (A)withType(new String(arg1, arg2, arg3));
    }

    public A withNewType(char[] arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuffer arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(byte[] arg1,int arg2) {
        return (A)withType(new String(arg1, arg2));
    }

    public A withNewType(byte[] arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(char[] arg1,int arg2,int arg3) {
        return (A)withType(new String(arg1, arg2, arg3));
    }

    public A withNewType(byte[] arg1,int arg2,int arg3) {
        return (A)withType(new String(arg1, arg2, arg3));
    }

    public A withNewType(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withType(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewType(String arg1) {
        return (A)withType(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        BuildStrategyFluentImpl that = (BuildStrategyFluentImpl) o;
        if (customStrategy != null ? !customStrategy.equals(that.customStrategy) :that.customStrategy != null) return false;
        if (dockerStrategy != null ? !dockerStrategy.equals(that.dockerStrategy) :that.dockerStrategy != null) return false;
        if (jenkinsPipelineStrategy != null ? !jenkinsPipelineStrategy.equals(that.jenkinsPipelineStrategy) :that.jenkinsPipelineStrategy != null) return false;
        if (sourceStrategy != null ? !sourceStrategy.equals(that.sourceStrategy) :that.sourceStrategy != null) return false;
        if (type != null ? !type.equals(that.type) :that.type != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(customStrategy,  dockerStrategy,  jenkinsPipelineStrategy,  sourceStrategy,  type,  super.hashCode());
    }

    public class CustomStrategyNestedImpl<N> extends CustomBuildStrategyFluentImpl<io.fabric8.openshift.api.model.BuildStrategyFluent.CustomStrategyNested<N>> implements io.fabric8.openshift.api.model.BuildStrategyFluent.CustomStrategyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final CustomBuildStrategyBuilder builder;

            CustomStrategyNestedImpl(CustomBuildStrategy item) {
                this.builder = new CustomBuildStrategyBuilder(this, item);
                        
            }

            CustomStrategyNestedImpl() {
                this.builder = new CustomBuildStrategyBuilder(this);
                        
            }

            public N and() {
                return (N) BuildStrategyFluentImpl.this.withCustomStrategy(builder.build());
            }

            public N endCustomStrategy() {
                return and();
            }
    }


    public class DockerStrategyNestedImpl<N> extends DockerBuildStrategyFluentImpl<io.fabric8.openshift.api.model.BuildStrategyFluent.DockerStrategyNested<N>> implements io.fabric8.openshift.api.model.BuildStrategyFluent.DockerStrategyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final DockerBuildStrategyBuilder builder;

            DockerStrategyNestedImpl(DockerBuildStrategy item) {
                this.builder = new DockerBuildStrategyBuilder(this, item);
                        
            }

            DockerStrategyNestedImpl() {
                this.builder = new DockerBuildStrategyBuilder(this);
                        
            }

            public N and() {
                return (N) BuildStrategyFluentImpl.this.withDockerStrategy(builder.build());
            }

            public N endDockerStrategy() {
                return and();
            }
    }


    public class JenkinsPipelineStrategyNestedImpl<N> extends JenkinsPipelineBuildStrategyFluentImpl<io.fabric8.openshift.api.model.BuildStrategyFluent.JenkinsPipelineStrategyNested<N>> implements io.fabric8.openshift.api.model.BuildStrategyFluent.JenkinsPipelineStrategyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final JenkinsPipelineBuildStrategyBuilder builder;

            JenkinsPipelineStrategyNestedImpl(JenkinsPipelineBuildStrategy item) {
                this.builder = new JenkinsPipelineBuildStrategyBuilder(this, item);
                        
            }

            JenkinsPipelineStrategyNestedImpl() {
                this.builder = new JenkinsPipelineBuildStrategyBuilder(this);
                        
            }

            public N and() {
                return (N) BuildStrategyFluentImpl.this.withJenkinsPipelineStrategy(builder.build());
            }

            public N endJenkinsPipelineStrategy() {
                return and();
            }
    }


    public class SourceStrategyNestedImpl<N> extends SourceBuildStrategyFluentImpl<io.fabric8.openshift.api.model.BuildStrategyFluent.SourceStrategyNested<N>> implements io.fabric8.openshift.api.model.BuildStrategyFluent.SourceStrategyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SourceBuildStrategyBuilder builder;

            SourceStrategyNestedImpl(SourceBuildStrategy item) {
                this.builder = new SourceBuildStrategyBuilder(this, item);
                        
            }

            SourceStrategyNestedImpl() {
                this.builder = new SourceBuildStrategyBuilder(this);
                        
            }

            public N and() {
                return (N) BuildStrategyFluentImpl.this.withSourceStrategy(builder.build());
            }

            public N endSourceStrategy() {
                return and();
            }
    }


}
