package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class BareMetalPlatformStatusBuilder extends BareMetalPlatformStatusFluentImpl<BareMetalPlatformStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<BareMetalPlatformStatus,BareMetalPlatformStatusBuilder> {

    BareMetalPlatformStatusFluent<?> fluent;
    Boolean validationEnabled;

    public BareMetalPlatformStatusBuilder() {
        this(true);
    }

    public BareMetalPlatformStatusBuilder(Boolean validationEnabled) {
        this(new BareMetalPlatformStatus(), validationEnabled);
    }

    public BareMetalPlatformStatusBuilder(BareMetalPlatformStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public BareMetalPlatformStatusBuilder(BareMetalPlatformStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new BareMetalPlatformStatus(), validationEnabled);
    }

    public BareMetalPlatformStatusBuilder(BareMetalPlatformStatusFluent<?> fluent,BareMetalPlatformStatus instance) {
        this(fluent, instance, true);
    }

    public BareMetalPlatformStatusBuilder(BareMetalPlatformStatusFluent<?> fluent,BareMetalPlatformStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiServerInternalIP(instance.getApiServerInternalIP()); 
        fluent.withIngressIP(instance.getIngressIP()); 
        fluent.withNodeDNSIP(instance.getNodeDNSIP()); 
        this.validationEnabled = validationEnabled; 
    }

    public BareMetalPlatformStatusBuilder(BareMetalPlatformStatus instance) {
        this(instance,true);
    }

    public BareMetalPlatformStatusBuilder(BareMetalPlatformStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiServerInternalIP(instance.getApiServerInternalIP()); 
        this.withIngressIP(instance.getIngressIP()); 
        this.withNodeDNSIP(instance.getNodeDNSIP()); 
        this.validationEnabled = validationEnabled; 
    }

    public BareMetalPlatformStatus build() {
        BareMetalPlatformStatus buildable = new BareMetalPlatformStatus(fluent.getApiServerInternalIP(),fluent.getIngressIP(),fluent.getNodeDNSIP());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        BareMetalPlatformStatusBuilder that = (BareMetalPlatformStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
