package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AzurePlatformSpecBuilder extends AzurePlatformSpecFluentImpl<AzurePlatformSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<AzurePlatformSpec,AzurePlatformSpecBuilder> {

    AzurePlatformSpecFluent<?> fluent;
    Boolean validationEnabled;

    public AzurePlatformSpecBuilder() {
        this(true);
    }

    public AzurePlatformSpecBuilder(Boolean validationEnabled) {
        this(new AzurePlatformSpec(), validationEnabled);
    }

    public AzurePlatformSpecBuilder(AzurePlatformSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public AzurePlatformSpecBuilder(AzurePlatformSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new AzurePlatformSpec(), validationEnabled);
    }

    public AzurePlatformSpecBuilder(AzurePlatformSpecFluent<?> fluent,AzurePlatformSpec instance) {
        this(fluent, instance, true);
    }

    public AzurePlatformSpecBuilder(AzurePlatformSpecFluent<?> fluent,AzurePlatformSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        this.validationEnabled = validationEnabled; 
    }

    public AzurePlatformSpecBuilder(AzurePlatformSpec instance) {
        this(instance,true);
    }

    public AzurePlatformSpecBuilder(AzurePlatformSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.validationEnabled = validationEnabled; 
    }

    public AzurePlatformSpec build() {
        AzurePlatformSpec buildable = new AzurePlatformSpec();
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        AzurePlatformSpecBuilder that = (AzurePlatformSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
