package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class APIServerNamedServingCertFluentImpl<A extends APIServerNamedServingCertFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements APIServerNamedServingCertFluent<A> {

    private List<String> names = new ArrayList<String>();
    private SecretNameReferenceBuilder servingCertificate;

    public APIServerNamedServingCertFluentImpl() {
    }

    public APIServerNamedServingCertFluentImpl(APIServerNamedServingCert instance) {
        this.withNames(instance.getNames()); 
        this.withServingCertificate(instance.getServingCertificate()); 
    }

    public A addToNames(int index,String item) {
        if (this.names == null) {this.names = new ArrayList<String>();}
        this.names.add(index, item);
        return (A)this;
    }

    public A setToNames(int index,String item) {
        if (this.names == null) {this.names = new ArrayList<String>();}
        this.names.set(index, item); return (A)this;
    }

    public A addToNames(String... items) {
        if (this.names == null) {this.names = new ArrayList<String>();}
        for (String item : items) {this.names.add(item);} return (A)this;
    }

    public A addAllToNames(Collection<String> items) {
        if (this.names == null) {this.names = new ArrayList<String>();}
        for (String item : items) {this.names.add(item);} return (A)this;
    }

    public A removeFromNames(String... items) {
        for (String item : items) {if (this.names!= null){ this.names.remove(item);}} return (A)this;
    }

    public A removeAllFromNames(Collection<String> items) {
        for (String item : items) {if (this.names!= null){ this.names.remove(item);}} return (A)this;
    }

    public List<String> getNames() {
        return this.names;
    }

    public String getName(int index) {
        return this.names.get(index);
    }

    public String getFirstName() {
        return this.names.get(0);
    }

    public String getLastName() {
        return this.names.get(names.size() - 1);
    }

    public String getMatchingName(Predicate<String> predicate) {
        for (String item: names) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingName(Predicate<String> predicate) {
        for (String item: names) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withNames(List<String> names) {
        if (this.names != null) { _visitables.get("names").removeAll(this.names);}
        if (names != null) {this.names = new ArrayList<String>(); for (String item : names){this.addToNames(item);}} else { this.names = null;} return (A) this;
    }

    public A withNames(String... names) {
        if (this.names != null) {this.names.clear();}
        if (names != null) {for (String item :names){ this.addToNames(item);}} return (A) this;
    }

    public Boolean hasNames() {
        return names != null && !names.isEmpty();
    }

    public A addNewName(StringBuilder arg1) {
        return (A)addToNames(new String(arg1));
    }

    public A addNewName(int[] arg1,int arg2,int arg3) {
        return (A)addToNames(new String(arg1, arg2, arg3));
    }

    public A addNewName(char[] arg1) {
        return (A)addToNames(new String(arg1));
    }

    public A addNewName(StringBuffer arg1) {
        return (A)addToNames(new String(arg1));
    }

    public A addNewName(byte[] arg1,int arg2) {
        return (A)addToNames(new String(arg1, arg2));
    }

    public A addNewName(byte[] arg1) {
        return (A)addToNames(new String(arg1));
    }

    public A addNewName(char[] arg1,int arg2,int arg3) {
        return (A)addToNames(new String(arg1, arg2, arg3));
    }

    public A addNewName(byte[] arg1,int arg2,int arg3) {
        return (A)addToNames(new String(arg1, arg2, arg3));
    }

    public A addNewName(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToNames(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewName(String arg1) {
        return (A)addToNames(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildServingCertificate instead.
 * @return The buildable object.
 */
@Deprecated public SecretNameReference getServingCertificate() {
        return this.servingCertificate!=null?this.servingCertificate.build():null;
    }

    public SecretNameReference buildServingCertificate() {
        return this.servingCertificate!=null?this.servingCertificate.build():null;
    }

    public A withServingCertificate(SecretNameReference servingCertificate) {
        _visitables.get("servingCertificate").remove(this.servingCertificate);
        if (servingCertificate!=null){ this.servingCertificate= new SecretNameReferenceBuilder(servingCertificate); _visitables.get("servingCertificate").add(this.servingCertificate);} return (A) this;
    }

    public Boolean hasServingCertificate() {
        return this.servingCertificate != null;
    }

    public A withNewServingCertificate(String name) {
        return (A)withServingCertificate(new SecretNameReference(name));
    }

    public io.fabric8.openshift.api.model.APIServerNamedServingCertFluent.ServingCertificateNested<A> withNewServingCertificate() {
        return new ServingCertificateNestedImpl();
    }

    public io.fabric8.openshift.api.model.APIServerNamedServingCertFluent.ServingCertificateNested<A> withNewServingCertificateLike(SecretNameReference item) {
        return new ServingCertificateNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.APIServerNamedServingCertFluent.ServingCertificateNested<A> editServingCertificate() {
        return withNewServingCertificateLike(getServingCertificate());
    }

    public io.fabric8.openshift.api.model.APIServerNamedServingCertFluent.ServingCertificateNested<A> editOrNewServingCertificate() {
        return withNewServingCertificateLike(getServingCertificate() != null ? getServingCertificate(): new SecretNameReferenceBuilder().build());
    }

    public io.fabric8.openshift.api.model.APIServerNamedServingCertFluent.ServingCertificateNested<A> editOrNewServingCertificateLike(SecretNameReference item) {
        return withNewServingCertificateLike(getServingCertificate() != null ? getServingCertificate(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        APIServerNamedServingCertFluentImpl that = (APIServerNamedServingCertFluentImpl) o;
        if (names != null ? !names.equals(that.names) :that.names != null) return false;
        if (servingCertificate != null ? !servingCertificate.equals(that.servingCertificate) :that.servingCertificate != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(names,  servingCertificate,  super.hashCode());
    }

    public class ServingCertificateNestedImpl<N> extends SecretNameReferenceFluentImpl<io.fabric8.openshift.api.model.APIServerNamedServingCertFluent.ServingCertificateNested<N>> implements io.fabric8.openshift.api.model.APIServerNamedServingCertFluent.ServingCertificateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SecretNameReferenceBuilder builder;

            ServingCertificateNestedImpl(SecretNameReference item) {
                this.builder = new SecretNameReferenceBuilder(this, item);
                        
            }

            ServingCertificateNestedImpl() {
                this.builder = new SecretNameReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) APIServerNamedServingCertFluentImpl.this.withServingCertificate(builder.build());
            }

            public N endServingCertificate() {
                return and();
            }
    }


}
