package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SecretNameReferenceBuilder extends SecretNameReferenceFluentImpl<SecretNameReferenceBuilder> implements VisitableBuilder<SecretNameReference,SecretNameReferenceBuilder> {

    SecretNameReferenceFluent<?> fluent;
    Boolean validationEnabled;

    public SecretNameReferenceBuilder() {
        this(true);
    }

    public SecretNameReferenceBuilder(Boolean validationEnabled) {
        this(new SecretNameReference(), validationEnabled);
    }

    public SecretNameReferenceBuilder(SecretNameReferenceFluent<?> fluent) {
        this(fluent, true);
    }

    public SecretNameReferenceBuilder(SecretNameReferenceFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new SecretNameReference(), validationEnabled);
    }

    public SecretNameReferenceBuilder(SecretNameReferenceFluent<?> fluent,SecretNameReference instance) {
        this(fluent, instance, true);
    }

    public SecretNameReferenceBuilder(SecretNameReferenceFluent<?> fluent,SecretNameReference instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withName(instance.getName()); 
        this.validationEnabled = validationEnabled; 
    }

    public SecretNameReferenceBuilder(SecretNameReference instance) {
        this(instance,true);
    }

    public SecretNameReferenceBuilder(SecretNameReference instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withName(instance.getName()); 
        this.validationEnabled = validationEnabled; 
    }

    public SecretNameReference build() {
        SecretNameReference buildable = new SecretNameReference(fluent.getName());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        SecretNameReferenceBuilder that = (SecretNameReferenceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
