package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SchedulerListBuilder extends SchedulerListFluentImpl<SchedulerListBuilder> implements VisitableBuilder<SchedulerList,SchedulerListBuilder> {

    SchedulerListFluent<?> fluent;
    Boolean validationEnabled;

    public SchedulerListBuilder() {
        this(true);
    }

    public SchedulerListBuilder(Boolean validationEnabled) {
        this(new SchedulerList(), validationEnabled);
    }

    public SchedulerListBuilder(SchedulerListFluent<?> fluent) {
        this(fluent, true);
    }

    public SchedulerListBuilder(SchedulerListFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new SchedulerList(), validationEnabled);
    }

    public SchedulerListBuilder(SchedulerListFluent<?> fluent,SchedulerList instance) {
        this(fluent, instance, true);
    }

    public SchedulerListBuilder(SchedulerListFluent<?> fluent,SchedulerList instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public SchedulerListBuilder(SchedulerList instance) {
        this(instance,true);
    }

    public SchedulerListBuilder(SchedulerList instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public SchedulerList build() {
        SchedulerList buildable = new SchedulerList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        SchedulerListBuilder that = (SchedulerListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
