package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import java.lang.StringBuffer;

public class PlatformStatusFluentImpl<A extends PlatformStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PlatformStatusFluent<A> {

    private AWSPlatformStatusBuilder aws;
    private AzurePlatformStatusBuilder azure;
    private BareMetalPlatformStatusBuilder baremetal;
    private GCPPlatformStatusBuilder gcp;
    private IBMCloudPlatformStatusBuilder ibmcloud;
    private OpenStackPlatformStatusBuilder openstack;
    private OvirtPlatformStatusBuilder ovirt;
    private String type;
    private VSpherePlatformStatusBuilder vsphere;

    public PlatformStatusFluentImpl() {
    }

    public PlatformStatusFluentImpl(PlatformStatus instance) {
        this.withAws(instance.getAws()); 
        this.withAzure(instance.getAzure()); 
        this.withBaremetal(instance.getBaremetal()); 
        this.withGcp(instance.getGcp()); 
        this.withIbmcloud(instance.getIbmcloud()); 
        this.withOpenstack(instance.getOpenstack()); 
        this.withOvirt(instance.getOvirt()); 
        this.withType(instance.getType()); 
        this.withVsphere(instance.getVsphere()); 
    }

    
/**
 * This method has been deprecated, please use method buildAws instead.
 * @return The buildable object.
 */
@Deprecated public AWSPlatformStatus getAws() {
        return this.aws!=null?this.aws.build():null;
    }

    public AWSPlatformStatus buildAws() {
        return this.aws!=null?this.aws.build():null;
    }

    public A withAws(AWSPlatformStatus aws) {
        _visitables.get("aws").remove(this.aws);
        if (aws!=null){ this.aws= new AWSPlatformStatusBuilder(aws); _visitables.get("aws").add(this.aws);} return (A) this;
    }

    public Boolean hasAws() {
        return this.aws != null;
    }

    public PlatformStatusFluent.AwsNested<A> withNewAws() {
        return new AwsNestedImpl();
    }

    public PlatformStatusFluent.AwsNested<A> withNewAwsLike(AWSPlatformStatus item) {
        return new AwsNestedImpl(item);
    }

    public PlatformStatusFluent.AwsNested<A> editAws() {
        return withNewAwsLike(getAws());
    }

    public PlatformStatusFluent.AwsNested<A> editOrNewAws() {
        return withNewAwsLike(getAws() != null ? getAws(): new AWSPlatformStatusBuilder().build());
    }

    public PlatformStatusFluent.AwsNested<A> editOrNewAwsLike(AWSPlatformStatus item) {
        return withNewAwsLike(getAws() != null ? getAws(): item);
    }

    
/**
 * This method has been deprecated, please use method buildAzure instead.
 * @return The buildable object.
 */
@Deprecated public AzurePlatformStatus getAzure() {
        return this.azure!=null?this.azure.build():null;
    }

    public AzurePlatformStatus buildAzure() {
        return this.azure!=null?this.azure.build():null;
    }

    public A withAzure(AzurePlatformStatus azure) {
        _visitables.get("azure").remove(this.azure);
        if (azure!=null){ this.azure= new AzurePlatformStatusBuilder(azure); _visitables.get("azure").add(this.azure);} return (A) this;
    }

    public Boolean hasAzure() {
        return this.azure != null;
    }

    public A withNewAzure(String cloudName,String networkResourceGroupName,String resourceGroupName) {
        return (A)withAzure(new AzurePlatformStatus(cloudName, networkResourceGroupName, resourceGroupName));
    }

    public PlatformStatusFluent.AzureNested<A> withNewAzure() {
        return new AzureNestedImpl();
    }

    public PlatformStatusFluent.AzureNested<A> withNewAzureLike(AzurePlatformStatus item) {
        return new AzureNestedImpl(item);
    }

    public PlatformStatusFluent.AzureNested<A> editAzure() {
        return withNewAzureLike(getAzure());
    }

    public PlatformStatusFluent.AzureNested<A> editOrNewAzure() {
        return withNewAzureLike(getAzure() != null ? getAzure(): new AzurePlatformStatusBuilder().build());
    }

    public PlatformStatusFluent.AzureNested<A> editOrNewAzureLike(AzurePlatformStatus item) {
        return withNewAzureLike(getAzure() != null ? getAzure(): item);
    }

    
/**
 * This method has been deprecated, please use method buildBaremetal instead.
 * @return The buildable object.
 */
@Deprecated public BareMetalPlatformStatus getBaremetal() {
        return this.baremetal!=null?this.baremetal.build():null;
    }

    public BareMetalPlatformStatus buildBaremetal() {
        return this.baremetal!=null?this.baremetal.build():null;
    }

    public A withBaremetal(BareMetalPlatformStatus baremetal) {
        _visitables.get("baremetal").remove(this.baremetal);
        if (baremetal!=null){ this.baremetal= new BareMetalPlatformStatusBuilder(baremetal); _visitables.get("baremetal").add(this.baremetal);} return (A) this;
    }

    public Boolean hasBaremetal() {
        return this.baremetal != null;
    }

    public A withNewBaremetal(String apiServerInternalIP,String ingressIP,String nodeDNSIP) {
        return (A)withBaremetal(new BareMetalPlatformStatus(apiServerInternalIP, ingressIP, nodeDNSIP));
    }

    public PlatformStatusFluent.BaremetalNested<A> withNewBaremetal() {
        return new BaremetalNestedImpl();
    }

    public PlatformStatusFluent.BaremetalNested<A> withNewBaremetalLike(BareMetalPlatformStatus item) {
        return new BaremetalNestedImpl(item);
    }

    public PlatformStatusFluent.BaremetalNested<A> editBaremetal() {
        return withNewBaremetalLike(getBaremetal());
    }

    public PlatformStatusFluent.BaremetalNested<A> editOrNewBaremetal() {
        return withNewBaremetalLike(getBaremetal() != null ? getBaremetal(): new BareMetalPlatformStatusBuilder().build());
    }

    public PlatformStatusFluent.BaremetalNested<A> editOrNewBaremetalLike(BareMetalPlatformStatus item) {
        return withNewBaremetalLike(getBaremetal() != null ? getBaremetal(): item);
    }

    
/**
 * This method has been deprecated, please use method buildGcp instead.
 * @return The buildable object.
 */
@Deprecated public GCPPlatformStatus getGcp() {
        return this.gcp!=null?this.gcp.build():null;
    }

    public GCPPlatformStatus buildGcp() {
        return this.gcp!=null?this.gcp.build():null;
    }

    public A withGcp(GCPPlatformStatus gcp) {
        _visitables.get("gcp").remove(this.gcp);
        if (gcp!=null){ this.gcp= new GCPPlatformStatusBuilder(gcp); _visitables.get("gcp").add(this.gcp);} return (A) this;
    }

    public Boolean hasGcp() {
        return this.gcp != null;
    }

    public A withNewGcp(String projectID,String region) {
        return (A)withGcp(new GCPPlatformStatus(projectID, region));
    }

    public PlatformStatusFluent.GcpNested<A> withNewGcp() {
        return new GcpNestedImpl();
    }

    public PlatformStatusFluent.GcpNested<A> withNewGcpLike(GCPPlatformStatus item) {
        return new GcpNestedImpl(item);
    }

    public PlatformStatusFluent.GcpNested<A> editGcp() {
        return withNewGcpLike(getGcp());
    }

    public PlatformStatusFluent.GcpNested<A> editOrNewGcp() {
        return withNewGcpLike(getGcp() != null ? getGcp(): new GCPPlatformStatusBuilder().build());
    }

    public PlatformStatusFluent.GcpNested<A> editOrNewGcpLike(GCPPlatformStatus item) {
        return withNewGcpLike(getGcp() != null ? getGcp(): item);
    }

    
/**
 * This method has been deprecated, please use method buildIbmcloud instead.
 * @return The buildable object.
 */
@Deprecated public IBMCloudPlatformStatus getIbmcloud() {
        return this.ibmcloud!=null?this.ibmcloud.build():null;
    }

    public IBMCloudPlatformStatus buildIbmcloud() {
        return this.ibmcloud!=null?this.ibmcloud.build():null;
    }

    public A withIbmcloud(IBMCloudPlatformStatus ibmcloud) {
        _visitables.get("ibmcloud").remove(this.ibmcloud);
        if (ibmcloud!=null){ this.ibmcloud= new IBMCloudPlatformStatusBuilder(ibmcloud); _visitables.get("ibmcloud").add(this.ibmcloud);} return (A) this;
    }

    public Boolean hasIbmcloud() {
        return this.ibmcloud != null;
    }

    public A withNewIbmcloud(String location,String providerType,String resourceGroupName) {
        return (A)withIbmcloud(new IBMCloudPlatformStatus(location, providerType, resourceGroupName));
    }

    public PlatformStatusFluent.IbmcloudNested<A> withNewIbmcloud() {
        return new IbmcloudNestedImpl();
    }

    public PlatformStatusFluent.IbmcloudNested<A> withNewIbmcloudLike(IBMCloudPlatformStatus item) {
        return new IbmcloudNestedImpl(item);
    }

    public PlatformStatusFluent.IbmcloudNested<A> editIbmcloud() {
        return withNewIbmcloudLike(getIbmcloud());
    }

    public PlatformStatusFluent.IbmcloudNested<A> editOrNewIbmcloud() {
        return withNewIbmcloudLike(getIbmcloud() != null ? getIbmcloud(): new IBMCloudPlatformStatusBuilder().build());
    }

    public PlatformStatusFluent.IbmcloudNested<A> editOrNewIbmcloudLike(IBMCloudPlatformStatus item) {
        return withNewIbmcloudLike(getIbmcloud() != null ? getIbmcloud(): item);
    }

    
/**
 * This method has been deprecated, please use method buildOpenstack instead.
 * @return The buildable object.
 */
@Deprecated public OpenStackPlatformStatus getOpenstack() {
        return this.openstack!=null?this.openstack.build():null;
    }

    public OpenStackPlatformStatus buildOpenstack() {
        return this.openstack!=null?this.openstack.build():null;
    }

    public A withOpenstack(OpenStackPlatformStatus openstack) {
        _visitables.get("openstack").remove(this.openstack);
        if (openstack!=null){ this.openstack= new OpenStackPlatformStatusBuilder(openstack); _visitables.get("openstack").add(this.openstack);} return (A) this;
    }

    public Boolean hasOpenstack() {
        return this.openstack != null;
    }

    public A withNewOpenstack(String apiServerInternalIP,String cloudName,String ingressIP,String nodeDNSIP) {
        return (A)withOpenstack(new OpenStackPlatformStatus(apiServerInternalIP, cloudName, ingressIP, nodeDNSIP));
    }

    public PlatformStatusFluent.OpenstackNested<A> withNewOpenstack() {
        return new OpenstackNestedImpl();
    }

    public PlatformStatusFluent.OpenstackNested<A> withNewOpenstackLike(OpenStackPlatformStatus item) {
        return new OpenstackNestedImpl(item);
    }

    public PlatformStatusFluent.OpenstackNested<A> editOpenstack() {
        return withNewOpenstackLike(getOpenstack());
    }

    public PlatformStatusFluent.OpenstackNested<A> editOrNewOpenstack() {
        return withNewOpenstackLike(getOpenstack() != null ? getOpenstack(): new OpenStackPlatformStatusBuilder().build());
    }

    public PlatformStatusFluent.OpenstackNested<A> editOrNewOpenstackLike(OpenStackPlatformStatus item) {
        return withNewOpenstackLike(getOpenstack() != null ? getOpenstack(): item);
    }

    
/**
 * This method has been deprecated, please use method buildOvirt instead.
 * @return The buildable object.
 */
@Deprecated public OvirtPlatformStatus getOvirt() {
        return this.ovirt!=null?this.ovirt.build():null;
    }

    public OvirtPlatformStatus buildOvirt() {
        return this.ovirt!=null?this.ovirt.build():null;
    }

    public A withOvirt(OvirtPlatformStatus ovirt) {
        _visitables.get("ovirt").remove(this.ovirt);
        if (ovirt!=null){ this.ovirt= new OvirtPlatformStatusBuilder(ovirt); _visitables.get("ovirt").add(this.ovirt);} return (A) this;
    }

    public Boolean hasOvirt() {
        return this.ovirt != null;
    }

    public A withNewOvirt(String apiServerInternalIP,String ingressIP,String nodeDNSIP) {
        return (A)withOvirt(new OvirtPlatformStatus(apiServerInternalIP, ingressIP, nodeDNSIP));
    }

    public PlatformStatusFluent.OvirtNested<A> withNewOvirt() {
        return new OvirtNestedImpl();
    }

    public PlatformStatusFluent.OvirtNested<A> withNewOvirtLike(OvirtPlatformStatus item) {
        return new OvirtNestedImpl(item);
    }

    public PlatformStatusFluent.OvirtNested<A> editOvirt() {
        return withNewOvirtLike(getOvirt());
    }

    public PlatformStatusFluent.OvirtNested<A> editOrNewOvirt() {
        return withNewOvirtLike(getOvirt() != null ? getOvirt(): new OvirtPlatformStatusBuilder().build());
    }

    public PlatformStatusFluent.OvirtNested<A> editOrNewOvirtLike(OvirtPlatformStatus item) {
        return withNewOvirtLike(getOvirt() != null ? getOvirt(): item);
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type=type; return (A) this;
    }

    public Boolean hasType() {
        return this.type != null;
    }

    public A withNewType(String arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuilder arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuffer arg1) {
        return (A)withType(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildVsphere instead.
 * @return The buildable object.
 */
@Deprecated public VSpherePlatformStatus getVsphere() {
        return this.vsphere!=null?this.vsphere.build():null;
    }

    public VSpherePlatformStatus buildVsphere() {
        return this.vsphere!=null?this.vsphere.build():null;
    }

    public A withVsphere(VSpherePlatformStatus vsphere) {
        _visitables.get("vsphere").remove(this.vsphere);
        if (vsphere!=null){ this.vsphere= new VSpherePlatformStatusBuilder(vsphere); _visitables.get("vsphere").add(this.vsphere);} return (A) this;
    }

    public Boolean hasVsphere() {
        return this.vsphere != null;
    }

    public A withNewVsphere(String apiServerInternalIP,String ingressIP,String nodeDNSIP) {
        return (A)withVsphere(new VSpherePlatformStatus(apiServerInternalIP, ingressIP, nodeDNSIP));
    }

    public PlatformStatusFluent.VsphereNested<A> withNewVsphere() {
        return new VsphereNestedImpl();
    }

    public PlatformStatusFluent.VsphereNested<A> withNewVsphereLike(VSpherePlatformStatus item) {
        return new VsphereNestedImpl(item);
    }

    public PlatformStatusFluent.VsphereNested<A> editVsphere() {
        return withNewVsphereLike(getVsphere());
    }

    public PlatformStatusFluent.VsphereNested<A> editOrNewVsphere() {
        return withNewVsphereLike(getVsphere() != null ? getVsphere(): new VSpherePlatformStatusBuilder().build());
    }

    public PlatformStatusFluent.VsphereNested<A> editOrNewVsphereLike(VSpherePlatformStatus item) {
        return withNewVsphereLike(getVsphere() != null ? getVsphere(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PlatformStatusFluentImpl that = (PlatformStatusFluentImpl) o;
        if (aws != null ? !aws.equals(that.aws) :that.aws != null) return false;
        if (azure != null ? !azure.equals(that.azure) :that.azure != null) return false;
        if (baremetal != null ? !baremetal.equals(that.baremetal) :that.baremetal != null) return false;
        if (gcp != null ? !gcp.equals(that.gcp) :that.gcp != null) return false;
        if (ibmcloud != null ? !ibmcloud.equals(that.ibmcloud) :that.ibmcloud != null) return false;
        if (openstack != null ? !openstack.equals(that.openstack) :that.openstack != null) return false;
        if (ovirt != null ? !ovirt.equals(that.ovirt) :that.ovirt != null) return false;
        if (type != null ? !type.equals(that.type) :that.type != null) return false;
        if (vsphere != null ? !vsphere.equals(that.vsphere) :that.vsphere != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(aws,  azure,  baremetal,  gcp,  ibmcloud,  openstack,  ovirt,  type,  vsphere,  super.hashCode());
    }

    public class AwsNestedImpl<N> extends AWSPlatformStatusFluentImpl<PlatformStatusFluent.AwsNested<N>> implements PlatformStatusFluent.AwsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final AWSPlatformStatusBuilder builder;

            AwsNestedImpl(AWSPlatformStatus item) {
                this.builder = new AWSPlatformStatusBuilder(this, item);
                        
            }

            AwsNestedImpl() {
                this.builder = new AWSPlatformStatusBuilder(this);
                        
            }

            public N and() {
                return (N) PlatformStatusFluentImpl.this.withAws(builder.build());
            }

            public N endAws() {
                return and();
            }
    }


    public class AzureNestedImpl<N> extends AzurePlatformStatusFluentImpl<PlatformStatusFluent.AzureNested<N>> implements PlatformStatusFluent.AzureNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final AzurePlatformStatusBuilder builder;

            AzureNestedImpl(AzurePlatformStatus item) {
                this.builder = new AzurePlatformStatusBuilder(this, item);
                        
            }

            AzureNestedImpl() {
                this.builder = new AzurePlatformStatusBuilder(this);
                        
            }

            public N and() {
                return (N) PlatformStatusFluentImpl.this.withAzure(builder.build());
            }

            public N endAzure() {
                return and();
            }
    }


    public class BaremetalNestedImpl<N> extends BareMetalPlatformStatusFluentImpl<PlatformStatusFluent.BaremetalNested<N>> implements PlatformStatusFluent.BaremetalNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final BareMetalPlatformStatusBuilder builder;

            BaremetalNestedImpl(BareMetalPlatformStatus item) {
                this.builder = new BareMetalPlatformStatusBuilder(this, item);
                        
            }

            BaremetalNestedImpl() {
                this.builder = new BareMetalPlatformStatusBuilder(this);
                        
            }

            public N and() {
                return (N) PlatformStatusFluentImpl.this.withBaremetal(builder.build());
            }

            public N endBaremetal() {
                return and();
            }
    }


    public class GcpNestedImpl<N> extends GCPPlatformStatusFluentImpl<PlatformStatusFluent.GcpNested<N>> implements PlatformStatusFluent.GcpNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final GCPPlatformStatusBuilder builder;

            GcpNestedImpl(GCPPlatformStatus item) {
                this.builder = new GCPPlatformStatusBuilder(this, item);
                        
            }

            GcpNestedImpl() {
                this.builder = new GCPPlatformStatusBuilder(this);
                        
            }

            public N and() {
                return (N) PlatformStatusFluentImpl.this.withGcp(builder.build());
            }

            public N endGcp() {
                return and();
            }
    }


    public class IbmcloudNestedImpl<N> extends IBMCloudPlatformStatusFluentImpl<PlatformStatusFluent.IbmcloudNested<N>> implements PlatformStatusFluent.IbmcloudNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final IBMCloudPlatformStatusBuilder builder;

            IbmcloudNestedImpl(IBMCloudPlatformStatus item) {
                this.builder = new IBMCloudPlatformStatusBuilder(this, item);
                        
            }

            IbmcloudNestedImpl() {
                this.builder = new IBMCloudPlatformStatusBuilder(this);
                        
            }

            public N and() {
                return (N) PlatformStatusFluentImpl.this.withIbmcloud(builder.build());
            }

            public N endIbmcloud() {
                return and();
            }
    }


    public class OpenstackNestedImpl<N> extends OpenStackPlatformStatusFluentImpl<PlatformStatusFluent.OpenstackNested<N>> implements PlatformStatusFluent.OpenstackNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final OpenStackPlatformStatusBuilder builder;

            OpenstackNestedImpl(OpenStackPlatformStatus item) {
                this.builder = new OpenStackPlatformStatusBuilder(this, item);
                        
            }

            OpenstackNestedImpl() {
                this.builder = new OpenStackPlatformStatusBuilder(this);
                        
            }

            public N and() {
                return (N) PlatformStatusFluentImpl.this.withOpenstack(builder.build());
            }

            public N endOpenstack() {
                return and();
            }
    }


    public class OvirtNestedImpl<N> extends OvirtPlatformStatusFluentImpl<PlatformStatusFluent.OvirtNested<N>> implements PlatformStatusFluent.OvirtNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final OvirtPlatformStatusBuilder builder;

            OvirtNestedImpl(OvirtPlatformStatus item) {
                this.builder = new OvirtPlatformStatusBuilder(this, item);
                        
            }

            OvirtNestedImpl() {
                this.builder = new OvirtPlatformStatusBuilder(this);
                        
            }

            public N and() {
                return (N) PlatformStatusFluentImpl.this.withOvirt(builder.build());
            }

            public N endOvirt() {
                return and();
            }
    }


    public class VsphereNestedImpl<N> extends VSpherePlatformStatusFluentImpl<PlatformStatusFluent.VsphereNested<N>> implements PlatformStatusFluent.VsphereNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final VSpherePlatformStatusBuilder builder;

            VsphereNestedImpl(VSpherePlatformStatus item) {
                this.builder = new VSpherePlatformStatusBuilder(this, item);
                        
            }

            VsphereNestedImpl() {
                this.builder = new VSpherePlatformStatusBuilder(this);
                        
            }

            public N and() {
                return (N) PlatformStatusFluentImpl.this.withVsphere(builder.build());
            }

            public N endVsphere() {
                return and();
            }
    }


}
