package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class EgressNetworkPolicyPeerBuilder extends EgressNetworkPolicyPeerFluentImpl<EgressNetworkPolicyPeerBuilder> implements VisitableBuilder<EgressNetworkPolicyPeer,EgressNetworkPolicyPeerBuilder> {

    EgressNetworkPolicyPeerFluent<?> fluent;
    Boolean validationEnabled;

    public EgressNetworkPolicyPeerBuilder() {
        this(true);
    }

    public EgressNetworkPolicyPeerBuilder(Boolean validationEnabled) {
        this(new EgressNetworkPolicyPeer(), validationEnabled);
    }

    public EgressNetworkPolicyPeerBuilder(EgressNetworkPolicyPeerFluent<?> fluent) {
        this(fluent, true);
    }

    public EgressNetworkPolicyPeerBuilder(EgressNetworkPolicyPeerFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new EgressNetworkPolicyPeer(), validationEnabled);
    }

    public EgressNetworkPolicyPeerBuilder(EgressNetworkPolicyPeerFluent<?> fluent,EgressNetworkPolicyPeer instance) {
        this(fluent, instance, true);
    }

    public EgressNetworkPolicyPeerBuilder(EgressNetworkPolicyPeerFluent<?> fluent,EgressNetworkPolicyPeer instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withCidrSelector(instance.getCidrSelector()); 
        fluent.withDnsName(instance.getDnsName()); 
        this.validationEnabled = validationEnabled; 
    }

    public EgressNetworkPolicyPeerBuilder(EgressNetworkPolicyPeer instance) {
        this(instance,true);
    }

    public EgressNetworkPolicyPeerBuilder(EgressNetworkPolicyPeer instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withCidrSelector(instance.getCidrSelector()); 
        this.withDnsName(instance.getDnsName()); 
        this.validationEnabled = validationEnabled; 
    }

    public EgressNetworkPolicyPeer build() {
        EgressNetworkPolicyPeer buildable = new EgressNetworkPolicyPeer(fluent.getCidrSelector(),fluent.getDnsName());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        EgressNetworkPolicyPeerBuilder that = (EgressNetworkPolicyPeerBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
