package io.fabric8.openshift.api.model;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.SELinuxOptions;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class SELinuxContextStrategyOptionsFluentImpl<A extends SELinuxContextStrategyOptionsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SELinuxContextStrategyOptionsFluent<A> {

    private SELinuxOptions seLinuxOptions;
    private String type;

    public SELinuxContextStrategyOptionsFluentImpl() {
    }

    public SELinuxContextStrategyOptionsFluentImpl(SELinuxContextStrategyOptions instance) {
        this.withSeLinuxOptions(instance.getSeLinuxOptions()); 
        this.withType(instance.getType()); 
    }

    public SELinuxOptions getSeLinuxOptions() {
        return this.seLinuxOptions;
    }

    public A withSeLinuxOptions(SELinuxOptions seLinuxOptions) {
        this.seLinuxOptions=seLinuxOptions; return (A) this;
    }

    public Boolean hasSeLinuxOptions() {
        return this.seLinuxOptions != null;
    }

    public A withNewSeLinuxOptions(String level,String role,String type,String user) {
        return (A)withSeLinuxOptions(new SELinuxOptions(level, role, type, user));
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type=type; return (A) this;
    }

    public Boolean hasType() {
        return this.type != null;
    }

    public A withNewType(String arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuilder arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuffer arg1) {
        return (A)withType(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SELinuxContextStrategyOptionsFluentImpl that = (SELinuxContextStrategyOptionsFluentImpl) o;
        if (seLinuxOptions != null ? !seLinuxOptions.equals(that.seLinuxOptions) :that.seLinuxOptions != null) return false;
        if (type != null ? !type.equals(that.type) :that.type != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(seLinuxOptions,  type,  super.hashCode());
    }

}
