package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface OperatorHubStatusFluent<A extends OperatorHubStatusFluent<A>> extends Fluent<A> {


    public A addToSources(int index,HubSourceStatus item);
    public A setToSources(int index,HubSourceStatus item);
    public A addToSources(HubSourceStatus... items);
    public A addAllToSources(Collection<HubSourceStatus> items);
    public A removeFromSources(HubSourceStatus... items);
    public A removeAllFromSources(Collection<HubSourceStatus> items);
    public A removeMatchingFromSources(Predicate<HubSourceStatusBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildSources instead.
 * @return The buildable object.
 */
@Deprecated public List<HubSourceStatus> getSources();
    public List<HubSourceStatus> buildSources();
    public HubSourceStatus buildSource(int index);
    public HubSourceStatus buildFirstSource();
    public HubSourceStatus buildLastSource();
    public HubSourceStatus buildMatchingSource(Predicate<HubSourceStatusBuilder> predicate);
    public Boolean hasMatchingSource(Predicate<HubSourceStatusBuilder> predicate);
    public A withSources(List<HubSourceStatus> sources);
    public A withSources(HubSourceStatus... sources);
    public Boolean hasSources();
    public A addNewSource(Boolean disabled,String message,String name,String status);
    public OperatorHubStatusFluent.SourcesNested<A> addNewSource();
    public OperatorHubStatusFluent.SourcesNested<A> addNewSourceLike(HubSourceStatus item);
    public OperatorHubStatusFluent.SourcesNested<A> setNewSourceLike(int index,HubSourceStatus item);
    public OperatorHubStatusFluent.SourcesNested<A> editSource(int index);
    public OperatorHubStatusFluent.SourcesNested<A> editFirstSource();
    public OperatorHubStatusFluent.SourcesNested<A> editLastSource();
    public OperatorHubStatusFluent.SourcesNested<A> editMatchingSource(Predicate<HubSourceStatusBuilder> predicate);
    public interface SourcesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,HubSourceStatusFluent<OperatorHubStatusFluent.SourcesNested<N>> {

            public N and();
            public N endSource();    }


}
