package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class JenkinsPipelineBuildStrategyFluentImpl<A extends JenkinsPipelineBuildStrategyFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements JenkinsPipelineBuildStrategyFluent<A> {

    private List<EnvVar> env = new ArrayList<EnvVar>();
    private String jenkinsfile;
    private String jenkinsfilePath;

    public JenkinsPipelineBuildStrategyFluentImpl() {
    }

    public JenkinsPipelineBuildStrategyFluentImpl(JenkinsPipelineBuildStrategy instance) {
        this.withEnv(instance.getEnv()); 
        this.withJenkinsfile(instance.getJenkinsfile()); 
        this.withJenkinsfilePath(instance.getJenkinsfilePath()); 
    }

    public A addToEnv(int index,EnvVar item) {
        if (this.env == null) {this.env = new ArrayList<EnvVar>();}
        this.env.add(index, item);
        return (A)this;
    }

    public A setToEnv(int index,EnvVar item) {
        if (this.env == null) {this.env = new ArrayList<EnvVar>();}
        this.env.set(index, item); return (A)this;
    }

    public A addToEnv(EnvVar... items) {
        if (this.env == null) {this.env = new ArrayList<EnvVar>();}
        for (EnvVar item : items) {this.env.add(item);} return (A)this;
    }

    public A addAllToEnv(Collection<EnvVar> items) {
        if (this.env == null) {this.env = new ArrayList<EnvVar>();}
        for (EnvVar item : items) {this.env.add(item);} return (A)this;
    }

    public A removeFromEnv(EnvVar... items) {
        for (EnvVar item : items) {if (this.env!= null){ this.env.remove(item);}} return (A)this;
    }

    public A removeAllFromEnv(Collection<EnvVar> items) {
        for (EnvVar item : items) {if (this.env!= null){ this.env.remove(item);}} return (A)this;
    }

    public List<EnvVar> getEnv() {
        return this.env;
    }

    public EnvVar getEnv(int index) {
        return this.env.get(index);
    }

    public EnvVar getFirstEnv() {
        return this.env.get(0);
    }

    public EnvVar getLastEnv() {
        return this.env.get(env.size() - 1);
    }

    public EnvVar getMatchingEnv(Predicate<EnvVar> predicate) {
        for (EnvVar item: env) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingEnv(Predicate<EnvVar> predicate) {
        for (EnvVar item: env) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withEnv(List<EnvVar> env) {
        if (this.env != null) { _visitables.get("env").removeAll(this.env);}
        if (env != null) {this.env = new ArrayList<EnvVar>(); for (EnvVar item : env){this.addToEnv(item);}} else { this.env = null;} return (A) this;
    }

    public A withEnv(EnvVar... env) {
        if (this.env != null) {this.env.clear();}
        if (env != null) {for (EnvVar item :env){ this.addToEnv(item);}} return (A) this;
    }

    public Boolean hasEnv() {
        return env != null && !env.isEmpty();
    }

    public String getJenkinsfile() {
        return this.jenkinsfile;
    }

    public A withJenkinsfile(String jenkinsfile) {
        this.jenkinsfile=jenkinsfile; return (A) this;
    }

    public Boolean hasJenkinsfile() {
        return this.jenkinsfile != null;
    }

    public A withNewJenkinsfile(String arg1) {
        return (A)withJenkinsfile(new String(arg1));
    }

    public A withNewJenkinsfile(StringBuilder arg1) {
        return (A)withJenkinsfile(new String(arg1));
    }

    public A withNewJenkinsfile(StringBuffer arg1) {
        return (A)withJenkinsfile(new String(arg1));
    }

    public String getJenkinsfilePath() {
        return this.jenkinsfilePath;
    }

    public A withJenkinsfilePath(String jenkinsfilePath) {
        this.jenkinsfilePath=jenkinsfilePath; return (A) this;
    }

    public Boolean hasJenkinsfilePath() {
        return this.jenkinsfilePath != null;
    }

    public A withNewJenkinsfilePath(String arg1) {
        return (A)withJenkinsfilePath(new String(arg1));
    }

    public A withNewJenkinsfilePath(StringBuilder arg1) {
        return (A)withJenkinsfilePath(new String(arg1));
    }

    public A withNewJenkinsfilePath(StringBuffer arg1) {
        return (A)withJenkinsfilePath(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        JenkinsPipelineBuildStrategyFluentImpl that = (JenkinsPipelineBuildStrategyFluentImpl) o;
        if (env != null ? !env.equals(that.env) :that.env != null) return false;
        if (jenkinsfile != null ? !jenkinsfile.equals(that.jenkinsfile) :that.jenkinsfile != null) return false;
        if (jenkinsfilePath != null ? !jenkinsfilePath.equals(that.jenkinsfilePath) :that.jenkinsfilePath != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(env,  jenkinsfile,  jenkinsfilePath,  super.hashCode());
    }

}
