package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class FeatureGateSpecBuilder extends FeatureGateSpecFluentImpl<FeatureGateSpecBuilder> implements VisitableBuilder<FeatureGateSpec,FeatureGateSpecBuilder> {

    FeatureGateSpecFluent<?> fluent;
    Boolean validationEnabled;

    public FeatureGateSpecBuilder() {
        this(true);
    }

    public FeatureGateSpecBuilder(Boolean validationEnabled) {
        this(new FeatureGateSpec(), validationEnabled);
    }

    public FeatureGateSpecBuilder(FeatureGateSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public FeatureGateSpecBuilder(FeatureGateSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new FeatureGateSpec(), validationEnabled);
    }

    public FeatureGateSpecBuilder(FeatureGateSpecFluent<?> fluent,FeatureGateSpec instance) {
        this(fluent, instance, true);
    }

    public FeatureGateSpecBuilder(FeatureGateSpecFluent<?> fluent,FeatureGateSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withCustomNoUpgrade(instance.getCustomNoUpgrade()); 
        fluent.withFeatureSet(instance.getFeatureSet()); 
        this.validationEnabled = validationEnabled; 
    }

    public FeatureGateSpecBuilder(FeatureGateSpec instance) {
        this(instance,true);
    }

    public FeatureGateSpecBuilder(FeatureGateSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withCustomNoUpgrade(instance.getCustomNoUpgrade()); 
        this.withFeatureSet(instance.getFeatureSet()); 
        this.validationEnabled = validationEnabled; 
    }

    public FeatureGateSpec build() {
        FeatureGateSpec buildable = new FeatureGateSpec(fluent.getCustomNoUpgrade(),fluent.getFeatureSet());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        FeatureGateSpecBuilder that = (FeatureGateSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
