package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.lang.Deprecated;
import java.util.function.Predicate;
import java.util.List;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.util.Iterator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Collection;
import io.fabric8.kubernetes.api.builder.Nested;

public class ClusterOperatorStatusFluentImpl<A extends ClusterOperatorStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ClusterOperatorStatusFluent<A> {

    private List<ClusterOperatorStatusConditionBuilder> conditions =  new ArrayList<ClusterOperatorStatusConditionBuilder>();
    private VisitableBuilder<? extends HasMetadata,?> extension;
    private List<io.fabric8.openshift.api.model.ObjectReferenceBuilder> relatedObjects =  new ArrayList<io.fabric8.openshift.api.model.ObjectReferenceBuilder>();
    private List<OperandVersionBuilder> versions =  new ArrayList<OperandVersionBuilder>();

    public ClusterOperatorStatusFluentImpl() {
    }

    public ClusterOperatorStatusFluentImpl(ClusterOperatorStatus instance) {
        this.withConditions(instance.getConditions()); 
        this.withExtension(instance.getExtension()); 
        this.withRelatedObjects(instance.getRelatedObjects()); 
        this.withVersions(instance.getVersions()); 
    }

    public A addToConditions(int index,ClusterOperatorStatusCondition item) {
        if (this.conditions == null) {this.conditions = new ArrayList<ClusterOperatorStatusConditionBuilder>();}
        ClusterOperatorStatusConditionBuilder builder = new ClusterOperatorStatusConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,ClusterOperatorStatusCondition item) {
        if (this.conditions == null) {this.conditions = new ArrayList<ClusterOperatorStatusConditionBuilder>();}
        ClusterOperatorStatusConditionBuilder builder = new ClusterOperatorStatusConditionBuilder(item);
        if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
        if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
         return (A)this;
    }

    public A addToConditions(ClusterOperatorStatusCondition... items) {
        if (this.conditions == null) {this.conditions = new ArrayList<ClusterOperatorStatusConditionBuilder>();}
        for (ClusterOperatorStatusCondition item : items) {ClusterOperatorStatusConditionBuilder builder = new ClusterOperatorStatusConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(Collection<ClusterOperatorStatusCondition> items) {
        if (this.conditions == null) {this.conditions = new ArrayList<ClusterOperatorStatusConditionBuilder>();}
        for (ClusterOperatorStatusCondition item : items) {ClusterOperatorStatusConditionBuilder builder = new ClusterOperatorStatusConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(ClusterOperatorStatusCondition... items) {
        for (ClusterOperatorStatusCondition item : items) {ClusterOperatorStatusConditionBuilder builder = new ClusterOperatorStatusConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(Collection<ClusterOperatorStatusCondition> items) {
        for (ClusterOperatorStatusCondition item : items) {ClusterOperatorStatusConditionBuilder builder = new ClusterOperatorStatusConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConditions(Predicate<ClusterOperatorStatusConditionBuilder> predicate) {
        if (conditions == null) return (A) this;
        final Iterator<ClusterOperatorStatusConditionBuilder> each = conditions.iterator();
        final List visitables = _visitables.get("conditions");
        while (each.hasNext()) {
          ClusterOperatorStatusConditionBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<ClusterOperatorStatusCondition> getConditions() {
        return build(conditions);
    }

    public List<ClusterOperatorStatusCondition> buildConditions() {
        return build(conditions);
    }

    public ClusterOperatorStatusCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public ClusterOperatorStatusCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public ClusterOperatorStatusCondition buildLastCondition() {
        return this.conditions.get(conditions.size() - 1).build();
    }

    public ClusterOperatorStatusCondition buildMatchingCondition(Predicate<ClusterOperatorStatusConditionBuilder> predicate) {
        for (ClusterOperatorStatusConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingCondition(Predicate<ClusterOperatorStatusConditionBuilder> predicate) {
        for (ClusterOperatorStatusConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withConditions(List<ClusterOperatorStatusCondition> conditions) {
        if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
        if (conditions != null) {this.conditions = new ArrayList<ClusterOperatorStatusConditionBuilder>(); for (ClusterOperatorStatusCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(ClusterOperatorStatusCondition... conditions) {
        if (this.conditions != null) {this.conditions.clear();}
        if (conditions != null) {for (ClusterOperatorStatusCondition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public Boolean hasConditions() {
        return conditions != null && !conditions.isEmpty();
    }

    public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type) {
        return (A)addToConditions(new ClusterOperatorStatusCondition(lastTransitionTime, message, reason, status, type));
    }

    public ClusterOperatorStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    public ClusterOperatorStatusFluent.ConditionsNested<A> addNewConditionLike(ClusterOperatorStatusCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    public ClusterOperatorStatusFluent.ConditionsNested<A> setNewConditionLike(int index,ClusterOperatorStatusCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    public ClusterOperatorStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public ClusterOperatorStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
        return setNewConditionLike(0, buildCondition(0));
    }

    public ClusterOperatorStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = conditions.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public ClusterOperatorStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<ClusterOperatorStatusConditionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<conditions.size();i++) { 
        if (predicate.test(conditions.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
        return setNewConditionLike(index, buildCondition(index));
    }

    
/**
 * This method has been deprecated, please use method buildExtension instead.
 * @return The buildable object.
 */
@Deprecated public HasMetadata getExtension() {
        return this.extension!=null?this.extension.build():null;
    }

    public HasMetadata buildExtension() {
        return this.extension!=null?this.extension.build():null;
    }

    public A withExtension(HasMetadata extension) {
        if (extension instanceof ClusterVersion){ this.extension= new ClusterVersionBuilder((ClusterVersion)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof ImageStreamImport){ this.extension= new ImageStreamImportBuilder((ImageStreamImport)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof Proxy){ this.extension= new ProxyBuilder((Proxy)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof Project){ this.extension= new ProjectBuilder((Project)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof ClusterOperator){ this.extension= new ClusterOperatorBuilder((ClusterOperator)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof BuildConfig){ this.extension= new BuildConfigBuilder((BuildConfig)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof Infrastructure){ this.extension= new InfrastructureBuilder((Infrastructure)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof Scheduler){ this.extension= new SchedulerBuilder((Scheduler)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof RangeAllocation){ this.extension= new RangeAllocationBuilder((RangeAllocation)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof Route){ this.extension= new RouteBuilder((Route)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof ClusterNetwork){ this.extension= new ClusterNetworkBuilder((ClusterNetwork)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof OAuthAuthorizeToken){ this.extension= new OAuthAuthorizeTokenBuilder((OAuthAuthorizeToken)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof OAuth){ this.extension= new OAuthBuilder((OAuth)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof OperatorHub){ this.extension= new OperatorHubBuilder((OperatorHub)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof ClusterRoleBinding){ this.extension= new ClusterRoleBindingBuilder((ClusterRoleBinding)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof ClusterResourceQuota){ this.extension= new ClusterResourceQuotaBuilder((ClusterResourceQuota)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof ProjectRequest){ this.extension= new ProjectRequestBuilder((ProjectRequest)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof Template){ this.extension= new TemplateBuilder((Template)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof OAuthClientAuthorization){ this.extension= new OAuthClientAuthorizationBuilder((OAuthClientAuthorization)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof ClusterRole){ this.extension= new ClusterRoleBuilder((ClusterRole)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof ImageTag){ this.extension= new ImageTagBuilder((ImageTag)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof DeploymentConfig){ this.extension= new DeploymentConfigBuilder((DeploymentConfig)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof OAuthAccessToken){ this.extension= new OAuthAccessTokenBuilder((OAuthAccessToken)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof RoleBinding){ this.extension= new RoleBindingBuilder((RoleBinding)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof Image){ this.extension= new ImageBuilder((Image)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof APIServer){ this.extension= new APIServerBuilder((APIServer)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof PersistentVolumeClaim){ this.extension= new PersistentVolumeClaimBuilder((PersistentVolumeClaim)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof ImageStreamMapping){ this.extension= new ImageStreamMappingBuilder((ImageStreamMapping)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof Role){ this.extension= new RoleBuilder((Role)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof FeatureGate){ this.extension= new FeatureGateBuilder((FeatureGate)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof User){ this.extension= new UserBuilder((User)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof ImageStreamImage){ this.extension= new ImageStreamImageBuilder((ImageStreamImage)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof Build){ this.extension= new BuildBuilder((Build)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof RoleBindingRestriction){ this.extension= new RoleBindingRestrictionBuilder((RoleBindingRestriction)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof ImageStreamTag){ this.extension= new ImageStreamTagBuilder((ImageStreamTag)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof io.fabric8.openshift.api.model.Group){ this.extension= new GroupBuilder((io.fabric8.openshift.api.model.Group)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof ImageSignature){ this.extension= new ImageSignatureBuilder((ImageSignature)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof AppliedClusterResourceQuota){ this.extension= new AppliedClusterResourceQuotaBuilder((AppliedClusterResourceQuota)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof SecurityContextConstraints){ this.extension= new SecurityContextConstraintsBuilder((SecurityContextConstraints)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof BuildRequest){ this.extension= new BuildRequestBuilder((BuildRequest)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof NetNamespace){ this.extension= new NetNamespaceBuilder((NetNamespace)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof EgressNetworkPolicy){ this.extension= new EgressNetworkPolicyBuilder((EgressNetworkPolicy)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof ImageStream){ this.extension= new ImageStreamBuilder((ImageStream)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof OAuthClient){ this.extension= new OAuthClientBuilder((OAuthClient)extension); _visitables.get("extension").add(this.extension);}
        if (extension instanceof Identity){ this.extension= new IdentityBuilder((Identity)extension); _visitables.get("extension").add(this.extension);}
        return (A) this;
    }

    public Boolean hasExtension() {
        return this.extension != null;
    }

    public A withClusterVersionExtension(ClusterVersion clusterVersionExtension) {
        _visitables.get("extension").remove(this.extension);
        if (clusterVersionExtension!=null){ this.extension= new ClusterVersionBuilder(clusterVersionExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public ClusterOperatorStatusFluent.ClusterVersionExtensionNested<A> withNewClusterVersionExtension() {
        return new ClusterVersionExtensionNestedImpl();
    }

    public ClusterOperatorStatusFluent.ClusterVersionExtensionNested<A> withNewClusterVersionExtensionLike(ClusterVersion item) {
        return new ClusterVersionExtensionNestedImpl(item);
    }

    public A withImageStreamImportExtension(ImageStreamImport imageStreamImportExtension) {
        _visitables.get("extension").remove(this.extension);
        if (imageStreamImportExtension!=null){ this.extension= new ImageStreamImportBuilder(imageStreamImportExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public ClusterOperatorStatusFluent.ImageStreamImportExtensionNested<A> withNewImageStreamImportExtension() {
        return new ImageStreamImportExtensionNestedImpl();
    }

    public ClusterOperatorStatusFluent.ImageStreamImportExtensionNested<A> withNewImageStreamImportExtensionLike(ImageStreamImport item) {
        return new ImageStreamImportExtensionNestedImpl(item);
    }

    public A withProxyExtension(Proxy proxyExtension) {
        _visitables.get("extension").remove(this.extension);
        if (proxyExtension!=null){ this.extension= new ProxyBuilder(proxyExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public ClusterOperatorStatusFluent.ProxyExtensionNested<A> withNewProxyExtension() {
        return new ProxyExtensionNestedImpl();
    }

    public ClusterOperatorStatusFluent.ProxyExtensionNested<A> withNewProxyExtensionLike(Proxy item) {
        return new ProxyExtensionNestedImpl(item);
    }

    public A withProjectExtension(Project projectExtension) {
        _visitables.get("extension").remove(this.extension);
        if (projectExtension!=null){ this.extension= new ProjectBuilder(projectExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public ClusterOperatorStatusFluent.ProjectExtensionNested<A> withNewProjectExtension() {
        return new ProjectExtensionNestedImpl();
    }

    public ClusterOperatorStatusFluent.ProjectExtensionNested<A> withNewProjectExtensionLike(Project item) {
        return new ProjectExtensionNestedImpl(item);
    }

    public A withClusterOperatorExtension(ClusterOperator clusterOperatorExtension) {
        _visitables.get("extension").remove(this.extension);
        if (clusterOperatorExtension!=null){ this.extension= new ClusterOperatorBuilder(clusterOperatorExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public ClusterOperatorStatusFluent.ClusterOperatorExtensionNested<A> withNewClusterOperatorExtension() {
        return new ClusterOperatorExtensionNestedImpl();
    }

    public ClusterOperatorStatusFluent.ClusterOperatorExtensionNested<A> withNewClusterOperatorExtensionLike(ClusterOperator item) {
        return new ClusterOperatorExtensionNestedImpl(item);
    }

    public A withBuildConfigExtension(BuildConfig buildConfigExtension) {
        _visitables.get("extension").remove(this.extension);
        if (buildConfigExtension!=null){ this.extension= new BuildConfigBuilder(buildConfigExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public ClusterOperatorStatusFluent.BuildConfigExtensionNested<A> withNewBuildConfigExtension() {
        return new BuildConfigExtensionNestedImpl();
    }

    public ClusterOperatorStatusFluent.BuildConfigExtensionNested<A> withNewBuildConfigExtensionLike(BuildConfig item) {
        return new BuildConfigExtensionNestedImpl(item);
    }

    public A withInfrastructureExtension(Infrastructure infrastructureExtension) {
        _visitables.get("extension").remove(this.extension);
        if (infrastructureExtension!=null){ this.extension= new InfrastructureBuilder(infrastructureExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public ClusterOperatorStatusFluent.InfrastructureExtensionNested<A> withNewInfrastructureExtension() {
        return new InfrastructureExtensionNestedImpl();
    }

    public ClusterOperatorStatusFluent.InfrastructureExtensionNested<A> withNewInfrastructureExtensionLike(Infrastructure item) {
        return new InfrastructureExtensionNestedImpl(item);
    }

    public A withSchedulerExtension(Scheduler schedulerExtension) {
        _visitables.get("extension").remove(this.extension);
        if (schedulerExtension!=null){ this.extension= new SchedulerBuilder(schedulerExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public ClusterOperatorStatusFluent.SchedulerExtensionNested<A> withNewSchedulerExtension() {
        return new SchedulerExtensionNestedImpl();
    }

    public ClusterOperatorStatusFluent.SchedulerExtensionNested<A> withNewSchedulerExtensionLike(Scheduler item) {
        return new SchedulerExtensionNestedImpl(item);
    }

    public A withRangeAllocationExtension(RangeAllocation rangeAllocationExtension) {
        _visitables.get("extension").remove(this.extension);
        if (rangeAllocationExtension!=null){ this.extension= new RangeAllocationBuilder(rangeAllocationExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public ClusterOperatorStatusFluent.RangeAllocationExtensionNested<A> withNewRangeAllocationExtension() {
        return new RangeAllocationExtensionNestedImpl();
    }

    public ClusterOperatorStatusFluent.RangeAllocationExtensionNested<A> withNewRangeAllocationExtensionLike(RangeAllocation item) {
        return new RangeAllocationExtensionNestedImpl(item);
    }

    public A withRouteExtension(Route routeExtension) {
        _visitables.get("extension").remove(this.extension);
        if (routeExtension!=null){ this.extension= new RouteBuilder(routeExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public ClusterOperatorStatusFluent.RouteExtensionNested<A> withNewRouteExtension() {
        return new RouteExtensionNestedImpl();
    }

    public ClusterOperatorStatusFluent.RouteExtensionNested<A> withNewRouteExtensionLike(Route item) {
        return new RouteExtensionNestedImpl(item);
    }

    public A withClusterNetworkExtension(ClusterNetwork clusterNetworkExtension) {
        _visitables.get("extension").remove(this.extension);
        if (clusterNetworkExtension!=null){ this.extension= new ClusterNetworkBuilder(clusterNetworkExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public ClusterOperatorStatusFluent.ClusterNetworkExtensionNested<A> withNewClusterNetworkExtension() {
        return new ClusterNetworkExtensionNestedImpl();
    }

    public ClusterOperatorStatusFluent.ClusterNetworkExtensionNested<A> withNewClusterNetworkExtensionLike(ClusterNetwork item) {
        return new ClusterNetworkExtensionNestedImpl(item);
    }

    public A withOAuthAuthorizeTokenExtension(OAuthAuthorizeToken oAuthAuthorizeTokenExtension) {
        _visitables.get("extension").remove(this.extension);
        if (oAuthAuthorizeTokenExtension!=null){ this.extension= new OAuthAuthorizeTokenBuilder(oAuthAuthorizeTokenExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public ClusterOperatorStatusFluent.OAuthAuthorizeTokenExtensionNested<A> withNewOAuthAuthorizeTokenExtension() {
        return new OAuthAuthorizeTokenExtensionNestedImpl();
    }

    public ClusterOperatorStatusFluent.OAuthAuthorizeTokenExtensionNested<A> withNewOAuthAuthorizeTokenExtensionLike(OAuthAuthorizeToken item) {
        return new OAuthAuthorizeTokenExtensionNestedImpl(item);
    }

    public A withOAuthExtension(OAuth oAuthExtension) {
        _visitables.get("extension").remove(this.extension);
        if (oAuthExtension!=null){ this.extension= new OAuthBuilder(oAuthExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public ClusterOperatorStatusFluent.OAuthExtensionNested<A> withNewOAuthExtension() {
        return new OAuthExtensionNestedImpl();
    }

    public ClusterOperatorStatusFluent.OAuthExtensionNested<A> withNewOAuthExtensionLike(OAuth item) {
        return new OAuthExtensionNestedImpl(item);
    }

    public A withOperatorHubExtension(OperatorHub operatorHubExtension) {
        _visitables.get("extension").remove(this.extension);
        if (operatorHubExtension!=null){ this.extension= new OperatorHubBuilder(operatorHubExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public ClusterOperatorStatusFluent.OperatorHubExtensionNested<A> withNewOperatorHubExtension() {
        return new OperatorHubExtensionNestedImpl();
    }

    public ClusterOperatorStatusFluent.OperatorHubExtensionNested<A> withNewOperatorHubExtensionLike(OperatorHub item) {
        return new OperatorHubExtensionNestedImpl(item);
    }

    public A withClusterRoleBindingExtension(ClusterRoleBinding clusterRoleBindingExtension) {
        _visitables.get("extension").remove(this.extension);
        if (clusterRoleBindingExtension!=null){ this.extension= new ClusterRoleBindingBuilder(clusterRoleBindingExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public ClusterOperatorStatusFluent.ClusterRoleBindingExtensionNested<A> withNewClusterRoleBindingExtension() {
        return new ClusterRoleBindingExtensionNestedImpl();
    }

    public ClusterOperatorStatusFluent.ClusterRoleBindingExtensionNested<A> withNewClusterRoleBindingExtensionLike(ClusterRoleBinding item) {
        return new ClusterRoleBindingExtensionNestedImpl(item);
    }

    public A withClusterResourceQuotaExtension(ClusterResourceQuota clusterResourceQuotaExtension) {
        _visitables.get("extension").remove(this.extension);
        if (clusterResourceQuotaExtension!=null){ this.extension= new ClusterResourceQuotaBuilder(clusterResourceQuotaExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public ClusterOperatorStatusFluent.ClusterResourceQuotaExtensionNested<A> withNewClusterResourceQuotaExtension() {
        return new ClusterResourceQuotaExtensionNestedImpl();
    }

    public ClusterOperatorStatusFluent.ClusterResourceQuotaExtensionNested<A> withNewClusterResourceQuotaExtensionLike(ClusterResourceQuota item) {
        return new ClusterResourceQuotaExtensionNestedImpl(item);
    }

    public A withProjectRequestExtension(ProjectRequest projectRequestExtension) {
        _visitables.get("extension").remove(this.extension);
        if (projectRequestExtension!=null){ this.extension= new ProjectRequestBuilder(projectRequestExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public ClusterOperatorStatusFluent.ProjectRequestExtensionNested<A> withNewProjectRequestExtension() {
        return new ProjectRequestExtensionNestedImpl();
    }

    public ClusterOperatorStatusFluent.ProjectRequestExtensionNested<A> withNewProjectRequestExtensionLike(ProjectRequest item) {
        return new ProjectRequestExtensionNestedImpl(item);
    }

    public A withTemplateExtension(Template templateExtension) {
        _visitables.get("extension").remove(this.extension);
        if (templateExtension!=null){ this.extension= new TemplateBuilder(templateExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public ClusterOperatorStatusFluent.TemplateExtensionNested<A> withNewTemplateExtension() {
        return new TemplateExtensionNestedImpl();
    }

    public ClusterOperatorStatusFluent.TemplateExtensionNested<A> withNewTemplateExtensionLike(Template item) {
        return new TemplateExtensionNestedImpl(item);
    }

    public A withOAuthClientAuthorizationExtension(OAuthClientAuthorization oAuthClientAuthorizationExtension) {
        _visitables.get("extension").remove(this.extension);
        if (oAuthClientAuthorizationExtension!=null){ this.extension= new OAuthClientAuthorizationBuilder(oAuthClientAuthorizationExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public ClusterOperatorStatusFluent.OAuthClientAuthorizationExtensionNested<A> withNewOAuthClientAuthorizationExtension() {
        return new OAuthClientAuthorizationExtensionNestedImpl();
    }

    public ClusterOperatorStatusFluent.OAuthClientAuthorizationExtensionNested<A> withNewOAuthClientAuthorizationExtensionLike(OAuthClientAuthorization item) {
        return new OAuthClientAuthorizationExtensionNestedImpl(item);
    }

    public A withClusterRoleExtension(ClusterRole clusterRoleExtension) {
        _visitables.get("extension").remove(this.extension);
        if (clusterRoleExtension!=null){ this.extension= new ClusterRoleBuilder(clusterRoleExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public ClusterOperatorStatusFluent.ClusterRoleExtensionNested<A> withNewClusterRoleExtension() {
        return new ClusterRoleExtensionNestedImpl();
    }

    public ClusterOperatorStatusFluent.ClusterRoleExtensionNested<A> withNewClusterRoleExtensionLike(ClusterRole item) {
        return new ClusterRoleExtensionNestedImpl(item);
    }

    public A withImageTagExtension(ImageTag imageTagExtension) {
        _visitables.get("extension").remove(this.extension);
        if (imageTagExtension!=null){ this.extension= new ImageTagBuilder(imageTagExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public ClusterOperatorStatusFluent.ImageTagExtensionNested<A> withNewImageTagExtension() {
        return new ImageTagExtensionNestedImpl();
    }

    public ClusterOperatorStatusFluent.ImageTagExtensionNested<A> withNewImageTagExtensionLike(ImageTag item) {
        return new ImageTagExtensionNestedImpl(item);
    }

    public A withDeploymentConfigExtension(DeploymentConfig deploymentConfigExtension) {
        _visitables.get("extension").remove(this.extension);
        if (deploymentConfigExtension!=null){ this.extension= new DeploymentConfigBuilder(deploymentConfigExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public ClusterOperatorStatusFluent.DeploymentConfigExtensionNested<A> withNewDeploymentConfigExtension() {
        return new DeploymentConfigExtensionNestedImpl();
    }

    public ClusterOperatorStatusFluent.DeploymentConfigExtensionNested<A> withNewDeploymentConfigExtensionLike(DeploymentConfig item) {
        return new DeploymentConfigExtensionNestedImpl(item);
    }

    public A withOAuthAccessTokenExtension(OAuthAccessToken oAuthAccessTokenExtension) {
        _visitables.get("extension").remove(this.extension);
        if (oAuthAccessTokenExtension!=null){ this.extension= new OAuthAccessTokenBuilder(oAuthAccessTokenExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public ClusterOperatorStatusFluent.OAuthAccessTokenExtensionNested<A> withNewOAuthAccessTokenExtension() {
        return new OAuthAccessTokenExtensionNestedImpl();
    }

    public ClusterOperatorStatusFluent.OAuthAccessTokenExtensionNested<A> withNewOAuthAccessTokenExtensionLike(OAuthAccessToken item) {
        return new OAuthAccessTokenExtensionNestedImpl(item);
    }

    public A withRoleBindingExtension(RoleBinding roleBindingExtension) {
        _visitables.get("extension").remove(this.extension);
        if (roleBindingExtension!=null){ this.extension= new RoleBindingBuilder(roleBindingExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public ClusterOperatorStatusFluent.RoleBindingExtensionNested<A> withNewRoleBindingExtension() {
        return new RoleBindingExtensionNestedImpl();
    }

    public ClusterOperatorStatusFluent.RoleBindingExtensionNested<A> withNewRoleBindingExtensionLike(RoleBinding item) {
        return new RoleBindingExtensionNestedImpl(item);
    }

    public A withImageExtension(Image imageExtension) {
        _visitables.get("extension").remove(this.extension);
        if (imageExtension!=null){ this.extension= new ImageBuilder(imageExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public ClusterOperatorStatusFluent.ImageExtensionNested<A> withNewImageExtension() {
        return new ImageExtensionNestedImpl();
    }

    public ClusterOperatorStatusFluent.ImageExtensionNested<A> withNewImageExtensionLike(Image item) {
        return new ImageExtensionNestedImpl(item);
    }

    public A withAPIServerExtension(APIServer aPIServerExtension) {
        _visitables.get("extension").remove(this.extension);
        if (aPIServerExtension!=null){ this.extension= new APIServerBuilder(aPIServerExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public ClusterOperatorStatusFluent.APIServerExtensionNested<A> withNewAPIServerExtension() {
        return new APIServerExtensionNestedImpl();
    }

    public ClusterOperatorStatusFluent.APIServerExtensionNested<A> withNewAPIServerExtensionLike(APIServer item) {
        return new APIServerExtensionNestedImpl(item);
    }

    public A withPersistentVolumeClaimExtension(PersistentVolumeClaim persistentVolumeClaimExtension) {
        _visitables.get("extension").remove(this.extension);
        if (persistentVolumeClaimExtension!=null){ this.extension= new PersistentVolumeClaimBuilder(persistentVolumeClaimExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public ClusterOperatorStatusFluent.PersistentVolumeClaimExtensionNested<A> withNewPersistentVolumeClaimExtension() {
        return new PersistentVolumeClaimExtensionNestedImpl();
    }

    public ClusterOperatorStatusFluent.PersistentVolumeClaimExtensionNested<A> withNewPersistentVolumeClaimExtensionLike(PersistentVolumeClaim item) {
        return new PersistentVolumeClaimExtensionNestedImpl(item);
    }

    public A withImageStreamMappingExtension(ImageStreamMapping imageStreamMappingExtension) {
        _visitables.get("extension").remove(this.extension);
        if (imageStreamMappingExtension!=null){ this.extension= new ImageStreamMappingBuilder(imageStreamMappingExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public ClusterOperatorStatusFluent.ImageStreamMappingExtensionNested<A> withNewImageStreamMappingExtension() {
        return new ImageStreamMappingExtensionNestedImpl();
    }

    public ClusterOperatorStatusFluent.ImageStreamMappingExtensionNested<A> withNewImageStreamMappingExtensionLike(ImageStreamMapping item) {
        return new ImageStreamMappingExtensionNestedImpl(item);
    }

    public A withRoleExtension(Role roleExtension) {
        _visitables.get("extension").remove(this.extension);
        if (roleExtension!=null){ this.extension= new RoleBuilder(roleExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public ClusterOperatorStatusFluent.RoleExtensionNested<A> withNewRoleExtension() {
        return new RoleExtensionNestedImpl();
    }

    public ClusterOperatorStatusFluent.RoleExtensionNested<A> withNewRoleExtensionLike(Role item) {
        return new RoleExtensionNestedImpl(item);
    }

    public A withFeatureGateExtension(FeatureGate featureGateExtension) {
        _visitables.get("extension").remove(this.extension);
        if (featureGateExtension!=null){ this.extension= new FeatureGateBuilder(featureGateExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public ClusterOperatorStatusFluent.FeatureGateExtensionNested<A> withNewFeatureGateExtension() {
        return new FeatureGateExtensionNestedImpl();
    }

    public ClusterOperatorStatusFluent.FeatureGateExtensionNested<A> withNewFeatureGateExtensionLike(FeatureGate item) {
        return new FeatureGateExtensionNestedImpl(item);
    }

    public A withUserExtension(User userExtension) {
        _visitables.get("extension").remove(this.extension);
        if (userExtension!=null){ this.extension= new UserBuilder(userExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public ClusterOperatorStatusFluent.UserExtensionNested<A> withNewUserExtension() {
        return new UserExtensionNestedImpl();
    }

    public ClusterOperatorStatusFluent.UserExtensionNested<A> withNewUserExtensionLike(User item) {
        return new UserExtensionNestedImpl(item);
    }

    public A withImageStreamImageExtension(ImageStreamImage imageStreamImageExtension) {
        _visitables.get("extension").remove(this.extension);
        if (imageStreamImageExtension!=null){ this.extension= new ImageStreamImageBuilder(imageStreamImageExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public ClusterOperatorStatusFluent.ImageStreamImageExtensionNested<A> withNewImageStreamImageExtension() {
        return new ImageStreamImageExtensionNestedImpl();
    }

    public ClusterOperatorStatusFluent.ImageStreamImageExtensionNested<A> withNewImageStreamImageExtensionLike(ImageStreamImage item) {
        return new ImageStreamImageExtensionNestedImpl(item);
    }

    public A withBuildExtension(Build buildExtension) {
        _visitables.get("extension").remove(this.extension);
        if (buildExtension!=null){ this.extension= new BuildBuilder(buildExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public ClusterOperatorStatusFluent.BuildExtensionNested<A> withNewBuildExtension() {
        return new BuildExtensionNestedImpl();
    }

    public ClusterOperatorStatusFluent.BuildExtensionNested<A> withNewBuildExtensionLike(Build item) {
        return new BuildExtensionNestedImpl(item);
    }

    public A withRoleBindingRestrictionExtension(RoleBindingRestriction roleBindingRestrictionExtension) {
        _visitables.get("extension").remove(this.extension);
        if (roleBindingRestrictionExtension!=null){ this.extension= new RoleBindingRestrictionBuilder(roleBindingRestrictionExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public ClusterOperatorStatusFluent.RoleBindingRestrictionExtensionNested<A> withNewRoleBindingRestrictionExtension() {
        return new RoleBindingRestrictionExtensionNestedImpl();
    }

    public ClusterOperatorStatusFluent.RoleBindingRestrictionExtensionNested<A> withNewRoleBindingRestrictionExtensionLike(RoleBindingRestriction item) {
        return new RoleBindingRestrictionExtensionNestedImpl(item);
    }

    public A withImageStreamTagExtension(ImageStreamTag imageStreamTagExtension) {
        _visitables.get("extension").remove(this.extension);
        if (imageStreamTagExtension!=null){ this.extension= new ImageStreamTagBuilder(imageStreamTagExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public ClusterOperatorStatusFluent.ImageStreamTagExtensionNested<A> withNewImageStreamTagExtension() {
        return new ImageStreamTagExtensionNestedImpl();
    }

    public ClusterOperatorStatusFluent.ImageStreamTagExtensionNested<A> withNewImageStreamTagExtensionLike(ImageStreamTag item) {
        return new ImageStreamTagExtensionNestedImpl(item);
    }

    public A withGroupExtension(io.fabric8.openshift.api.model.Group groupExtension) {
        _visitables.get("extension").remove(this.extension);
        if (groupExtension!=null){ this.extension= new GroupBuilder(groupExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public ClusterOperatorStatusFluent.GroupExtensionNested<A> withNewGroupExtension() {
        return new GroupExtensionNestedImpl();
    }

    public ClusterOperatorStatusFluent.GroupExtensionNested<A> withNewGroupExtensionLike(io.fabric8.openshift.api.model.Group item) {
        return new GroupExtensionNestedImpl(item);
    }

    public A withImageSignatureExtension(ImageSignature imageSignatureExtension) {
        _visitables.get("extension").remove(this.extension);
        if (imageSignatureExtension!=null){ this.extension= new ImageSignatureBuilder(imageSignatureExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public ClusterOperatorStatusFluent.ImageSignatureExtensionNested<A> withNewImageSignatureExtension() {
        return new ImageSignatureExtensionNestedImpl();
    }

    public ClusterOperatorStatusFluent.ImageSignatureExtensionNested<A> withNewImageSignatureExtensionLike(ImageSignature item) {
        return new ImageSignatureExtensionNestedImpl(item);
    }

    public A withAppliedClusterResourceQuotaExtension(AppliedClusterResourceQuota appliedClusterResourceQuotaExtension) {
        _visitables.get("extension").remove(this.extension);
        if (appliedClusterResourceQuotaExtension!=null){ this.extension= new AppliedClusterResourceQuotaBuilder(appliedClusterResourceQuotaExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public ClusterOperatorStatusFluent.AppliedClusterResourceQuotaExtensionNested<A> withNewAppliedClusterResourceQuotaExtension() {
        return new AppliedClusterResourceQuotaExtensionNestedImpl();
    }

    public ClusterOperatorStatusFluent.AppliedClusterResourceQuotaExtensionNested<A> withNewAppliedClusterResourceQuotaExtensionLike(AppliedClusterResourceQuota item) {
        return new AppliedClusterResourceQuotaExtensionNestedImpl(item);
    }

    public A withSecurityContextConstraintsExtension(SecurityContextConstraints securityContextConstraintsExtension) {
        _visitables.get("extension").remove(this.extension);
        if (securityContextConstraintsExtension!=null){ this.extension= new SecurityContextConstraintsBuilder(securityContextConstraintsExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public ClusterOperatorStatusFluent.SecurityContextConstraintsExtensionNested<A> withNewSecurityContextConstraintsExtension() {
        return new SecurityContextConstraintsExtensionNestedImpl();
    }

    public ClusterOperatorStatusFluent.SecurityContextConstraintsExtensionNested<A> withNewSecurityContextConstraintsExtensionLike(SecurityContextConstraints item) {
        return new SecurityContextConstraintsExtensionNestedImpl(item);
    }

    public A withBuildRequestExtension(BuildRequest buildRequestExtension) {
        _visitables.get("extension").remove(this.extension);
        if (buildRequestExtension!=null){ this.extension= new BuildRequestBuilder(buildRequestExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public ClusterOperatorStatusFluent.BuildRequestExtensionNested<A> withNewBuildRequestExtension() {
        return new BuildRequestExtensionNestedImpl();
    }

    public ClusterOperatorStatusFluent.BuildRequestExtensionNested<A> withNewBuildRequestExtensionLike(BuildRequest item) {
        return new BuildRequestExtensionNestedImpl(item);
    }

    public A withNetNamespaceExtension(NetNamespace netNamespaceExtension) {
        _visitables.get("extension").remove(this.extension);
        if (netNamespaceExtension!=null){ this.extension= new NetNamespaceBuilder(netNamespaceExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public ClusterOperatorStatusFluent.NetNamespaceExtensionNested<A> withNewNetNamespaceExtension() {
        return new NetNamespaceExtensionNestedImpl();
    }

    public ClusterOperatorStatusFluent.NetNamespaceExtensionNested<A> withNewNetNamespaceExtensionLike(NetNamespace item) {
        return new NetNamespaceExtensionNestedImpl(item);
    }

    public A withEgressNetworkPolicyExtension(EgressNetworkPolicy egressNetworkPolicyExtension) {
        _visitables.get("extension").remove(this.extension);
        if (egressNetworkPolicyExtension!=null){ this.extension= new EgressNetworkPolicyBuilder(egressNetworkPolicyExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public ClusterOperatorStatusFluent.EgressNetworkPolicyExtensionNested<A> withNewEgressNetworkPolicyExtension() {
        return new EgressNetworkPolicyExtensionNestedImpl();
    }

    public ClusterOperatorStatusFluent.EgressNetworkPolicyExtensionNested<A> withNewEgressNetworkPolicyExtensionLike(EgressNetworkPolicy item) {
        return new EgressNetworkPolicyExtensionNestedImpl(item);
    }

    public A withImageStreamExtension(ImageStream imageStreamExtension) {
        _visitables.get("extension").remove(this.extension);
        if (imageStreamExtension!=null){ this.extension= new ImageStreamBuilder(imageStreamExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public ClusterOperatorStatusFluent.ImageStreamExtensionNested<A> withNewImageStreamExtension() {
        return new ImageStreamExtensionNestedImpl();
    }

    public ClusterOperatorStatusFluent.ImageStreamExtensionNested<A> withNewImageStreamExtensionLike(ImageStream item) {
        return new ImageStreamExtensionNestedImpl(item);
    }

    public A withOAuthClientExtension(OAuthClient oAuthClientExtension) {
        _visitables.get("extension").remove(this.extension);
        if (oAuthClientExtension!=null){ this.extension= new OAuthClientBuilder(oAuthClientExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public ClusterOperatorStatusFluent.OAuthClientExtensionNested<A> withNewOAuthClientExtension() {
        return new OAuthClientExtensionNestedImpl();
    }

    public ClusterOperatorStatusFluent.OAuthClientExtensionNested<A> withNewOAuthClientExtensionLike(OAuthClient item) {
        return new OAuthClientExtensionNestedImpl(item);
    }

    public A withIdentityExtension(Identity identityExtension) {
        _visitables.get("extension").remove(this.extension);
        if (identityExtension!=null){ this.extension= new IdentityBuilder(identityExtension); _visitables.get("extension").add(this.extension);} return (A) this;
    }

    public ClusterOperatorStatusFluent.IdentityExtensionNested<A> withNewIdentityExtension() {
        return new IdentityExtensionNestedImpl();
    }

    public ClusterOperatorStatusFluent.IdentityExtensionNested<A> withNewIdentityExtensionLike(Identity item) {
        return new IdentityExtensionNestedImpl(item);
    }

    public A addToRelatedObjects(int index,io.fabric8.openshift.api.model.ObjectReference item) {
        if (this.relatedObjects == null) {this.relatedObjects = new ArrayList<io.fabric8.openshift.api.model.ObjectReferenceBuilder>();}
        io.fabric8.openshift.api.model.ObjectReferenceBuilder builder = new io.fabric8.openshift.api.model.ObjectReferenceBuilder(item);_visitables.get("relatedObjects").add(index >= 0 ? index : _visitables.get("relatedObjects").size(), builder);this.relatedObjects.add(index >= 0 ? index : relatedObjects.size(), builder); return (A)this;
    }

    public A setToRelatedObjects(int index,io.fabric8.openshift.api.model.ObjectReference item) {
        if (this.relatedObjects == null) {this.relatedObjects = new ArrayList<io.fabric8.openshift.api.model.ObjectReferenceBuilder>();}
        io.fabric8.openshift.api.model.ObjectReferenceBuilder builder = new io.fabric8.openshift.api.model.ObjectReferenceBuilder(item);
        if (index < 0 || index >= _visitables.get("relatedObjects").size()) { _visitables.get("relatedObjects").add(builder); } else { _visitables.get("relatedObjects").set(index, builder);}
        if (index < 0 || index >= relatedObjects.size()) { relatedObjects.add(builder); } else { relatedObjects.set(index, builder);}
         return (A)this;
    }

    public A addToRelatedObjects(io.fabric8.openshift.api.model.ObjectReference... items) {
        if (this.relatedObjects == null) {this.relatedObjects = new ArrayList<io.fabric8.openshift.api.model.ObjectReferenceBuilder>();}
        for (io.fabric8.openshift.api.model.ObjectReference item : items) {io.fabric8.openshift.api.model.ObjectReferenceBuilder builder = new io.fabric8.openshift.api.model.ObjectReferenceBuilder(item);_visitables.get("relatedObjects").add(builder);this.relatedObjects.add(builder);} return (A)this;
    }

    public A addAllToRelatedObjects(Collection<io.fabric8.openshift.api.model.ObjectReference> items) {
        if (this.relatedObjects == null) {this.relatedObjects = new ArrayList<io.fabric8.openshift.api.model.ObjectReferenceBuilder>();}
        for (io.fabric8.openshift.api.model.ObjectReference item : items) {io.fabric8.openshift.api.model.ObjectReferenceBuilder builder = new io.fabric8.openshift.api.model.ObjectReferenceBuilder(item);_visitables.get("relatedObjects").add(builder);this.relatedObjects.add(builder);} return (A)this;
    }

    public A removeFromRelatedObjects(io.fabric8.openshift.api.model.ObjectReference... items) {
        for (io.fabric8.openshift.api.model.ObjectReference item : items) {io.fabric8.openshift.api.model.ObjectReferenceBuilder builder = new io.fabric8.openshift.api.model.ObjectReferenceBuilder(item);_visitables.get("relatedObjects").remove(builder);if (this.relatedObjects != null) {this.relatedObjects.remove(builder);}} return (A)this;
    }

    public A removeAllFromRelatedObjects(Collection<io.fabric8.openshift.api.model.ObjectReference> items) {
        for (io.fabric8.openshift.api.model.ObjectReference item : items) {io.fabric8.openshift.api.model.ObjectReferenceBuilder builder = new io.fabric8.openshift.api.model.ObjectReferenceBuilder(item);_visitables.get("relatedObjects").remove(builder);if (this.relatedObjects != null) {this.relatedObjects.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromRelatedObjects(Predicate<io.fabric8.openshift.api.model.ObjectReferenceBuilder> predicate) {
        if (relatedObjects == null) return (A) this;
        final Iterator<io.fabric8.openshift.api.model.ObjectReferenceBuilder> each = relatedObjects.iterator();
        final List visitables = _visitables.get("relatedObjects");
        while (each.hasNext()) {
          io.fabric8.openshift.api.model.ObjectReferenceBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildRelatedObjects instead.
 * @return The buildable object.
 */
@Deprecated public List<io.fabric8.openshift.api.model.ObjectReference> getRelatedObjects() {
        return build(relatedObjects);
    }

    public List<io.fabric8.openshift.api.model.ObjectReference> buildRelatedObjects() {
        return build(relatedObjects);
    }

    public io.fabric8.openshift.api.model.ObjectReference buildRelatedObject(int index) {
        return this.relatedObjects.get(index).build();
    }

    public io.fabric8.openshift.api.model.ObjectReference buildFirstRelatedObject() {
        return this.relatedObjects.get(0).build();
    }

    public io.fabric8.openshift.api.model.ObjectReference buildLastRelatedObject() {
        return this.relatedObjects.get(relatedObjects.size() - 1).build();
    }

    public io.fabric8.openshift.api.model.ObjectReference buildMatchingRelatedObject(Predicate<io.fabric8.openshift.api.model.ObjectReferenceBuilder> predicate) {
        for (io.fabric8.openshift.api.model.ObjectReferenceBuilder item: relatedObjects) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingRelatedObject(Predicate<io.fabric8.openshift.api.model.ObjectReferenceBuilder> predicate) {
        for (io.fabric8.openshift.api.model.ObjectReferenceBuilder item: relatedObjects) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withRelatedObjects(List<io.fabric8.openshift.api.model.ObjectReference> relatedObjects) {
        if (this.relatedObjects != null) { _visitables.get("relatedObjects").removeAll(this.relatedObjects);}
        if (relatedObjects != null) {this.relatedObjects = new ArrayList<io.fabric8.openshift.api.model.ObjectReferenceBuilder>(); for (io.fabric8.openshift.api.model.ObjectReference item : relatedObjects){this.addToRelatedObjects(item);}} else { this.relatedObjects = null;} return (A) this;
    }

    public A withRelatedObjects(io.fabric8.openshift.api.model.ObjectReference... relatedObjects) {
        if (this.relatedObjects != null) {this.relatedObjects.clear();}
        if (relatedObjects != null) {for (io.fabric8.openshift.api.model.ObjectReference item :relatedObjects){ this.addToRelatedObjects(item);}} return (A) this;
    }

    public Boolean hasRelatedObjects() {
        return relatedObjects != null && !relatedObjects.isEmpty();
    }

    public A addNewRelatedObject(String group,String name,String namespace,String resource) {
        return (A)addToRelatedObjects(new ObjectReference(group, name, namespace, resource));
    }

    public ClusterOperatorStatusFluent.RelatedObjectsNested<A> addNewRelatedObject() {
        return new RelatedObjectsNestedImpl();
    }

    public ClusterOperatorStatusFluent.RelatedObjectsNested<A> addNewRelatedObjectLike(io.fabric8.openshift.api.model.ObjectReference item) {
        return new RelatedObjectsNestedImpl(-1, item);
    }

    public ClusterOperatorStatusFluent.RelatedObjectsNested<A> setNewRelatedObjectLike(int index,io.fabric8.openshift.api.model.ObjectReference item) {
        return new RelatedObjectsNestedImpl(index, item);
    }

    public ClusterOperatorStatusFluent.RelatedObjectsNested<A> editRelatedObject(int index) {
        if (relatedObjects.size() <= index) throw new RuntimeException("Can't edit relatedObjects. Index exceeds size.");
        return setNewRelatedObjectLike(index, buildRelatedObject(index));
    }

    public ClusterOperatorStatusFluent.RelatedObjectsNested<A> editFirstRelatedObject() {
        if (relatedObjects.size() == 0) throw new RuntimeException("Can't edit first relatedObjects. The list is empty.");
        return setNewRelatedObjectLike(0, buildRelatedObject(0));
    }

    public ClusterOperatorStatusFluent.RelatedObjectsNested<A> editLastRelatedObject() {
        int index = relatedObjects.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last relatedObjects. The list is empty.");
        return setNewRelatedObjectLike(index, buildRelatedObject(index));
    }

    public ClusterOperatorStatusFluent.RelatedObjectsNested<A> editMatchingRelatedObject(Predicate<io.fabric8.openshift.api.model.ObjectReferenceBuilder> predicate) {
        int index = -1;
        for (int i=0;i<relatedObjects.size();i++) { 
        if (predicate.test(relatedObjects.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching relatedObjects. No match found.");
        return setNewRelatedObjectLike(index, buildRelatedObject(index));
    }

    public A addToVersions(int index,OperandVersion item) {
        if (this.versions == null) {this.versions = new ArrayList<OperandVersionBuilder>();}
        OperandVersionBuilder builder = new OperandVersionBuilder(item);_visitables.get("versions").add(index >= 0 ? index : _visitables.get("versions").size(), builder);this.versions.add(index >= 0 ? index : versions.size(), builder); return (A)this;
    }

    public A setToVersions(int index,OperandVersion item) {
        if (this.versions == null) {this.versions = new ArrayList<OperandVersionBuilder>();}
        OperandVersionBuilder builder = new OperandVersionBuilder(item);
        if (index < 0 || index >= _visitables.get("versions").size()) { _visitables.get("versions").add(builder); } else { _visitables.get("versions").set(index, builder);}
        if (index < 0 || index >= versions.size()) { versions.add(builder); } else { versions.set(index, builder);}
         return (A)this;
    }

    public A addToVersions(OperandVersion... items) {
        if (this.versions == null) {this.versions = new ArrayList<OperandVersionBuilder>();}
        for (OperandVersion item : items) {OperandVersionBuilder builder = new OperandVersionBuilder(item);_visitables.get("versions").add(builder);this.versions.add(builder);} return (A)this;
    }

    public A addAllToVersions(Collection<OperandVersion> items) {
        if (this.versions == null) {this.versions = new ArrayList<OperandVersionBuilder>();}
        for (OperandVersion item : items) {OperandVersionBuilder builder = new OperandVersionBuilder(item);_visitables.get("versions").add(builder);this.versions.add(builder);} return (A)this;
    }

    public A removeFromVersions(OperandVersion... items) {
        for (OperandVersion item : items) {OperandVersionBuilder builder = new OperandVersionBuilder(item);_visitables.get("versions").remove(builder);if (this.versions != null) {this.versions.remove(builder);}} return (A)this;
    }

    public A removeAllFromVersions(Collection<OperandVersion> items) {
        for (OperandVersion item : items) {OperandVersionBuilder builder = new OperandVersionBuilder(item);_visitables.get("versions").remove(builder);if (this.versions != null) {this.versions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromVersions(Predicate<OperandVersionBuilder> predicate) {
        if (versions == null) return (A) this;
        final Iterator<OperandVersionBuilder> each = versions.iterator();
        final List visitables = _visitables.get("versions");
        while (each.hasNext()) {
          OperandVersionBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildVersions instead.
 * @return The buildable object.
 */
@Deprecated public List<OperandVersion> getVersions() {
        return build(versions);
    }

    public List<OperandVersion> buildVersions() {
        return build(versions);
    }

    public OperandVersion buildVersion(int index) {
        return this.versions.get(index).build();
    }

    public OperandVersion buildFirstVersion() {
        return this.versions.get(0).build();
    }

    public OperandVersion buildLastVersion() {
        return this.versions.get(versions.size() - 1).build();
    }

    public OperandVersion buildMatchingVersion(Predicate<OperandVersionBuilder> predicate) {
        for (OperandVersionBuilder item: versions) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingVersion(Predicate<OperandVersionBuilder> predicate) {
        for (OperandVersionBuilder item: versions) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withVersions(List<OperandVersion> versions) {
        if (this.versions != null) { _visitables.get("versions").removeAll(this.versions);}
        if (versions != null) {this.versions = new ArrayList<OperandVersionBuilder>(); for (OperandVersion item : versions){this.addToVersions(item);}} else { this.versions = null;} return (A) this;
    }

    public A withVersions(OperandVersion... versions) {
        if (this.versions != null) {this.versions.clear();}
        if (versions != null) {for (OperandVersion item :versions){ this.addToVersions(item);}} return (A) this;
    }

    public Boolean hasVersions() {
        return versions != null && !versions.isEmpty();
    }

    public A addNewVersion(String name,String version) {
        return (A)addToVersions(new OperandVersion(name, version));
    }

    public ClusterOperatorStatusFluent.VersionsNested<A> addNewVersion() {
        return new VersionsNestedImpl();
    }

    public ClusterOperatorStatusFluent.VersionsNested<A> addNewVersionLike(OperandVersion item) {
        return new VersionsNestedImpl(-1, item);
    }

    public ClusterOperatorStatusFluent.VersionsNested<A> setNewVersionLike(int index,OperandVersion item) {
        return new VersionsNestedImpl(index, item);
    }

    public ClusterOperatorStatusFluent.VersionsNested<A> editVersion(int index) {
        if (versions.size() <= index) throw new RuntimeException("Can't edit versions. Index exceeds size.");
        return setNewVersionLike(index, buildVersion(index));
    }

    public ClusterOperatorStatusFluent.VersionsNested<A> editFirstVersion() {
        if (versions.size() == 0) throw new RuntimeException("Can't edit first versions. The list is empty.");
        return setNewVersionLike(0, buildVersion(0));
    }

    public ClusterOperatorStatusFluent.VersionsNested<A> editLastVersion() {
        int index = versions.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last versions. The list is empty.");
        return setNewVersionLike(index, buildVersion(index));
    }

    public ClusterOperatorStatusFluent.VersionsNested<A> editMatchingVersion(Predicate<OperandVersionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<versions.size();i++) { 
        if (predicate.test(versions.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching versions. No match found.");
        return setNewVersionLike(index, buildVersion(index));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ClusterOperatorStatusFluentImpl that = (ClusterOperatorStatusFluentImpl) o;
        if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
        if (extension != null ? !extension.equals(that.extension) :that.extension != null) return false;
        if (relatedObjects != null ? !relatedObjects.equals(that.relatedObjects) :that.relatedObjects != null) return false;
        if (versions != null ? !versions.equals(that.versions) :that.versions != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(conditions,  extension,  relatedObjects,  versions,  super.hashCode());
    }

    public class ConditionsNestedImpl<N> extends ClusterOperatorStatusConditionFluentImpl<ClusterOperatorStatusFluent.ConditionsNested<N>> implements ClusterOperatorStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ClusterOperatorStatusConditionBuilder builder;
        private final int index;

            ConditionsNestedImpl(int index,ClusterOperatorStatusCondition item) {
                this.index = index;
                this.builder = new ClusterOperatorStatusConditionBuilder(this, item);
                        
            }

            ConditionsNestedImpl() {
                this.index = -1;
                this.builder = new ClusterOperatorStatusConditionBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterOperatorStatusFluentImpl.this.setToConditions(index,builder.build());
            }

            public N endCondition() {
                return and();
            }
    }


    public class ClusterVersionExtensionNestedImpl<N> extends ClusterVersionFluentImpl<ClusterOperatorStatusFluent.ClusterVersionExtensionNested<N>> implements ClusterOperatorStatusFluent.ClusterVersionExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ClusterVersionBuilder builder;

            ClusterVersionExtensionNestedImpl(ClusterVersion item) {
                this.builder = new ClusterVersionBuilder(this, item);
                        
            }

            ClusterVersionExtensionNestedImpl() {
                this.builder = new ClusterVersionBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
            }

            public N endClusterVersionExtension() {
                return and();
            }
    }


    public class ImageStreamImportExtensionNestedImpl<N> extends ImageStreamImportFluentImpl<ClusterOperatorStatusFluent.ImageStreamImportExtensionNested<N>> implements ClusterOperatorStatusFluent.ImageStreamImportExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ImageStreamImportBuilder builder;

            ImageStreamImportExtensionNestedImpl(ImageStreamImport item) {
                this.builder = new ImageStreamImportBuilder(this, item);
                        
            }

            ImageStreamImportExtensionNestedImpl() {
                this.builder = new ImageStreamImportBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
            }

            public N endImageStreamImportExtension() {
                return and();
            }
    }


    public class ProxyExtensionNestedImpl<N> extends ProxyFluentImpl<ClusterOperatorStatusFluent.ProxyExtensionNested<N>> implements ClusterOperatorStatusFluent.ProxyExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ProxyBuilder builder;

            ProxyExtensionNestedImpl(Proxy item) {
                this.builder = new ProxyBuilder(this, item);
                        
            }

            ProxyExtensionNestedImpl() {
                this.builder = new ProxyBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
            }

            public N endProxyExtension() {
                return and();
            }
    }


    public class ProjectExtensionNestedImpl<N> extends ProjectFluentImpl<ClusterOperatorStatusFluent.ProjectExtensionNested<N>> implements ClusterOperatorStatusFluent.ProjectExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ProjectBuilder builder;

            ProjectExtensionNestedImpl(Project item) {
                this.builder = new ProjectBuilder(this, item);
                        
            }

            ProjectExtensionNestedImpl() {
                this.builder = new ProjectBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
            }

            public N endProjectExtension() {
                return and();
            }
    }


    public class ClusterOperatorExtensionNestedImpl<N> extends ClusterOperatorFluentImpl<ClusterOperatorStatusFluent.ClusterOperatorExtensionNested<N>> implements ClusterOperatorStatusFluent.ClusterOperatorExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ClusterOperatorBuilder builder;

            ClusterOperatorExtensionNestedImpl(ClusterOperator item) {
                this.builder = new ClusterOperatorBuilder(this, item);
                        
            }

            ClusterOperatorExtensionNestedImpl() {
                this.builder = new ClusterOperatorBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
            }

            public N endClusterOperatorExtension() {
                return and();
            }
    }


    public class BuildConfigExtensionNestedImpl<N> extends BuildConfigFluentImpl<ClusterOperatorStatusFluent.BuildConfigExtensionNested<N>> implements ClusterOperatorStatusFluent.BuildConfigExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final BuildConfigBuilder builder;

            BuildConfigExtensionNestedImpl(BuildConfig item) {
                this.builder = new BuildConfigBuilder(this, item);
                        
            }

            BuildConfigExtensionNestedImpl() {
                this.builder = new BuildConfigBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
            }

            public N endBuildConfigExtension() {
                return and();
            }
    }


    public class InfrastructureExtensionNestedImpl<N> extends InfrastructureFluentImpl<ClusterOperatorStatusFluent.InfrastructureExtensionNested<N>> implements ClusterOperatorStatusFluent.InfrastructureExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final InfrastructureBuilder builder;

            InfrastructureExtensionNestedImpl(Infrastructure item) {
                this.builder = new InfrastructureBuilder(this, item);
                        
            }

            InfrastructureExtensionNestedImpl() {
                this.builder = new InfrastructureBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
            }

            public N endInfrastructureExtension() {
                return and();
            }
    }


    public class SchedulerExtensionNestedImpl<N> extends SchedulerFluentImpl<ClusterOperatorStatusFluent.SchedulerExtensionNested<N>> implements ClusterOperatorStatusFluent.SchedulerExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SchedulerBuilder builder;

            SchedulerExtensionNestedImpl(Scheduler item) {
                this.builder = new SchedulerBuilder(this, item);
                        
            }

            SchedulerExtensionNestedImpl() {
                this.builder = new SchedulerBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
            }

            public N endSchedulerExtension() {
                return and();
            }
    }


    public class RangeAllocationExtensionNestedImpl<N> extends RangeAllocationFluentImpl<ClusterOperatorStatusFluent.RangeAllocationExtensionNested<N>> implements ClusterOperatorStatusFluent.RangeAllocationExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final RangeAllocationBuilder builder;

            RangeAllocationExtensionNestedImpl(RangeAllocation item) {
                this.builder = new RangeAllocationBuilder(this, item);
                        
            }

            RangeAllocationExtensionNestedImpl() {
                this.builder = new RangeAllocationBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
            }

            public N endRangeAllocationExtension() {
                return and();
            }
    }


    public class RouteExtensionNestedImpl<N> extends RouteFluentImpl<ClusterOperatorStatusFluent.RouteExtensionNested<N>> implements ClusterOperatorStatusFluent.RouteExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final RouteBuilder builder;

            RouteExtensionNestedImpl(Route item) {
                this.builder = new RouteBuilder(this, item);
                        
            }

            RouteExtensionNestedImpl() {
                this.builder = new RouteBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
            }

            public N endRouteExtension() {
                return and();
            }
    }


    public class ClusterNetworkExtensionNestedImpl<N> extends ClusterNetworkFluentImpl<ClusterOperatorStatusFluent.ClusterNetworkExtensionNested<N>> implements ClusterOperatorStatusFluent.ClusterNetworkExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ClusterNetworkBuilder builder;

            ClusterNetworkExtensionNestedImpl(ClusterNetwork item) {
                this.builder = new ClusterNetworkBuilder(this, item);
                        
            }

            ClusterNetworkExtensionNestedImpl() {
                this.builder = new ClusterNetworkBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
            }

            public N endClusterNetworkExtension() {
                return and();
            }
    }


    public class OAuthAuthorizeTokenExtensionNestedImpl<N> extends OAuthAuthorizeTokenFluentImpl<ClusterOperatorStatusFluent.OAuthAuthorizeTokenExtensionNested<N>> implements ClusterOperatorStatusFluent.OAuthAuthorizeTokenExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final OAuthAuthorizeTokenBuilder builder;

            OAuthAuthorizeTokenExtensionNestedImpl(OAuthAuthorizeToken item) {
                this.builder = new OAuthAuthorizeTokenBuilder(this, item);
                        
            }

            OAuthAuthorizeTokenExtensionNestedImpl() {
                this.builder = new OAuthAuthorizeTokenBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
            }

            public N endOAuthAuthorizeTokenExtension() {
                return and();
            }
    }


    public class OAuthExtensionNestedImpl<N> extends OAuthFluentImpl<ClusterOperatorStatusFluent.OAuthExtensionNested<N>> implements ClusterOperatorStatusFluent.OAuthExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final OAuthBuilder builder;

            OAuthExtensionNestedImpl(OAuth item) {
                this.builder = new OAuthBuilder(this, item);
                        
            }

            OAuthExtensionNestedImpl() {
                this.builder = new OAuthBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
            }

            public N endOAuthExtension() {
                return and();
            }
    }


    public class OperatorHubExtensionNestedImpl<N> extends OperatorHubFluentImpl<ClusterOperatorStatusFluent.OperatorHubExtensionNested<N>> implements ClusterOperatorStatusFluent.OperatorHubExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final OperatorHubBuilder builder;

            OperatorHubExtensionNestedImpl(OperatorHub item) {
                this.builder = new OperatorHubBuilder(this, item);
                        
            }

            OperatorHubExtensionNestedImpl() {
                this.builder = new OperatorHubBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
            }

            public N endOperatorHubExtension() {
                return and();
            }
    }


    public class ClusterRoleBindingExtensionNestedImpl<N> extends ClusterRoleBindingFluentImpl<ClusterOperatorStatusFluent.ClusterRoleBindingExtensionNested<N>> implements ClusterOperatorStatusFluent.ClusterRoleBindingExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ClusterRoleBindingBuilder builder;

            ClusterRoleBindingExtensionNestedImpl(ClusterRoleBinding item) {
                this.builder = new ClusterRoleBindingBuilder(this, item);
                        
            }

            ClusterRoleBindingExtensionNestedImpl() {
                this.builder = new ClusterRoleBindingBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
            }

            public N endClusterRoleBindingExtension() {
                return and();
            }
    }


    public class ClusterResourceQuotaExtensionNestedImpl<N> extends ClusterResourceQuotaFluentImpl<ClusterOperatorStatusFluent.ClusterResourceQuotaExtensionNested<N>> implements ClusterOperatorStatusFluent.ClusterResourceQuotaExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ClusterResourceQuotaBuilder builder;

            ClusterResourceQuotaExtensionNestedImpl(ClusterResourceQuota item) {
                this.builder = new ClusterResourceQuotaBuilder(this, item);
                        
            }

            ClusterResourceQuotaExtensionNestedImpl() {
                this.builder = new ClusterResourceQuotaBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
            }

            public N endClusterResourceQuotaExtension() {
                return and();
            }
    }


    public class ProjectRequestExtensionNestedImpl<N> extends ProjectRequestFluentImpl<ClusterOperatorStatusFluent.ProjectRequestExtensionNested<N>> implements ClusterOperatorStatusFluent.ProjectRequestExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ProjectRequestBuilder builder;

            ProjectRequestExtensionNestedImpl(ProjectRequest item) {
                this.builder = new ProjectRequestBuilder(this, item);
                        
            }

            ProjectRequestExtensionNestedImpl() {
                this.builder = new ProjectRequestBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
            }

            public N endProjectRequestExtension() {
                return and();
            }
    }


    public class TemplateExtensionNestedImpl<N> extends TemplateFluentImpl<ClusterOperatorStatusFluent.TemplateExtensionNested<N>> implements ClusterOperatorStatusFluent.TemplateExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final TemplateBuilder builder;

            TemplateExtensionNestedImpl(Template item) {
                this.builder = new TemplateBuilder(this, item);
                        
            }

            TemplateExtensionNestedImpl() {
                this.builder = new TemplateBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
            }

            public N endTemplateExtension() {
                return and();
            }
    }


    public class OAuthClientAuthorizationExtensionNestedImpl<N> extends OAuthClientAuthorizationFluentImpl<ClusterOperatorStatusFluent.OAuthClientAuthorizationExtensionNested<N>> implements ClusterOperatorStatusFluent.OAuthClientAuthorizationExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final OAuthClientAuthorizationBuilder builder;

            OAuthClientAuthorizationExtensionNestedImpl(OAuthClientAuthorization item) {
                this.builder = new OAuthClientAuthorizationBuilder(this, item);
                        
            }

            OAuthClientAuthorizationExtensionNestedImpl() {
                this.builder = new OAuthClientAuthorizationBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
            }

            public N endOAuthClientAuthorizationExtension() {
                return and();
            }
    }


    public class ClusterRoleExtensionNestedImpl<N> extends ClusterRoleFluentImpl<ClusterOperatorStatusFluent.ClusterRoleExtensionNested<N>> implements ClusterOperatorStatusFluent.ClusterRoleExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ClusterRoleBuilder builder;

            ClusterRoleExtensionNestedImpl(ClusterRole item) {
                this.builder = new ClusterRoleBuilder(this, item);
                        
            }

            ClusterRoleExtensionNestedImpl() {
                this.builder = new ClusterRoleBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
            }

            public N endClusterRoleExtension() {
                return and();
            }
    }


    public class ImageTagExtensionNestedImpl<N> extends ImageTagFluentImpl<ClusterOperatorStatusFluent.ImageTagExtensionNested<N>> implements ClusterOperatorStatusFluent.ImageTagExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ImageTagBuilder builder;

            ImageTagExtensionNestedImpl(ImageTag item) {
                this.builder = new ImageTagBuilder(this, item);
                        
            }

            ImageTagExtensionNestedImpl() {
                this.builder = new ImageTagBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
            }

            public N endImageTagExtension() {
                return and();
            }
    }


    public class DeploymentConfigExtensionNestedImpl<N> extends DeploymentConfigFluentImpl<ClusterOperatorStatusFluent.DeploymentConfigExtensionNested<N>> implements ClusterOperatorStatusFluent.DeploymentConfigExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final DeploymentConfigBuilder builder;

            DeploymentConfigExtensionNestedImpl(DeploymentConfig item) {
                this.builder = new DeploymentConfigBuilder(this, item);
                        
            }

            DeploymentConfigExtensionNestedImpl() {
                this.builder = new DeploymentConfigBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
            }

            public N endDeploymentConfigExtension() {
                return and();
            }
    }


    public class OAuthAccessTokenExtensionNestedImpl<N> extends OAuthAccessTokenFluentImpl<ClusterOperatorStatusFluent.OAuthAccessTokenExtensionNested<N>> implements ClusterOperatorStatusFluent.OAuthAccessTokenExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final OAuthAccessTokenBuilder builder;

            OAuthAccessTokenExtensionNestedImpl(OAuthAccessToken item) {
                this.builder = new OAuthAccessTokenBuilder(this, item);
                        
            }

            OAuthAccessTokenExtensionNestedImpl() {
                this.builder = new OAuthAccessTokenBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
            }

            public N endOAuthAccessTokenExtension() {
                return and();
            }
    }


    public class RoleBindingExtensionNestedImpl<N> extends RoleBindingFluentImpl<ClusterOperatorStatusFluent.RoleBindingExtensionNested<N>> implements ClusterOperatorStatusFluent.RoleBindingExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final RoleBindingBuilder builder;

            RoleBindingExtensionNestedImpl(RoleBinding item) {
                this.builder = new RoleBindingBuilder(this, item);
                        
            }

            RoleBindingExtensionNestedImpl() {
                this.builder = new RoleBindingBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
            }

            public N endRoleBindingExtension() {
                return and();
            }
    }


    public class ImageExtensionNestedImpl<N> extends ImageFluentImpl<ClusterOperatorStatusFluent.ImageExtensionNested<N>> implements ClusterOperatorStatusFluent.ImageExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ImageBuilder builder;

            ImageExtensionNestedImpl(Image item) {
                this.builder = new ImageBuilder(this, item);
                        
            }

            ImageExtensionNestedImpl() {
                this.builder = new ImageBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
            }

            public N endImageExtension() {
                return and();
            }
    }


    public class APIServerExtensionNestedImpl<N> extends APIServerFluentImpl<ClusterOperatorStatusFluent.APIServerExtensionNested<N>> implements ClusterOperatorStatusFluent.APIServerExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final APIServerBuilder builder;

            APIServerExtensionNestedImpl(APIServer item) {
                this.builder = new APIServerBuilder(this, item);
                        
            }

            APIServerExtensionNestedImpl() {
                this.builder = new APIServerBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
            }

            public N endAPIServerExtension() {
                return and();
            }
    }


    public class PersistentVolumeClaimExtensionNestedImpl<N> extends PersistentVolumeClaimFluentImpl<ClusterOperatorStatusFluent.PersistentVolumeClaimExtensionNested<N>> implements ClusterOperatorStatusFluent.PersistentVolumeClaimExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PersistentVolumeClaimBuilder builder;

            PersistentVolumeClaimExtensionNestedImpl(PersistentVolumeClaim item) {
                this.builder = new PersistentVolumeClaimBuilder(this, item);
                        
            }

            PersistentVolumeClaimExtensionNestedImpl() {
                this.builder = new PersistentVolumeClaimBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
            }

            public N endPersistentVolumeClaimExtension() {
                return and();
            }
    }


    public class ImageStreamMappingExtensionNestedImpl<N> extends ImageStreamMappingFluentImpl<ClusterOperatorStatusFluent.ImageStreamMappingExtensionNested<N>> implements ClusterOperatorStatusFluent.ImageStreamMappingExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ImageStreamMappingBuilder builder;

            ImageStreamMappingExtensionNestedImpl(ImageStreamMapping item) {
                this.builder = new ImageStreamMappingBuilder(this, item);
                        
            }

            ImageStreamMappingExtensionNestedImpl() {
                this.builder = new ImageStreamMappingBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
            }

            public N endImageStreamMappingExtension() {
                return and();
            }
    }


    public class RoleExtensionNestedImpl<N> extends RoleFluentImpl<ClusterOperatorStatusFluent.RoleExtensionNested<N>> implements ClusterOperatorStatusFluent.RoleExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final RoleBuilder builder;

            RoleExtensionNestedImpl(Role item) {
                this.builder = new RoleBuilder(this, item);
                        
            }

            RoleExtensionNestedImpl() {
                this.builder = new RoleBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
            }

            public N endRoleExtension() {
                return and();
            }
    }


    public class FeatureGateExtensionNestedImpl<N> extends FeatureGateFluentImpl<ClusterOperatorStatusFluent.FeatureGateExtensionNested<N>> implements ClusterOperatorStatusFluent.FeatureGateExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final FeatureGateBuilder builder;

            FeatureGateExtensionNestedImpl(FeatureGate item) {
                this.builder = new FeatureGateBuilder(this, item);
                        
            }

            FeatureGateExtensionNestedImpl() {
                this.builder = new FeatureGateBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
            }

            public N endFeatureGateExtension() {
                return and();
            }
    }


    public class UserExtensionNestedImpl<N> extends UserFluentImpl<ClusterOperatorStatusFluent.UserExtensionNested<N>> implements ClusterOperatorStatusFluent.UserExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final UserBuilder builder;

            UserExtensionNestedImpl(User item) {
                this.builder = new UserBuilder(this, item);
                        
            }

            UserExtensionNestedImpl() {
                this.builder = new UserBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
            }

            public N endUserExtension() {
                return and();
            }
    }


    public class ImageStreamImageExtensionNestedImpl<N> extends ImageStreamImageFluentImpl<ClusterOperatorStatusFluent.ImageStreamImageExtensionNested<N>> implements ClusterOperatorStatusFluent.ImageStreamImageExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ImageStreamImageBuilder builder;

            ImageStreamImageExtensionNestedImpl(ImageStreamImage item) {
                this.builder = new ImageStreamImageBuilder(this, item);
                        
            }

            ImageStreamImageExtensionNestedImpl() {
                this.builder = new ImageStreamImageBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
            }

            public N endImageStreamImageExtension() {
                return and();
            }
    }


    public class BuildExtensionNestedImpl<N> extends BuildFluentImpl<ClusterOperatorStatusFluent.BuildExtensionNested<N>> implements ClusterOperatorStatusFluent.BuildExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final BuildBuilder builder;

            BuildExtensionNestedImpl(Build item) {
                this.builder = new BuildBuilder(this, item);
                        
            }

            BuildExtensionNestedImpl() {
                this.builder = new BuildBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
            }

            public N endBuildExtension() {
                return and();
            }
    }


    public class RoleBindingRestrictionExtensionNestedImpl<N> extends RoleBindingRestrictionFluentImpl<ClusterOperatorStatusFluent.RoleBindingRestrictionExtensionNested<N>> implements ClusterOperatorStatusFluent.RoleBindingRestrictionExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final RoleBindingRestrictionBuilder builder;

            RoleBindingRestrictionExtensionNestedImpl(RoleBindingRestriction item) {
                this.builder = new RoleBindingRestrictionBuilder(this, item);
                        
            }

            RoleBindingRestrictionExtensionNestedImpl() {
                this.builder = new RoleBindingRestrictionBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
            }

            public N endRoleBindingRestrictionExtension() {
                return and();
            }
    }


    public class ImageStreamTagExtensionNestedImpl<N> extends ImageStreamTagFluentImpl<ClusterOperatorStatusFluent.ImageStreamTagExtensionNested<N>> implements ClusterOperatorStatusFluent.ImageStreamTagExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ImageStreamTagBuilder builder;

            ImageStreamTagExtensionNestedImpl(ImageStreamTag item) {
                this.builder = new ImageStreamTagBuilder(this, item);
                        
            }

            ImageStreamTagExtensionNestedImpl() {
                this.builder = new ImageStreamTagBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
            }

            public N endImageStreamTagExtension() {
                return and();
            }
    }


    public class GroupExtensionNestedImpl<N> extends GroupFluentImpl<ClusterOperatorStatusFluent.GroupExtensionNested<N>> implements ClusterOperatorStatusFluent.GroupExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final GroupBuilder builder;

            GroupExtensionNestedImpl(io.fabric8.openshift.api.model.Group item) {
                this.builder = new GroupBuilder(this, item);
                        
            }

            GroupExtensionNestedImpl() {
                this.builder = new GroupBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
            }

            public N endGroupExtension() {
                return and();
            }
    }


    public class ImageSignatureExtensionNestedImpl<N> extends ImageSignatureFluentImpl<ClusterOperatorStatusFluent.ImageSignatureExtensionNested<N>> implements ClusterOperatorStatusFluent.ImageSignatureExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ImageSignatureBuilder builder;

            ImageSignatureExtensionNestedImpl(ImageSignature item) {
                this.builder = new ImageSignatureBuilder(this, item);
                        
            }

            ImageSignatureExtensionNestedImpl() {
                this.builder = new ImageSignatureBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
            }

            public N endImageSignatureExtension() {
                return and();
            }
    }


    public class AppliedClusterResourceQuotaExtensionNestedImpl<N> extends AppliedClusterResourceQuotaFluentImpl<ClusterOperatorStatusFluent.AppliedClusterResourceQuotaExtensionNested<N>> implements ClusterOperatorStatusFluent.AppliedClusterResourceQuotaExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final AppliedClusterResourceQuotaBuilder builder;

            AppliedClusterResourceQuotaExtensionNestedImpl(AppliedClusterResourceQuota item) {
                this.builder = new AppliedClusterResourceQuotaBuilder(this, item);
                        
            }

            AppliedClusterResourceQuotaExtensionNestedImpl() {
                this.builder = new AppliedClusterResourceQuotaBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
            }

            public N endAppliedClusterResourceQuotaExtension() {
                return and();
            }
    }


    public class SecurityContextConstraintsExtensionNestedImpl<N> extends SecurityContextConstraintsFluentImpl<ClusterOperatorStatusFluent.SecurityContextConstraintsExtensionNested<N>> implements ClusterOperatorStatusFluent.SecurityContextConstraintsExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SecurityContextConstraintsBuilder builder;

            SecurityContextConstraintsExtensionNestedImpl(SecurityContextConstraints item) {
                this.builder = new SecurityContextConstraintsBuilder(this, item);
                        
            }

            SecurityContextConstraintsExtensionNestedImpl() {
                this.builder = new SecurityContextConstraintsBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
            }

            public N endSecurityContextConstraintsExtension() {
                return and();
            }
    }


    public class BuildRequestExtensionNestedImpl<N> extends BuildRequestFluentImpl<ClusterOperatorStatusFluent.BuildRequestExtensionNested<N>> implements ClusterOperatorStatusFluent.BuildRequestExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final BuildRequestBuilder builder;

            BuildRequestExtensionNestedImpl(BuildRequest item) {
                this.builder = new BuildRequestBuilder(this, item);
                        
            }

            BuildRequestExtensionNestedImpl() {
                this.builder = new BuildRequestBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
            }

            public N endBuildRequestExtension() {
                return and();
            }
    }


    public class NetNamespaceExtensionNestedImpl<N> extends NetNamespaceFluentImpl<ClusterOperatorStatusFluent.NetNamespaceExtensionNested<N>> implements ClusterOperatorStatusFluent.NetNamespaceExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final NetNamespaceBuilder builder;

            NetNamespaceExtensionNestedImpl(NetNamespace item) {
                this.builder = new NetNamespaceBuilder(this, item);
                        
            }

            NetNamespaceExtensionNestedImpl() {
                this.builder = new NetNamespaceBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
            }

            public N endNetNamespaceExtension() {
                return and();
            }
    }


    public class EgressNetworkPolicyExtensionNestedImpl<N> extends EgressNetworkPolicyFluentImpl<ClusterOperatorStatusFluent.EgressNetworkPolicyExtensionNested<N>> implements ClusterOperatorStatusFluent.EgressNetworkPolicyExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final EgressNetworkPolicyBuilder builder;

            EgressNetworkPolicyExtensionNestedImpl(EgressNetworkPolicy item) {
                this.builder = new EgressNetworkPolicyBuilder(this, item);
                        
            }

            EgressNetworkPolicyExtensionNestedImpl() {
                this.builder = new EgressNetworkPolicyBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
            }

            public N endEgressNetworkPolicyExtension() {
                return and();
            }
    }


    public class ImageStreamExtensionNestedImpl<N> extends ImageStreamFluentImpl<ClusterOperatorStatusFluent.ImageStreamExtensionNested<N>> implements ClusterOperatorStatusFluent.ImageStreamExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ImageStreamBuilder builder;

            ImageStreamExtensionNestedImpl(ImageStream item) {
                this.builder = new ImageStreamBuilder(this, item);
                        
            }

            ImageStreamExtensionNestedImpl() {
                this.builder = new ImageStreamBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
            }

            public N endImageStreamExtension() {
                return and();
            }
    }


    public class OAuthClientExtensionNestedImpl<N> extends OAuthClientFluentImpl<ClusterOperatorStatusFluent.OAuthClientExtensionNested<N>> implements ClusterOperatorStatusFluent.OAuthClientExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final OAuthClientBuilder builder;

            OAuthClientExtensionNestedImpl(OAuthClient item) {
                this.builder = new OAuthClientBuilder(this, item);
                        
            }

            OAuthClientExtensionNestedImpl() {
                this.builder = new OAuthClientBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
            }

            public N endOAuthClientExtension() {
                return and();
            }
    }


    public class IdentityExtensionNestedImpl<N> extends IdentityFluentImpl<ClusterOperatorStatusFluent.IdentityExtensionNested<N>> implements ClusterOperatorStatusFluent.IdentityExtensionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final IdentityBuilder builder;

            IdentityExtensionNestedImpl(Identity item) {
                this.builder = new IdentityBuilder(this, item);
                        
            }

            IdentityExtensionNestedImpl() {
                this.builder = new IdentityBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterOperatorStatusFluentImpl.this.withExtension(builder.build());
            }

            public N endIdentityExtension() {
                return and();
            }
    }


    public class RelatedObjectsNestedImpl<N> extends io.fabric8.openshift.api.model.ObjectReferenceFluentImpl<ClusterOperatorStatusFluent.RelatedObjectsNested<N>> implements ClusterOperatorStatusFluent.RelatedObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.ObjectReferenceBuilder builder;
        private final int index;

            RelatedObjectsNestedImpl(int index,io.fabric8.openshift.api.model.ObjectReference item) {
                this.index = index;
                this.builder = new io.fabric8.openshift.api.model.ObjectReferenceBuilder(this, item);
                        
            }

            RelatedObjectsNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.openshift.api.model.ObjectReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterOperatorStatusFluentImpl.this.setToRelatedObjects(index,builder.build());
            }

            public N endRelatedObject() {
                return and();
            }
    }


    public class VersionsNestedImpl<N> extends OperandVersionFluentImpl<ClusterOperatorStatusFluent.VersionsNested<N>> implements ClusterOperatorStatusFluent.VersionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final OperandVersionBuilder builder;
        private final int index;

            VersionsNestedImpl(int index,OperandVersion item) {
                this.index = index;
                this.builder = new OperandVersionBuilder(this, item);
                        
            }

            VersionsNestedImpl() {
                this.index = -1;
                this.builder = new OperandVersionBuilder(this);
                        
            }

            public N and() {
                return (N) ClusterOperatorStatusFluentImpl.this.setToVersions(index,builder.build());
            }

            public N endVersion() {
                return and();
            }
    }


}
