package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class VSpherePlatformStatusBuilder extends VSpherePlatformStatusFluentImpl<VSpherePlatformStatusBuilder> implements VisitableBuilder<VSpherePlatformStatus,VSpherePlatformStatusBuilder> {

    VSpherePlatformStatusFluent<?> fluent;
    Boolean validationEnabled;

    public VSpherePlatformStatusBuilder() {
        this(true);
    }

    public VSpherePlatformStatusBuilder(Boolean validationEnabled) {
        this(new VSpherePlatformStatus(), validationEnabled);
    }

    public VSpherePlatformStatusBuilder(VSpherePlatformStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public VSpherePlatformStatusBuilder(VSpherePlatformStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new VSpherePlatformStatus(), validationEnabled);
    }

    public VSpherePlatformStatusBuilder(VSpherePlatformStatusFluent<?> fluent,VSpherePlatformStatus instance) {
        this(fluent, instance, true);
    }

    public VSpherePlatformStatusBuilder(VSpherePlatformStatusFluent<?> fluent,VSpherePlatformStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiServerInternalIP(instance.getApiServerInternalIP()); 
        fluent.withIngressIP(instance.getIngressIP()); 
        fluent.withNodeDNSIP(instance.getNodeDNSIP()); 
        this.validationEnabled = validationEnabled; 
    }

    public VSpherePlatformStatusBuilder(VSpherePlatformStatus instance) {
        this(instance,true);
    }

    public VSpherePlatformStatusBuilder(VSpherePlatformStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiServerInternalIP(instance.getApiServerInternalIP()); 
        this.withIngressIP(instance.getIngressIP()); 
        this.withNodeDNSIP(instance.getNodeDNSIP()); 
        this.validationEnabled = validationEnabled; 
    }

    public VSpherePlatformStatus build() {
        VSpherePlatformStatus buildable = new VSpherePlatformStatus(fluent.getApiServerInternalIP(),fluent.getIngressIP(),fluent.getNodeDNSIP());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        VSpherePlatformStatusBuilder that = (VSpherePlatformStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
