package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface SchedulerSpecFluent<A extends SchedulerSpecFluent<A>> extends Fluent<A> {


    public String getDefaultNodeSelector();
    public A withDefaultNodeSelector(String defaultNodeSelector);
    public Boolean hasDefaultNodeSelector();
    public A withNewDefaultNodeSelector(String arg1);
    public A withNewDefaultNodeSelector(StringBuilder arg1);
    public A withNewDefaultNodeSelector(StringBuffer arg1);
    public Boolean isMastersSchedulable();
    public A withMastersSchedulable(Boolean mastersSchedulable);
    public Boolean hasMastersSchedulable();
    public A withNewMastersSchedulable(String arg1);
    public A withNewMastersSchedulable(boolean arg1);
    
/**
 * This method has been deprecated, please use method buildPolicy instead.
 * @return The buildable object.
 */
@Deprecated public ConfigMapNameReference getPolicy();
    public ConfigMapNameReference buildPolicy();
    public A withPolicy(ConfigMapNameReference policy);
    public Boolean hasPolicy();
    public A withNewPolicy(String name);
    public SchedulerSpecFluent.PolicyNested<A> withNewPolicy();
    public SchedulerSpecFluent.PolicyNested<A> withNewPolicyLike(ConfigMapNameReference item);
    public SchedulerSpecFluent.PolicyNested<A> editPolicy();
    public SchedulerSpecFluent.PolicyNested<A> editOrNewPolicy();
    public SchedulerSpecFluent.PolicyNested<A> editOrNewPolicyLike(ConfigMapNameReference item);
    public interface PolicyNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ConfigMapNameReferenceFluent<SchedulerSpecFluent.PolicyNested<N>> {

            public N and();
            public N endPolicy();    }


}
