
package io.fabric8.openshift.api.model;

import java.util.HashMap;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "attributes",
    "bindDN",
    "bindPassword",
    "ca",
    "insecure",
    "url"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = false, generateBuilderPackage = false, lazyCollectionInitEnabled = false, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class),
    @BuildableReference(LabelSelector.class),
    @BuildableReference(Container.class),
    @BuildableReference(PodTemplateSpec.class),
    @BuildableReference(ResourceRequirements.class),
    @BuildableReference(IntOrString.class),
    @BuildableReference(ObjectReference.class),
    @BuildableReference(LocalObjectReference.class),
    @BuildableReference(PersistentVolumeClaim.class)
})
public class LDAPIdentityProvider implements KubernetesResource
{

    @JsonProperty("attributes")
    private LDAPAttributeMapping attributes;
    @JsonProperty("bindDN")
    private String bindDN;
    @JsonProperty("bindPassword")
    private SecretNameReference bindPassword;
    @JsonProperty("ca")
    private ConfigMapNameReference ca;
    @JsonProperty("insecure")
    private Boolean insecure;
    @JsonProperty("url")
    private String url;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public LDAPIdentityProvider() {
    }

    /**
     * 
     * @param bindDN
     * @param bindPassword
     * @param insecure
     * @param attributes
     * @param ca
     * @param url
     */
    public LDAPIdentityProvider(LDAPAttributeMapping attributes, String bindDN, SecretNameReference bindPassword, ConfigMapNameReference ca, Boolean insecure, String url) {
        super();
        this.attributes = attributes;
        this.bindDN = bindDN;
        this.bindPassword = bindPassword;
        this.ca = ca;
        this.insecure = insecure;
        this.url = url;
    }

    @JsonProperty("attributes")
    public LDAPAttributeMapping getAttributes() {
        return attributes;
    }

    @JsonProperty("attributes")
    public void setAttributes(LDAPAttributeMapping attributes) {
        this.attributes = attributes;
    }

    @JsonProperty("bindDN")
    public String getBindDN() {
        return bindDN;
    }

    @JsonProperty("bindDN")
    public void setBindDN(String bindDN) {
        this.bindDN = bindDN;
    }

    @JsonProperty("bindPassword")
    public SecretNameReference getBindPassword() {
        return bindPassword;
    }

    @JsonProperty("bindPassword")
    public void setBindPassword(SecretNameReference bindPassword) {
        this.bindPassword = bindPassword;
    }

    @JsonProperty("ca")
    public ConfigMapNameReference getCa() {
        return ca;
    }

    @JsonProperty("ca")
    public void setCa(ConfigMapNameReference ca) {
        this.ca = ca;
    }

    @JsonProperty("insecure")
    public Boolean getInsecure() {
        return insecure;
    }

    @JsonProperty("insecure")
    public void setInsecure(Boolean insecure) {
        this.insecure = insecure;
    }

    @JsonProperty("url")
    public String getUrl() {
        return url;
    }

    @JsonProperty("url")
    public void setUrl(String url) {
        this.url = url;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
