package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IBMCloudPlatformStatusBuilder extends IBMCloudPlatformStatusFluentImpl<IBMCloudPlatformStatusBuilder> implements VisitableBuilder<IBMCloudPlatformStatus,IBMCloudPlatformStatusBuilder> {

    IBMCloudPlatformStatusFluent<?> fluent;
    Boolean validationEnabled;

    public IBMCloudPlatformStatusBuilder() {
        this(true);
    }

    public IBMCloudPlatformStatusBuilder(Boolean validationEnabled) {
        this(new IBMCloudPlatformStatus(), validationEnabled);
    }

    public IBMCloudPlatformStatusBuilder(IBMCloudPlatformStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public IBMCloudPlatformStatusBuilder(IBMCloudPlatformStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new IBMCloudPlatformStatus(), validationEnabled);
    }

    public IBMCloudPlatformStatusBuilder(IBMCloudPlatformStatusFluent<?> fluent,IBMCloudPlatformStatus instance) {
        this(fluent, instance, true);
    }

    public IBMCloudPlatformStatusBuilder(IBMCloudPlatformStatusFluent<?> fluent,IBMCloudPlatformStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withLocation(instance.getLocation()); 
        fluent.withProviderType(instance.getProviderType()); 
        fluent.withResourceGroupName(instance.getResourceGroupName()); 
        this.validationEnabled = validationEnabled; 
    }

    public IBMCloudPlatformStatusBuilder(IBMCloudPlatformStatus instance) {
        this(instance,true);
    }

    public IBMCloudPlatformStatusBuilder(IBMCloudPlatformStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withLocation(instance.getLocation()); 
        this.withProviderType(instance.getProviderType()); 
        this.withResourceGroupName(instance.getResourceGroupName()); 
        this.validationEnabled = validationEnabled; 
    }

    public IBMCloudPlatformStatus build() {
        IBMCloudPlatformStatus buildable = new IBMCloudPlatformStatus(fluent.getLocation(),fluent.getProviderType(),fluent.getResourceGroupName());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        IBMCloudPlatformStatusBuilder that = (IBMCloudPlatformStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
