package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PlatformSpecBuilder extends PlatformSpecFluentImpl<PlatformSpecBuilder> implements VisitableBuilder<PlatformSpec,PlatformSpecBuilder> {

    PlatformSpecFluent<?> fluent;
    Boolean validationEnabled;

    public PlatformSpecBuilder() {
        this(true);
    }

    public PlatformSpecBuilder(Boolean validationEnabled) {
        this(new PlatformSpec(), validationEnabled);
    }

    public PlatformSpecBuilder(PlatformSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public PlatformSpecBuilder(PlatformSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new PlatformSpec(), validationEnabled);
    }

    public PlatformSpecBuilder(PlatformSpecFluent<?> fluent,PlatformSpec instance) {
        this(fluent, instance, true);
    }

    public PlatformSpecBuilder(PlatformSpecFluent<?> fluent,PlatformSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAws(instance.getAws()); 
        fluent.withAzure(instance.getAzure()); 
        fluent.withBaremetal(instance.getBaremetal()); 
        fluent.withGcp(instance.getGcp()); 
        fluent.withIbmcloud(instance.getIbmcloud()); 
        fluent.withOpenstack(instance.getOpenstack()); 
        fluent.withOvirt(instance.getOvirt()); 
        fluent.withType(instance.getType()); 
        fluent.withVsphere(instance.getVsphere()); 
        this.validationEnabled = validationEnabled; 
    }

    public PlatformSpecBuilder(PlatformSpec instance) {
        this(instance,true);
    }

    public PlatformSpecBuilder(PlatformSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withAws(instance.getAws()); 
        this.withAzure(instance.getAzure()); 
        this.withBaremetal(instance.getBaremetal()); 
        this.withGcp(instance.getGcp()); 
        this.withIbmcloud(instance.getIbmcloud()); 
        this.withOpenstack(instance.getOpenstack()); 
        this.withOvirt(instance.getOvirt()); 
        this.withType(instance.getType()); 
        this.withVsphere(instance.getVsphere()); 
        this.validationEnabled = validationEnabled; 
    }

    public PlatformSpec build() {
        PlatformSpec buildable = new PlatformSpec(fluent.getAws(),fluent.getAzure(),fluent.getBaremetal(),fluent.getGcp(),fluent.getIbmcloud(),fluent.getOpenstack(),fluent.getOvirt(),fluent.getType(),fluent.getVsphere());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PlatformSpecBuilder that = (PlatformSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
