package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface OAuthAuthorizeTokenListFluent<A extends OAuthAuthorizeTokenListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,OAuthAuthorizeToken item);
    public A setToItems(int index,OAuthAuthorizeToken item);
    public A addToItems(OAuthAuthorizeToken... items);
    public A addAllToItems(Collection<OAuthAuthorizeToken> items);
    public A removeFromItems(OAuthAuthorizeToken... items);
    public A removeAllFromItems(Collection<OAuthAuthorizeToken> items);
    public A removeMatchingFromItems(Predicate<OAuthAuthorizeTokenBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<OAuthAuthorizeToken> getItems();
    public List<OAuthAuthorizeToken> buildItems();
    public OAuthAuthorizeToken buildItem(int index);
    public OAuthAuthorizeToken buildFirstItem();
    public OAuthAuthorizeToken buildLastItem();
    public OAuthAuthorizeToken buildMatchingItem(Predicate<OAuthAuthorizeTokenBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<OAuthAuthorizeTokenBuilder> predicate);
    public A withItems(List<OAuthAuthorizeToken> items);
    public A withItems(OAuthAuthorizeToken... items);
    public Boolean hasItems();
    public OAuthAuthorizeTokenListFluent.ItemsNested<A> addNewItem();
    public OAuthAuthorizeTokenListFluent.ItemsNested<A> addNewItemLike(OAuthAuthorizeToken item);
    public OAuthAuthorizeTokenListFluent.ItemsNested<A> setNewItemLike(int index,OAuthAuthorizeToken item);
    public OAuthAuthorizeTokenListFluent.ItemsNested<A> editItem(int index);
    public OAuthAuthorizeTokenListFluent.ItemsNested<A> editFirstItem();
    public OAuthAuthorizeTokenListFluent.ItemsNested<A> editLastItem();
    public OAuthAuthorizeTokenListFluent.ItemsNested<A> editMatchingItem(Predicate<OAuthAuthorizeTokenBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OAuthAuthorizeTokenFluent<OAuthAuthorizeTokenListFluent.ItemsNested<N>> {

            public N and();
            public N endItem();    }


}
