package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class HubSourceStatusBuilder extends HubSourceStatusFluentImpl<HubSourceStatusBuilder> implements VisitableBuilder<HubSourceStatus,HubSourceStatusBuilder> {

    HubSourceStatusFluent<?> fluent;
    Boolean validationEnabled;

    public HubSourceStatusBuilder() {
        this(true);
    }

    public HubSourceStatusBuilder(Boolean validationEnabled) {
        this(new HubSourceStatus(), validationEnabled);
    }

    public HubSourceStatusBuilder(HubSourceStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public HubSourceStatusBuilder(HubSourceStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new HubSourceStatus(), validationEnabled);
    }

    public HubSourceStatusBuilder(HubSourceStatusFluent<?> fluent,HubSourceStatus instance) {
        this(fluent, instance, true);
    }

    public HubSourceStatusBuilder(HubSourceStatusFluent<?> fluent,HubSourceStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withDisabled(instance.getDisabled()); 
        fluent.withMessage(instance.getMessage()); 
        fluent.withName(instance.getName()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public HubSourceStatusBuilder(HubSourceStatus instance) {
        this(instance,true);
    }

    public HubSourceStatusBuilder(HubSourceStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withDisabled(instance.getDisabled()); 
        this.withMessage(instance.getMessage()); 
        this.withName(instance.getName()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public HubSourceStatus build() {
        HubSourceStatus buildable = new HubSourceStatus(fluent.isDisabled(),fluent.getMessage(),fluent.getName(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        HubSourceStatusBuilder that = (HubSourceStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
