package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ClusterVersionStatusBuilder extends ClusterVersionStatusFluentImpl<ClusterVersionStatusBuilder> implements VisitableBuilder<ClusterVersionStatus,ClusterVersionStatusBuilder> {

    ClusterVersionStatusFluent<?> fluent;
    Boolean validationEnabled;

    public ClusterVersionStatusBuilder() {
        this(true);
    }

    public ClusterVersionStatusBuilder(Boolean validationEnabled) {
        this(new ClusterVersionStatus(), validationEnabled);
    }

    public ClusterVersionStatusBuilder(ClusterVersionStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public ClusterVersionStatusBuilder(ClusterVersionStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ClusterVersionStatus(), validationEnabled);
    }

    public ClusterVersionStatusBuilder(ClusterVersionStatusFluent<?> fluent,ClusterVersionStatus instance) {
        this(fluent, instance, true);
    }

    public ClusterVersionStatusBuilder(ClusterVersionStatusFluent<?> fluent,ClusterVersionStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAvailableUpdates(instance.getAvailableUpdates()); 
        fluent.withConditions(instance.getConditions()); 
        fluent.withDesired(instance.getDesired()); 
        fluent.withHistory(instance.getHistory()); 
        fluent.withObservedGeneration(instance.getObservedGeneration()); 
        fluent.withVersionHash(instance.getVersionHash()); 
        this.validationEnabled = validationEnabled; 
    }

    public ClusterVersionStatusBuilder(ClusterVersionStatus instance) {
        this(instance,true);
    }

    public ClusterVersionStatusBuilder(ClusterVersionStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withAvailableUpdates(instance.getAvailableUpdates()); 
        this.withConditions(instance.getConditions()); 
        this.withDesired(instance.getDesired()); 
        this.withHistory(instance.getHistory()); 
        this.withObservedGeneration(instance.getObservedGeneration()); 
        this.withVersionHash(instance.getVersionHash()); 
        this.validationEnabled = validationEnabled; 
    }

    public ClusterVersionStatus build() {
        ClusterVersionStatus buildable = new ClusterVersionStatus(fluent.getAvailableUpdates(),fluent.getConditions(),fluent.getDesired(),fluent.getHistory(),fluent.getObservedGeneration(),fluent.getVersionHash());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ClusterVersionStatusBuilder that = (ClusterVersionStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
