package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PodSecurityPolicyReviewStatusBuilder extends PodSecurityPolicyReviewStatusFluentImpl<PodSecurityPolicyReviewStatusBuilder> implements VisitableBuilder<PodSecurityPolicyReviewStatus,PodSecurityPolicyReviewStatusBuilder> {

    PodSecurityPolicyReviewStatusFluent<?> fluent;
    Boolean validationEnabled;

    public PodSecurityPolicyReviewStatusBuilder() {
        this(true);
    }

    public PodSecurityPolicyReviewStatusBuilder(Boolean validationEnabled) {
        this(new PodSecurityPolicyReviewStatus(), validationEnabled);
    }

    public PodSecurityPolicyReviewStatusBuilder(PodSecurityPolicyReviewStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public PodSecurityPolicyReviewStatusBuilder(PodSecurityPolicyReviewStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new PodSecurityPolicyReviewStatus(), validationEnabled);
    }

    public PodSecurityPolicyReviewStatusBuilder(PodSecurityPolicyReviewStatusFluent<?> fluent,PodSecurityPolicyReviewStatus instance) {
        this(fluent, instance, true);
    }

    public PodSecurityPolicyReviewStatusBuilder(PodSecurityPolicyReviewStatusFluent<?> fluent,PodSecurityPolicyReviewStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAllowedServiceAccounts(instance.getAllowedServiceAccounts()); 
        this.validationEnabled = validationEnabled; 
    }

    public PodSecurityPolicyReviewStatusBuilder(PodSecurityPolicyReviewStatus instance) {
        this(instance,true);
    }

    public PodSecurityPolicyReviewStatusBuilder(PodSecurityPolicyReviewStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withAllowedServiceAccounts(instance.getAllowedServiceAccounts()); 
        this.validationEnabled = validationEnabled; 
    }

    public PodSecurityPolicyReviewStatus build() {
        PodSecurityPolicyReviewStatus buildable = new PodSecurityPolicyReviewStatus(fluent.getAllowedServiceAccounts());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PodSecurityPolicyReviewStatusBuilder that = (PodSecurityPolicyReviewStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
