package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.Status;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class ImageImportStatusFluentImpl<A extends ImageImportStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ImageImportStatusFluent<A> {

    private ImageBuilder image;
    private Status status;
    private String tag;

    public ImageImportStatusFluentImpl() {
    }

    public ImageImportStatusFluentImpl(ImageImportStatus instance) {
        this.withImage(instance.getImage()); 
        this.withStatus(instance.getStatus()); 
        this.withTag(instance.getTag()); 
    }

    
/**
 * This method has been deprecated, please use method buildImage instead.
 * @return The buildable object.
 */
@Deprecated public Image getImage() {
        return this.image!=null?this.image.build():null;
    }

    public Image buildImage() {
        return this.image!=null?this.image.build():null;
    }

    public A withImage(Image image) {
        _visitables.get("image").remove(this.image);
        if (image!=null){ this.image= new ImageBuilder(image); _visitables.get("image").add(this.image);} return (A) this;
    }

    public Boolean hasImage() {
        return this.image != null;
    }

    public ImageImportStatusFluent.ImageNested<A> withNewImage() {
        return new ImageNestedImpl();
    }

    public ImageImportStatusFluent.ImageNested<A> withNewImageLike(Image item) {
        return new ImageNestedImpl(item);
    }

    public ImageImportStatusFluent.ImageNested<A> editImage() {
        return withNewImageLike(getImage());
    }

    public ImageImportStatusFluent.ImageNested<A> editOrNewImage() {
        return withNewImageLike(getImage() != null ? getImage(): new ImageBuilder().build());
    }

    public ImageImportStatusFluent.ImageNested<A> editOrNewImageLike(Image item) {
        return withNewImageLike(getImage() != null ? getImage(): item);
    }

    public Status getStatus() {
        return this.status;
    }

    public A withStatus(Status status) {
        this.status=status; return (A) this;
    }

    public Boolean hasStatus() {
        return this.status != null;
    }

    public String getTag() {
        return this.tag;
    }

    public A withTag(String tag) {
        this.tag=tag; return (A) this;
    }

    public Boolean hasTag() {
        return this.tag != null;
    }

    public A withNewTag(String arg1) {
        return (A)withTag(new String(arg1));
    }

    public A withNewTag(StringBuilder arg1) {
        return (A)withTag(new String(arg1));
    }

    public A withNewTag(StringBuffer arg1) {
        return (A)withTag(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ImageImportStatusFluentImpl that = (ImageImportStatusFluentImpl) o;
        if (image != null ? !image.equals(that.image) :that.image != null) return false;
        if (status != null ? !status.equals(that.status) :that.status != null) return false;
        if (tag != null ? !tag.equals(that.tag) :that.tag != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(image,  status,  tag,  super.hashCode());
    }

    public class ImageNestedImpl<N> extends ImageFluentImpl<ImageImportStatusFluent.ImageNested<N>> implements ImageImportStatusFluent.ImageNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ImageBuilder builder;

            ImageNestedImpl(Image item) {
                this.builder = new ImageBuilder(this, item);
                        
            }

            ImageNestedImpl() {
                this.builder = new ImageBuilder(this);
                        
            }

            public N and() {
                return (N) ImageImportStatusFluentImpl.this.withImage(builder.build());
            }

            public N endImage() {
                return and();
            }
    }


}
