package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ClusterVersionBuilder extends ClusterVersionFluentImpl<ClusterVersionBuilder> implements VisitableBuilder<ClusterVersion,ClusterVersionBuilder> {

    ClusterVersionFluent<?> fluent;
    Boolean validationEnabled;

    public ClusterVersionBuilder() {
        this(true);
    }

    public ClusterVersionBuilder(Boolean validationEnabled) {
        this(new ClusterVersion(), validationEnabled);
    }

    public ClusterVersionBuilder(ClusterVersionFluent<?> fluent) {
        this(fluent, true);
    }

    public ClusterVersionBuilder(ClusterVersionFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ClusterVersion(), validationEnabled);
    }

    public ClusterVersionBuilder(ClusterVersionFluent<?> fluent,ClusterVersion instance) {
        this(fluent, instance, true);
    }

    public ClusterVersionBuilder(ClusterVersionFluent<?> fluent,ClusterVersion instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public ClusterVersionBuilder(ClusterVersion instance) {
        this(instance,true);
    }

    public ClusterVersionBuilder(ClusterVersion instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public ClusterVersion build() {
        ClusterVersion buildable = new ClusterVersion(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ClusterVersionBuilder that = (ClusterVersionBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
