package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ClusterResourceQuotaListBuilder extends ClusterResourceQuotaListFluentImpl<ClusterResourceQuotaListBuilder> implements VisitableBuilder<ClusterResourceQuotaList,ClusterResourceQuotaListBuilder> {

    ClusterResourceQuotaListFluent<?> fluent;
    Boolean validationEnabled;

    public ClusterResourceQuotaListBuilder() {
        this(true);
    }

    public ClusterResourceQuotaListBuilder(Boolean validationEnabled) {
        this(new ClusterResourceQuotaList(), validationEnabled);
    }

    public ClusterResourceQuotaListBuilder(ClusterResourceQuotaListFluent<?> fluent) {
        this(fluent, true);
    }

    public ClusterResourceQuotaListBuilder(ClusterResourceQuotaListFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ClusterResourceQuotaList(), validationEnabled);
    }

    public ClusterResourceQuotaListBuilder(ClusterResourceQuotaListFluent<?> fluent,ClusterResourceQuotaList instance) {
        this(fluent, instance, true);
    }

    public ClusterResourceQuotaListBuilder(ClusterResourceQuotaListFluent<?> fluent,ClusterResourceQuotaList instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public ClusterResourceQuotaListBuilder(ClusterResourceQuotaList instance) {
        this(instance,true);
    }

    public ClusterResourceQuotaListBuilder(ClusterResourceQuotaList instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public ClusterResourceQuotaList build() {
        ClusterResourceQuotaList buildable = new ClusterResourceQuotaList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ClusterResourceQuotaListBuilder that = (ClusterResourceQuotaListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
