package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface SubjectRulesReviewSpecFluent<A extends SubjectRulesReviewSpecFluent<A>> extends Fluent<A> {


    public A addToGroups(int index,String item);
    public A setToGroups(int index,String item);
    public A addToGroups(String... items);
    public A addAllToGroups(Collection<String> items);
    public A removeFromGroups(String... items);
    public A removeAllFromGroups(Collection<String> items);
    public List<String> getGroups();
    public String getGroup(int index);
    public String getFirstGroup();
    public String getLastGroup();
    public String getMatchingGroup(Predicate<String> predicate);
    public Boolean hasMatchingGroup(Predicate<String> predicate);
    public A withGroups(List<String> groups);
    public A withGroups(String... groups);
    public Boolean hasGroups();
    public A addNewGroup(String arg1);
    public A addNewGroup(StringBuilder arg1);
    public A addNewGroup(StringBuffer arg1);
    public A addToScopes(int index,String item);
    public A setToScopes(int index,String item);
    public A addToScopes(String... items);
    public A addAllToScopes(Collection<String> items);
    public A removeFromScopes(String... items);
    public A removeAllFromScopes(Collection<String> items);
    public List<String> getScopes();
    public String getScope(int index);
    public String getFirstScope();
    public String getLastScope();
    public String getMatchingScope(Predicate<String> predicate);
    public Boolean hasMatchingScope(Predicate<String> predicate);
    public A withScopes(List<String> scopes);
    public A withScopes(String... scopes);
    public Boolean hasScopes();
    public A addNewScope(String arg1);
    public A addNewScope(StringBuilder arg1);
    public A addNewScope(StringBuffer arg1);
    public String getUser();
    public A withUser(String user);
    public Boolean hasUser();
    public A withNewUser(String arg1);
    public A withNewUser(StringBuilder arg1);
    public A withNewUser(StringBuffer arg1);
}
