package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SchedulerStatusBuilder extends SchedulerStatusFluentImpl<SchedulerStatusBuilder> implements VisitableBuilder<SchedulerStatus,SchedulerStatusBuilder> {

    SchedulerStatusFluent<?> fluent;
    Boolean validationEnabled;

    public SchedulerStatusBuilder() {
        this(true);
    }

    public SchedulerStatusBuilder(Boolean validationEnabled) {
        this(new SchedulerStatus(), validationEnabled);
    }

    public SchedulerStatusBuilder(SchedulerStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public SchedulerStatusBuilder(SchedulerStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new SchedulerStatus(), validationEnabled);
    }

    public SchedulerStatusBuilder(SchedulerStatusFluent<?> fluent,SchedulerStatus instance) {
        this(fluent, instance, true);
    }

    public SchedulerStatusBuilder(SchedulerStatusFluent<?> fluent,SchedulerStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        this.validationEnabled = validationEnabled; 
    }

    public SchedulerStatusBuilder(SchedulerStatus instance) {
        this(instance,true);
    }

    public SchedulerStatusBuilder(SchedulerStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.validationEnabled = validationEnabled; 
    }

    public SchedulerStatus build() {
        SchedulerStatus buildable = new SchedulerStatus();
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        SchedulerStatusBuilder that = (SchedulerStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
