package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class InfrastructureSpecFluentImpl<A extends InfrastructureSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements InfrastructureSpecFluent<A> {

    private ConfigMapFileReferenceBuilder cloudConfig;
    private PlatformSpecBuilder platformSpec;

    public InfrastructureSpecFluentImpl() {
    }

    public InfrastructureSpecFluentImpl(InfrastructureSpec instance) {
        this.withCloudConfig(instance.getCloudConfig()); 
        this.withPlatformSpec(instance.getPlatformSpec()); 
    }

    
/**
 * This method has been deprecated, please use method buildCloudConfig instead.
 * @return The buildable object.
 */
@Deprecated public ConfigMapFileReference getCloudConfig() {
        return this.cloudConfig!=null?this.cloudConfig.build():null;
    }

    public ConfigMapFileReference buildCloudConfig() {
        return this.cloudConfig!=null?this.cloudConfig.build():null;
    }

    public A withCloudConfig(ConfigMapFileReference cloudConfig) {
        _visitables.get("cloudConfig").remove(this.cloudConfig);
        if (cloudConfig!=null){ this.cloudConfig= new ConfigMapFileReferenceBuilder(cloudConfig); _visitables.get("cloudConfig").add(this.cloudConfig);} return (A) this;
    }

    public Boolean hasCloudConfig() {
        return this.cloudConfig != null;
    }

    public A withNewCloudConfig(String key,String name) {
        return (A)withCloudConfig(new ConfigMapFileReference(key, name));
    }

    public InfrastructureSpecFluent.CloudConfigNested<A> withNewCloudConfig() {
        return new CloudConfigNestedImpl();
    }

    public InfrastructureSpecFluent.CloudConfigNested<A> withNewCloudConfigLike(ConfigMapFileReference item) {
        return new CloudConfigNestedImpl(item);
    }

    public InfrastructureSpecFluent.CloudConfigNested<A> editCloudConfig() {
        return withNewCloudConfigLike(getCloudConfig());
    }

    public InfrastructureSpecFluent.CloudConfigNested<A> editOrNewCloudConfig() {
        return withNewCloudConfigLike(getCloudConfig() != null ? getCloudConfig(): new ConfigMapFileReferenceBuilder().build());
    }

    public InfrastructureSpecFluent.CloudConfigNested<A> editOrNewCloudConfigLike(ConfigMapFileReference item) {
        return withNewCloudConfigLike(getCloudConfig() != null ? getCloudConfig(): item);
    }

    
/**
 * This method has been deprecated, please use method buildPlatformSpec instead.
 * @return The buildable object.
 */
@Deprecated public PlatformSpec getPlatformSpec() {
        return this.platformSpec!=null?this.platformSpec.build():null;
    }

    public PlatformSpec buildPlatformSpec() {
        return this.platformSpec!=null?this.platformSpec.build():null;
    }

    public A withPlatformSpec(PlatformSpec platformSpec) {
        _visitables.get("platformSpec").remove(this.platformSpec);
        if (platformSpec!=null){ this.platformSpec= new PlatformSpecBuilder(platformSpec); _visitables.get("platformSpec").add(this.platformSpec);} return (A) this;
    }

    public Boolean hasPlatformSpec() {
        return this.platformSpec != null;
    }

    public InfrastructureSpecFluent.PlatformSpecNested<A> withNewPlatformSpec() {
        return new PlatformSpecNestedImpl();
    }

    public InfrastructureSpecFluent.PlatformSpecNested<A> withNewPlatformSpecLike(PlatformSpec item) {
        return new PlatformSpecNestedImpl(item);
    }

    public InfrastructureSpecFluent.PlatformSpecNested<A> editPlatformSpec() {
        return withNewPlatformSpecLike(getPlatformSpec());
    }

    public InfrastructureSpecFluent.PlatformSpecNested<A> editOrNewPlatformSpec() {
        return withNewPlatformSpecLike(getPlatformSpec() != null ? getPlatformSpec(): new PlatformSpecBuilder().build());
    }

    public InfrastructureSpecFluent.PlatformSpecNested<A> editOrNewPlatformSpecLike(PlatformSpec item) {
        return withNewPlatformSpecLike(getPlatformSpec() != null ? getPlatformSpec(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        InfrastructureSpecFluentImpl that = (InfrastructureSpecFluentImpl) o;
        if (cloudConfig != null ? !cloudConfig.equals(that.cloudConfig) :that.cloudConfig != null) return false;
        if (platformSpec != null ? !platformSpec.equals(that.platformSpec) :that.platformSpec != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(cloudConfig,  platformSpec,  super.hashCode());
    }

    public class CloudConfigNestedImpl<N> extends ConfigMapFileReferenceFluentImpl<InfrastructureSpecFluent.CloudConfigNested<N>> implements InfrastructureSpecFluent.CloudConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ConfigMapFileReferenceBuilder builder;

            CloudConfigNestedImpl(ConfigMapFileReference item) {
                this.builder = new ConfigMapFileReferenceBuilder(this, item);
                        
            }

            CloudConfigNestedImpl() {
                this.builder = new ConfigMapFileReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) InfrastructureSpecFluentImpl.this.withCloudConfig(builder.build());
            }

            public N endCloudConfig() {
                return and();
            }
    }


    public class PlatformSpecNestedImpl<N> extends PlatformSpecFluentImpl<InfrastructureSpecFluent.PlatformSpecNested<N>> implements InfrastructureSpecFluent.PlatformSpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PlatformSpecBuilder builder;

            PlatformSpecNestedImpl(PlatformSpec item) {
                this.builder = new PlatformSpecBuilder(this, item);
                        
            }

            PlatformSpecNestedImpl() {
                this.builder = new PlatformSpecBuilder(this);
                        
            }

            public N and() {
                return (N) InfrastructureSpecFluentImpl.this.withPlatformSpec(builder.build());
            }

            public N endPlatformSpec() {
                return and();
            }
    }


}
