package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.Collection;
import java.lang.Object;

public class DockerBuildStrategyFluentImpl<A extends DockerBuildStrategyFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements DockerBuildStrategyFluent<A> {

    private List<EnvVar> buildArgs = new ArrayList<EnvVar>();
    private String dockerfilePath;
    private List<EnvVar> env = new ArrayList<EnvVar>();
    private Boolean forcePull;
    private io.fabric8.kubernetes.api.model.ObjectReferenceBuilder from;
    private String imageOptimizationPolicy;
    private Boolean noCache;
    private LocalObjectReferenceBuilder pullSecret;

    public DockerBuildStrategyFluentImpl() {
    }

    public DockerBuildStrategyFluentImpl(DockerBuildStrategy instance) {
        this.withBuildArgs(instance.getBuildArgs()); 
        this.withDockerfilePath(instance.getDockerfilePath()); 
        this.withEnv(instance.getEnv()); 
        this.withForcePull(instance.getForcePull()); 
        this.withFrom(instance.getFrom()); 
        this.withImageOptimizationPolicy(instance.getImageOptimizationPolicy()); 
        this.withNoCache(instance.getNoCache()); 
        this.withPullSecret(instance.getPullSecret()); 
    }

    public A addToBuildArgs(int index,EnvVar item) {
        if (this.buildArgs == null) {this.buildArgs = new ArrayList<EnvVar>();}
        this.buildArgs.add(index, item);
        return (A)this;
    }

    public A setToBuildArgs(int index,EnvVar item) {
        if (this.buildArgs == null) {this.buildArgs = new ArrayList<EnvVar>();}
        this.buildArgs.set(index, item); return (A)this;
    }

    public A addToBuildArgs(EnvVar... items) {
        if (this.buildArgs == null) {this.buildArgs = new ArrayList<EnvVar>();}
        for (EnvVar item : items) {this.buildArgs.add(item);} return (A)this;
    }

    public A addAllToBuildArgs(Collection<EnvVar> items) {
        if (this.buildArgs == null) {this.buildArgs = new ArrayList<EnvVar>();}
        for (EnvVar item : items) {this.buildArgs.add(item);} return (A)this;
    }

    public A removeFromBuildArgs(EnvVar... items) {
        for (EnvVar item : items) {if (this.buildArgs!= null){ this.buildArgs.remove(item);}} return (A)this;
    }

    public A removeAllFromBuildArgs(Collection<EnvVar> items) {
        for (EnvVar item : items) {if (this.buildArgs!= null){ this.buildArgs.remove(item);}} return (A)this;
    }

    public List<EnvVar> getBuildArgs() {
        return this.buildArgs;
    }

    public EnvVar getBuildArg(int index) {
        return this.buildArgs.get(index);
    }

    public EnvVar getFirstBuildArg() {
        return this.buildArgs.get(0);
    }

    public EnvVar getLastBuildArg() {
        return this.buildArgs.get(buildArgs.size() - 1);
    }

    public EnvVar getMatchingBuildArg(Predicate<EnvVar> predicate) {
        for (EnvVar item: buildArgs) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingBuildArg(Predicate<EnvVar> predicate) {
        for (EnvVar item: buildArgs) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withBuildArgs(List<EnvVar> buildArgs) {
        if (this.buildArgs != null) { _visitables.get("buildArgs").removeAll(this.buildArgs);}
        if (buildArgs != null) {this.buildArgs = new ArrayList<EnvVar>(); for (EnvVar item : buildArgs){this.addToBuildArgs(item);}} else { this.buildArgs = null;} return (A) this;
    }

    public A withBuildArgs(EnvVar... buildArgs) {
        if (this.buildArgs != null) {this.buildArgs.clear();}
        if (buildArgs != null) {for (EnvVar item :buildArgs){ this.addToBuildArgs(item);}} return (A) this;
    }

    public Boolean hasBuildArgs() {
        return buildArgs != null && !buildArgs.isEmpty();
    }

    public String getDockerfilePath() {
        return this.dockerfilePath;
    }

    public A withDockerfilePath(String dockerfilePath) {
        this.dockerfilePath=dockerfilePath; return (A) this;
    }

    public Boolean hasDockerfilePath() {
        return this.dockerfilePath != null;
    }

    public A withNewDockerfilePath(String arg1) {
        return (A)withDockerfilePath(new String(arg1));
    }

    public A withNewDockerfilePath(StringBuilder arg1) {
        return (A)withDockerfilePath(new String(arg1));
    }

    public A withNewDockerfilePath(StringBuffer arg1) {
        return (A)withDockerfilePath(new String(arg1));
    }

    public A addToEnv(int index,EnvVar item) {
        if (this.env == null) {this.env = new ArrayList<EnvVar>();}
        this.env.add(index, item);
        return (A)this;
    }

    public A setToEnv(int index,EnvVar item) {
        if (this.env == null) {this.env = new ArrayList<EnvVar>();}
        this.env.set(index, item); return (A)this;
    }

    public A addToEnv(EnvVar... items) {
        if (this.env == null) {this.env = new ArrayList<EnvVar>();}
        for (EnvVar item : items) {this.env.add(item);} return (A)this;
    }

    public A addAllToEnv(Collection<EnvVar> items) {
        if (this.env == null) {this.env = new ArrayList<EnvVar>();}
        for (EnvVar item : items) {this.env.add(item);} return (A)this;
    }

    public A removeFromEnv(EnvVar... items) {
        for (EnvVar item : items) {if (this.env!= null){ this.env.remove(item);}} return (A)this;
    }

    public A removeAllFromEnv(Collection<EnvVar> items) {
        for (EnvVar item : items) {if (this.env!= null){ this.env.remove(item);}} return (A)this;
    }

    public List<EnvVar> getEnv() {
        return this.env;
    }

    public EnvVar getEnv(int index) {
        return this.env.get(index);
    }

    public EnvVar getFirstEnv() {
        return this.env.get(0);
    }

    public EnvVar getLastEnv() {
        return this.env.get(env.size() - 1);
    }

    public EnvVar getMatchingEnv(Predicate<EnvVar> predicate) {
        for (EnvVar item: env) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingEnv(Predicate<EnvVar> predicate) {
        for (EnvVar item: env) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withEnv(List<EnvVar> env) {
        if (this.env != null) { _visitables.get("env").removeAll(this.env);}
        if (env != null) {this.env = new ArrayList<EnvVar>(); for (EnvVar item : env){this.addToEnv(item);}} else { this.env = null;} return (A) this;
    }

    public A withEnv(EnvVar... env) {
        if (this.env != null) {this.env.clear();}
        if (env != null) {for (EnvVar item :env){ this.addToEnv(item);}} return (A) this;
    }

    public Boolean hasEnv() {
        return env != null && !env.isEmpty();
    }

    public Boolean isForcePull() {
        return this.forcePull;
    }

    public A withForcePull(Boolean forcePull) {
        this.forcePull=forcePull; return (A) this;
    }

    public Boolean hasForcePull() {
        return this.forcePull != null;
    }

    public A withNewForcePull(String arg1) {
        return (A)withForcePull(new Boolean(arg1));
    }

    public A withNewForcePull(boolean arg1) {
        return (A)withForcePull(new Boolean(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildFrom instead.
 * @return The buildable object.
 */
@Deprecated public io.fabric8.kubernetes.api.model.ObjectReference getFrom() {
        return this.from!=null?this.from.build():null;
    }

    public io.fabric8.kubernetes.api.model.ObjectReference buildFrom() {
        return this.from!=null?this.from.build():null;
    }

    public A withFrom(io.fabric8.kubernetes.api.model.ObjectReference from) {
        _visitables.get("from").remove(this.from);
        if (from!=null){ this.from= new ObjectReferenceBuilder(from); _visitables.get("from").add(this.from);} return (A) this;
    }

    public Boolean hasFrom() {
        return this.from != null;
    }

    public DockerBuildStrategyFluent.FromNested<A> withNewFrom() {
        return new FromNestedImpl();
    }

    public DockerBuildStrategyFluent.FromNested<A> withNewFromLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
        return new FromNestedImpl(item);
    }

    public DockerBuildStrategyFluent.FromNested<A> editFrom() {
        return withNewFromLike(getFrom());
    }

    public DockerBuildStrategyFluent.FromNested<A> editOrNewFrom() {
        return withNewFromLike(getFrom() != null ? getFrom(): new ObjectReferenceBuilder().build());
    }

    public DockerBuildStrategyFluent.FromNested<A> editOrNewFromLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
        return withNewFromLike(getFrom() != null ? getFrom(): item);
    }

    public String getImageOptimizationPolicy() {
        return this.imageOptimizationPolicy;
    }

    public A withImageOptimizationPolicy(String imageOptimizationPolicy) {
        this.imageOptimizationPolicy=imageOptimizationPolicy; return (A) this;
    }

    public Boolean hasImageOptimizationPolicy() {
        return this.imageOptimizationPolicy != null;
    }

    public A withNewImageOptimizationPolicy(String arg1) {
        return (A)withImageOptimizationPolicy(new String(arg1));
    }

    public A withNewImageOptimizationPolicy(StringBuilder arg1) {
        return (A)withImageOptimizationPolicy(new String(arg1));
    }

    public A withNewImageOptimizationPolicy(StringBuffer arg1) {
        return (A)withImageOptimizationPolicy(new String(arg1));
    }

    public Boolean isNoCache() {
        return this.noCache;
    }

    public A withNoCache(Boolean noCache) {
        this.noCache=noCache; return (A) this;
    }

    public Boolean hasNoCache() {
        return this.noCache != null;
    }

    public A withNewNoCache(String arg1) {
        return (A)withNoCache(new Boolean(arg1));
    }

    public A withNewNoCache(boolean arg1) {
        return (A)withNoCache(new Boolean(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildPullSecret instead.
 * @return The buildable object.
 */
@Deprecated public LocalObjectReference getPullSecret() {
        return this.pullSecret!=null?this.pullSecret.build():null;
    }

    public LocalObjectReference buildPullSecret() {
        return this.pullSecret!=null?this.pullSecret.build():null;
    }

    public A withPullSecret(LocalObjectReference pullSecret) {
        _visitables.get("pullSecret").remove(this.pullSecret);
        if (pullSecret!=null){ this.pullSecret= new LocalObjectReferenceBuilder(pullSecret); _visitables.get("pullSecret").add(this.pullSecret);} return (A) this;
    }

    public Boolean hasPullSecret() {
        return this.pullSecret != null;
    }

    public A withNewPullSecret(String name) {
        return (A)withPullSecret(new LocalObjectReference(name));
    }

    public DockerBuildStrategyFluent.PullSecretNested<A> withNewPullSecret() {
        return new PullSecretNestedImpl();
    }

    public DockerBuildStrategyFluent.PullSecretNested<A> withNewPullSecretLike(LocalObjectReference item) {
        return new PullSecretNestedImpl(item);
    }

    public DockerBuildStrategyFluent.PullSecretNested<A> editPullSecret() {
        return withNewPullSecretLike(getPullSecret());
    }

    public DockerBuildStrategyFluent.PullSecretNested<A> editOrNewPullSecret() {
        return withNewPullSecretLike(getPullSecret() != null ? getPullSecret(): new LocalObjectReferenceBuilder().build());
    }

    public DockerBuildStrategyFluent.PullSecretNested<A> editOrNewPullSecretLike(LocalObjectReference item) {
        return withNewPullSecretLike(getPullSecret() != null ? getPullSecret(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DockerBuildStrategyFluentImpl that = (DockerBuildStrategyFluentImpl) o;
        if (buildArgs != null ? !buildArgs.equals(that.buildArgs) :that.buildArgs != null) return false;
        if (dockerfilePath != null ? !dockerfilePath.equals(that.dockerfilePath) :that.dockerfilePath != null) return false;
        if (env != null ? !env.equals(that.env) :that.env != null) return false;
        if (forcePull != null ? !forcePull.equals(that.forcePull) :that.forcePull != null) return false;
        if (from != null ? !from.equals(that.from) :that.from != null) return false;
        if (imageOptimizationPolicy != null ? !imageOptimizationPolicy.equals(that.imageOptimizationPolicy) :that.imageOptimizationPolicy != null) return false;
        if (noCache != null ? !noCache.equals(that.noCache) :that.noCache != null) return false;
        if (pullSecret != null ? !pullSecret.equals(that.pullSecret) :that.pullSecret != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(buildArgs,  dockerfilePath,  env,  forcePull,  from,  imageOptimizationPolicy,  noCache,  pullSecret,  super.hashCode());
    }

    public class FromNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl<DockerBuildStrategyFluent.FromNested<N>> implements DockerBuildStrategyFluent.FromNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.ObjectReferenceBuilder builder;

            FromNestedImpl(io.fabric8.kubernetes.api.model.ObjectReference item) {
                this.builder = new ObjectReferenceBuilder(this, item);
                        
            }

            FromNestedImpl() {
                this.builder = new ObjectReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) DockerBuildStrategyFluentImpl.this.withFrom(builder.build());
            }

            public N endFrom() {
                return and();
            }
    }


    public class PullSecretNestedImpl<N> extends LocalObjectReferenceFluentImpl<DockerBuildStrategyFluent.PullSecretNested<N>> implements DockerBuildStrategyFluent.PullSecretNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final LocalObjectReferenceBuilder builder;

            PullSecretNestedImpl(LocalObjectReference item) {
                this.builder = new LocalObjectReferenceBuilder(this, item);
                        
            }

            PullSecretNestedImpl() {
                this.builder = new LocalObjectReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) DockerBuildStrategyFluentImpl.this.withPullSecret(builder.build());
            }

            public N endPullSecret() {
                return and();
            }
    }


}
