package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.lang.Deprecated;
import java.lang.StringBuffer;
import java.util.function.Predicate;
import java.util.List;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.Collection;
import io.fabric8.kubernetes.api.builder.Nested;

public interface PolicyRuleFluent<A extends PolicyRuleFluent<A>> extends Fluent<A> {


    public A addToApiGroups(int index,String item);
    public A setToApiGroups(int index,String item);
    public A addToApiGroups(String... items);
    public A addAllToApiGroups(Collection<String> items);
    public A removeFromApiGroups(String... items);
    public A removeAllFromApiGroups(Collection<String> items);
    public List<String> getApiGroups();
    public String getApiGroup(int index);
    public String getFirstApiGroup();
    public String getLastApiGroup();
    public String getMatchingApiGroup(Predicate<String> predicate);
    public Boolean hasMatchingApiGroup(Predicate<String> predicate);
    public A withApiGroups(List<String> apiGroups);
    public A withApiGroups(String... apiGroups);
    public Boolean hasApiGroups();
    public A addNewApiGroup(String arg1);
    public A addNewApiGroup(StringBuilder arg1);
    public A addNewApiGroup(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildAttributeRestrictions instead.
 * @return The buildable object.
 */
@Deprecated public HasMetadata getAttributeRestrictions();
    public HasMetadata buildAttributeRestrictions();
    public A withAttributeRestrictions(HasMetadata attributeRestrictions);
    public Boolean hasAttributeRestrictions();
    public A withClusterVersionAttributeRestrictions(ClusterVersion clusterVersionAttributeRestrictions);
    public PolicyRuleFluent.ClusterVersionAttributeRestrictionsNested<A> withNewClusterVersionAttributeRestrictions();
    public PolicyRuleFluent.ClusterVersionAttributeRestrictionsNested<A> withNewClusterVersionAttributeRestrictionsLike(ClusterVersion item);
    public A withImageStreamImportAttributeRestrictions(ImageStreamImport imageStreamImportAttributeRestrictions);
    public PolicyRuleFluent.ImageStreamImportAttributeRestrictionsNested<A> withNewImageStreamImportAttributeRestrictions();
    public PolicyRuleFluent.ImageStreamImportAttributeRestrictionsNested<A> withNewImageStreamImportAttributeRestrictionsLike(ImageStreamImport item);
    public A withProxyAttributeRestrictions(Proxy proxyAttributeRestrictions);
    public PolicyRuleFluent.ProxyAttributeRestrictionsNested<A> withNewProxyAttributeRestrictions();
    public PolicyRuleFluent.ProxyAttributeRestrictionsNested<A> withNewProxyAttributeRestrictionsLike(Proxy item);
    public A withProjectAttributeRestrictions(Project projectAttributeRestrictions);
    public PolicyRuleFluent.ProjectAttributeRestrictionsNested<A> withNewProjectAttributeRestrictions();
    public PolicyRuleFluent.ProjectAttributeRestrictionsNested<A> withNewProjectAttributeRestrictionsLike(Project item);
    public A withClusterOperatorAttributeRestrictions(ClusterOperator clusterOperatorAttributeRestrictions);
    public PolicyRuleFluent.ClusterOperatorAttributeRestrictionsNested<A> withNewClusterOperatorAttributeRestrictions();
    public PolicyRuleFluent.ClusterOperatorAttributeRestrictionsNested<A> withNewClusterOperatorAttributeRestrictionsLike(ClusterOperator item);
    public A withBuildConfigAttributeRestrictions(BuildConfig buildConfigAttributeRestrictions);
    public PolicyRuleFluent.BuildConfigAttributeRestrictionsNested<A> withNewBuildConfigAttributeRestrictions();
    public PolicyRuleFluent.BuildConfigAttributeRestrictionsNested<A> withNewBuildConfigAttributeRestrictionsLike(BuildConfig item);
    public A withInfrastructureAttributeRestrictions(Infrastructure infrastructureAttributeRestrictions);
    public PolicyRuleFluent.InfrastructureAttributeRestrictionsNested<A> withNewInfrastructureAttributeRestrictions();
    public PolicyRuleFluent.InfrastructureAttributeRestrictionsNested<A> withNewInfrastructureAttributeRestrictionsLike(Infrastructure item);
    public A withSchedulerAttributeRestrictions(Scheduler schedulerAttributeRestrictions);
    public PolicyRuleFluent.SchedulerAttributeRestrictionsNested<A> withNewSchedulerAttributeRestrictions();
    public PolicyRuleFluent.SchedulerAttributeRestrictionsNested<A> withNewSchedulerAttributeRestrictionsLike(Scheduler item);
    public A withRangeAllocationAttributeRestrictions(RangeAllocation rangeAllocationAttributeRestrictions);
    public PolicyRuleFluent.RangeAllocationAttributeRestrictionsNested<A> withNewRangeAllocationAttributeRestrictions();
    public PolicyRuleFluent.RangeAllocationAttributeRestrictionsNested<A> withNewRangeAllocationAttributeRestrictionsLike(RangeAllocation item);
    public A withRouteAttributeRestrictions(Route routeAttributeRestrictions);
    public PolicyRuleFluent.RouteAttributeRestrictionsNested<A> withNewRouteAttributeRestrictions();
    public PolicyRuleFluent.RouteAttributeRestrictionsNested<A> withNewRouteAttributeRestrictionsLike(Route item);
    public A withClusterNetworkAttributeRestrictions(ClusterNetwork clusterNetworkAttributeRestrictions);
    public PolicyRuleFluent.ClusterNetworkAttributeRestrictionsNested<A> withNewClusterNetworkAttributeRestrictions();
    public PolicyRuleFluent.ClusterNetworkAttributeRestrictionsNested<A> withNewClusterNetworkAttributeRestrictionsLike(ClusterNetwork item);
    public A withOAuthAuthorizeTokenAttributeRestrictions(OAuthAuthorizeToken oAuthAuthorizeTokenAttributeRestrictions);
    public PolicyRuleFluent.OAuthAuthorizeTokenAttributeRestrictionsNested<A> withNewOAuthAuthorizeTokenAttributeRestrictions();
    public PolicyRuleFluent.OAuthAuthorizeTokenAttributeRestrictionsNested<A> withNewOAuthAuthorizeTokenAttributeRestrictionsLike(OAuthAuthorizeToken item);
    public A withOAuthAttributeRestrictions(OAuth oAuthAttributeRestrictions);
    public PolicyRuleFluent.OAuthAttributeRestrictionsNested<A> withNewOAuthAttributeRestrictions();
    public PolicyRuleFluent.OAuthAttributeRestrictionsNested<A> withNewOAuthAttributeRestrictionsLike(OAuth item);
    public A withOperatorHubAttributeRestrictions(OperatorHub operatorHubAttributeRestrictions);
    public PolicyRuleFluent.OperatorHubAttributeRestrictionsNested<A> withNewOperatorHubAttributeRestrictions();
    public PolicyRuleFluent.OperatorHubAttributeRestrictionsNested<A> withNewOperatorHubAttributeRestrictionsLike(OperatorHub item);
    public A withClusterRoleBindingAttributeRestrictions(ClusterRoleBinding clusterRoleBindingAttributeRestrictions);
    public PolicyRuleFluent.ClusterRoleBindingAttributeRestrictionsNested<A> withNewClusterRoleBindingAttributeRestrictions();
    public PolicyRuleFluent.ClusterRoleBindingAttributeRestrictionsNested<A> withNewClusterRoleBindingAttributeRestrictionsLike(ClusterRoleBinding item);
    public A withClusterResourceQuotaAttributeRestrictions(ClusterResourceQuota clusterResourceQuotaAttributeRestrictions);
    public PolicyRuleFluent.ClusterResourceQuotaAttributeRestrictionsNested<A> withNewClusterResourceQuotaAttributeRestrictions();
    public PolicyRuleFluent.ClusterResourceQuotaAttributeRestrictionsNested<A> withNewClusterResourceQuotaAttributeRestrictionsLike(ClusterResourceQuota item);
    public A withProjectRequestAttributeRestrictions(ProjectRequest projectRequestAttributeRestrictions);
    public PolicyRuleFluent.ProjectRequestAttributeRestrictionsNested<A> withNewProjectRequestAttributeRestrictions();
    public PolicyRuleFluent.ProjectRequestAttributeRestrictionsNested<A> withNewProjectRequestAttributeRestrictionsLike(ProjectRequest item);
    public A withTemplateAttributeRestrictions(Template templateAttributeRestrictions);
    public PolicyRuleFluent.TemplateAttributeRestrictionsNested<A> withNewTemplateAttributeRestrictions();
    public PolicyRuleFluent.TemplateAttributeRestrictionsNested<A> withNewTemplateAttributeRestrictionsLike(Template item);
    public A withOAuthClientAuthorizationAttributeRestrictions(OAuthClientAuthorization oAuthClientAuthorizationAttributeRestrictions);
    public PolicyRuleFluent.OAuthClientAuthorizationAttributeRestrictionsNested<A> withNewOAuthClientAuthorizationAttributeRestrictions();
    public PolicyRuleFluent.OAuthClientAuthorizationAttributeRestrictionsNested<A> withNewOAuthClientAuthorizationAttributeRestrictionsLike(OAuthClientAuthorization item);
    public A withClusterRoleAttributeRestrictions(ClusterRole clusterRoleAttributeRestrictions);
    public PolicyRuleFluent.ClusterRoleAttributeRestrictionsNested<A> withNewClusterRoleAttributeRestrictions();
    public PolicyRuleFluent.ClusterRoleAttributeRestrictionsNested<A> withNewClusterRoleAttributeRestrictionsLike(ClusterRole item);
    public A withImageTagAttributeRestrictions(ImageTag imageTagAttributeRestrictions);
    public PolicyRuleFluent.ImageTagAttributeRestrictionsNested<A> withNewImageTagAttributeRestrictions();
    public PolicyRuleFluent.ImageTagAttributeRestrictionsNested<A> withNewImageTagAttributeRestrictionsLike(ImageTag item);
    public A withDeploymentConfigAttributeRestrictions(DeploymentConfig deploymentConfigAttributeRestrictions);
    public PolicyRuleFluent.DeploymentConfigAttributeRestrictionsNested<A> withNewDeploymentConfigAttributeRestrictions();
    public PolicyRuleFluent.DeploymentConfigAttributeRestrictionsNested<A> withNewDeploymentConfigAttributeRestrictionsLike(DeploymentConfig item);
    public A withOAuthAccessTokenAttributeRestrictions(OAuthAccessToken oAuthAccessTokenAttributeRestrictions);
    public PolicyRuleFluent.OAuthAccessTokenAttributeRestrictionsNested<A> withNewOAuthAccessTokenAttributeRestrictions();
    public PolicyRuleFluent.OAuthAccessTokenAttributeRestrictionsNested<A> withNewOAuthAccessTokenAttributeRestrictionsLike(OAuthAccessToken item);
    public A withRoleBindingAttributeRestrictions(RoleBinding roleBindingAttributeRestrictions);
    public PolicyRuleFluent.RoleBindingAttributeRestrictionsNested<A> withNewRoleBindingAttributeRestrictions();
    public PolicyRuleFluent.RoleBindingAttributeRestrictionsNested<A> withNewRoleBindingAttributeRestrictionsLike(RoleBinding item);
    public A withImageAttributeRestrictions(Image imageAttributeRestrictions);
    public PolicyRuleFluent.ImageAttributeRestrictionsNested<A> withNewImageAttributeRestrictions();
    public PolicyRuleFluent.ImageAttributeRestrictionsNested<A> withNewImageAttributeRestrictionsLike(Image item);
    public A withAPIServerAttributeRestrictions(APIServer aPIServerAttributeRestrictions);
    public PolicyRuleFluent.APIServerAttributeRestrictionsNested<A> withNewAPIServerAttributeRestrictions();
    public PolicyRuleFluent.APIServerAttributeRestrictionsNested<A> withNewAPIServerAttributeRestrictionsLike(APIServer item);
    public A withPersistentVolumeClaimAttributeRestrictions(PersistentVolumeClaim persistentVolumeClaimAttributeRestrictions);
    public PolicyRuleFluent.PersistentVolumeClaimAttributeRestrictionsNested<A> withNewPersistentVolumeClaimAttributeRestrictions();
    public PolicyRuleFluent.PersistentVolumeClaimAttributeRestrictionsNested<A> withNewPersistentVolumeClaimAttributeRestrictionsLike(PersistentVolumeClaim item);
    public A withImageStreamMappingAttributeRestrictions(ImageStreamMapping imageStreamMappingAttributeRestrictions);
    public PolicyRuleFluent.ImageStreamMappingAttributeRestrictionsNested<A> withNewImageStreamMappingAttributeRestrictions();
    public PolicyRuleFluent.ImageStreamMappingAttributeRestrictionsNested<A> withNewImageStreamMappingAttributeRestrictionsLike(ImageStreamMapping item);
    public A withRoleAttributeRestrictions(Role roleAttributeRestrictions);
    public PolicyRuleFluent.RoleAttributeRestrictionsNested<A> withNewRoleAttributeRestrictions();
    public PolicyRuleFluent.RoleAttributeRestrictionsNested<A> withNewRoleAttributeRestrictionsLike(Role item);
    public A withFeatureGateAttributeRestrictions(FeatureGate featureGateAttributeRestrictions);
    public PolicyRuleFluent.FeatureGateAttributeRestrictionsNested<A> withNewFeatureGateAttributeRestrictions();
    public PolicyRuleFluent.FeatureGateAttributeRestrictionsNested<A> withNewFeatureGateAttributeRestrictionsLike(FeatureGate item);
    public A withUserAttributeRestrictions(User userAttributeRestrictions);
    public PolicyRuleFluent.UserAttributeRestrictionsNested<A> withNewUserAttributeRestrictions();
    public PolicyRuleFluent.UserAttributeRestrictionsNested<A> withNewUserAttributeRestrictionsLike(User item);
    public A withImageStreamImageAttributeRestrictions(ImageStreamImage imageStreamImageAttributeRestrictions);
    public PolicyRuleFluent.ImageStreamImageAttributeRestrictionsNested<A> withNewImageStreamImageAttributeRestrictions();
    public PolicyRuleFluent.ImageStreamImageAttributeRestrictionsNested<A> withNewImageStreamImageAttributeRestrictionsLike(ImageStreamImage item);
    public A withBuildAttributeRestrictions(Build buildAttributeRestrictions);
    public PolicyRuleFluent.BuildAttributeRestrictionsNested<A> withNewBuildAttributeRestrictions();
    public PolicyRuleFluent.BuildAttributeRestrictionsNested<A> withNewBuildAttributeRestrictionsLike(Build item);
    public A withRoleBindingRestrictionAttributeRestrictions(RoleBindingRestriction roleBindingRestrictionAttributeRestrictions);
    public PolicyRuleFluent.RoleBindingRestrictionAttributeRestrictionsNested<A> withNewRoleBindingRestrictionAttributeRestrictions();
    public PolicyRuleFluent.RoleBindingRestrictionAttributeRestrictionsNested<A> withNewRoleBindingRestrictionAttributeRestrictionsLike(RoleBindingRestriction item);
    public A withImageStreamTagAttributeRestrictions(ImageStreamTag imageStreamTagAttributeRestrictions);
    public PolicyRuleFluent.ImageStreamTagAttributeRestrictionsNested<A> withNewImageStreamTagAttributeRestrictions();
    public PolicyRuleFluent.ImageStreamTagAttributeRestrictionsNested<A> withNewImageStreamTagAttributeRestrictionsLike(ImageStreamTag item);
    public A withGroupAttributeRestrictions(io.fabric8.openshift.api.model.Group groupAttributeRestrictions);
    public PolicyRuleFluent.GroupAttributeRestrictionsNested<A> withNewGroupAttributeRestrictions();
    public PolicyRuleFluent.GroupAttributeRestrictionsNested<A> withNewGroupAttributeRestrictionsLike(io.fabric8.openshift.api.model.Group item);
    public A withImageSignatureAttributeRestrictions(ImageSignature imageSignatureAttributeRestrictions);
    public PolicyRuleFluent.ImageSignatureAttributeRestrictionsNested<A> withNewImageSignatureAttributeRestrictions();
    public PolicyRuleFluent.ImageSignatureAttributeRestrictionsNested<A> withNewImageSignatureAttributeRestrictionsLike(ImageSignature item);
    public A withAppliedClusterResourceQuotaAttributeRestrictions(AppliedClusterResourceQuota appliedClusterResourceQuotaAttributeRestrictions);
    public PolicyRuleFluent.AppliedClusterResourceQuotaAttributeRestrictionsNested<A> withNewAppliedClusterResourceQuotaAttributeRestrictions();
    public PolicyRuleFluent.AppliedClusterResourceQuotaAttributeRestrictionsNested<A> withNewAppliedClusterResourceQuotaAttributeRestrictionsLike(AppliedClusterResourceQuota item);
    public A withSecurityContextConstraintsAttributeRestrictions(SecurityContextConstraints securityContextConstraintsAttributeRestrictions);
    public PolicyRuleFluent.SecurityContextConstraintsAttributeRestrictionsNested<A> withNewSecurityContextConstraintsAttributeRestrictions();
    public PolicyRuleFluent.SecurityContextConstraintsAttributeRestrictionsNested<A> withNewSecurityContextConstraintsAttributeRestrictionsLike(SecurityContextConstraints item);
    public A withBuildRequestAttributeRestrictions(BuildRequest buildRequestAttributeRestrictions);
    public PolicyRuleFluent.BuildRequestAttributeRestrictionsNested<A> withNewBuildRequestAttributeRestrictions();
    public PolicyRuleFluent.BuildRequestAttributeRestrictionsNested<A> withNewBuildRequestAttributeRestrictionsLike(BuildRequest item);
    public A withEgressNetworkPolicyAttributeRestrictions(EgressNetworkPolicy egressNetworkPolicyAttributeRestrictions);
    public PolicyRuleFluent.EgressNetworkPolicyAttributeRestrictionsNested<A> withNewEgressNetworkPolicyAttributeRestrictions();
    public PolicyRuleFluent.EgressNetworkPolicyAttributeRestrictionsNested<A> withNewEgressNetworkPolicyAttributeRestrictionsLike(EgressNetworkPolicy item);
    public A withNetNamespaceAttributeRestrictions(NetNamespace netNamespaceAttributeRestrictions);
    public PolicyRuleFluent.NetNamespaceAttributeRestrictionsNested<A> withNewNetNamespaceAttributeRestrictions();
    public PolicyRuleFluent.NetNamespaceAttributeRestrictionsNested<A> withNewNetNamespaceAttributeRestrictionsLike(NetNamespace item);
    public A withImageStreamAttributeRestrictions(ImageStream imageStreamAttributeRestrictions);
    public PolicyRuleFluent.ImageStreamAttributeRestrictionsNested<A> withNewImageStreamAttributeRestrictions();
    public PolicyRuleFluent.ImageStreamAttributeRestrictionsNested<A> withNewImageStreamAttributeRestrictionsLike(ImageStream item);
    public A withOAuthClientAttributeRestrictions(OAuthClient oAuthClientAttributeRestrictions);
    public PolicyRuleFluent.OAuthClientAttributeRestrictionsNested<A> withNewOAuthClientAttributeRestrictions();
    public PolicyRuleFluent.OAuthClientAttributeRestrictionsNested<A> withNewOAuthClientAttributeRestrictionsLike(OAuthClient item);
    public A withIdentityAttributeRestrictions(Identity identityAttributeRestrictions);
    public PolicyRuleFluent.IdentityAttributeRestrictionsNested<A> withNewIdentityAttributeRestrictions();
    public PolicyRuleFluent.IdentityAttributeRestrictionsNested<A> withNewIdentityAttributeRestrictionsLike(Identity item);
    public A addToNonResourceURLs(int index,String item);
    public A setToNonResourceURLs(int index,String item);
    public A addToNonResourceURLs(String... items);
    public A addAllToNonResourceURLs(Collection<String> items);
    public A removeFromNonResourceURLs(String... items);
    public A removeAllFromNonResourceURLs(Collection<String> items);
    public List<String> getNonResourceURLs();
    public String getNonResourceURL(int index);
    public String getFirstNonResourceURL();
    public String getLastNonResourceURL();
    public String getMatchingNonResourceURL(Predicate<String> predicate);
    public Boolean hasMatchingNonResourceURL(Predicate<String> predicate);
    public A withNonResourceURLs(List<String> nonResourceURLs);
    public A withNonResourceURLs(String... nonResourceURLs);
    public Boolean hasNonResourceURLs();
    public A addNewNonResourceURL(String arg1);
    public A addNewNonResourceURL(StringBuilder arg1);
    public A addNewNonResourceURL(StringBuffer arg1);
    public A addToResourceNames(int index,String item);
    public A setToResourceNames(int index,String item);
    public A addToResourceNames(String... items);
    public A addAllToResourceNames(Collection<String> items);
    public A removeFromResourceNames(String... items);
    public A removeAllFromResourceNames(Collection<String> items);
    public List<String> getResourceNames();
    public String getResourceName(int index);
    public String getFirstResourceName();
    public String getLastResourceName();
    public String getMatchingResourceName(Predicate<String> predicate);
    public Boolean hasMatchingResourceName(Predicate<String> predicate);
    public A withResourceNames(List<String> resourceNames);
    public A withResourceNames(String... resourceNames);
    public Boolean hasResourceNames();
    public A addNewResourceName(String arg1);
    public A addNewResourceName(StringBuilder arg1);
    public A addNewResourceName(StringBuffer arg1);
    public A addToResources(int index,String item);
    public A setToResources(int index,String item);
    public A addToResources(String... items);
    public A addAllToResources(Collection<String> items);
    public A removeFromResources(String... items);
    public A removeAllFromResources(Collection<String> items);
    public List<String> getResources();
    public String getResource(int index);
    public String getFirstResource();
    public String getLastResource();
    public String getMatchingResource(Predicate<String> predicate);
    public Boolean hasMatchingResource(Predicate<String> predicate);
    public A withResources(List<String> resources);
    public A withResources(String... resources);
    public Boolean hasResources();
    public A addNewResource(String arg1);
    public A addNewResource(StringBuilder arg1);
    public A addNewResource(StringBuffer arg1);
    public A addToVerbs(int index,String item);
    public A setToVerbs(int index,String item);
    public A addToVerbs(String... items);
    public A addAllToVerbs(Collection<String> items);
    public A removeFromVerbs(String... items);
    public A removeAllFromVerbs(Collection<String> items);
    public List<String> getVerbs();
    public String getVerb(int index);
    public String getFirstVerb();
    public String getLastVerb();
    public String getMatchingVerb(Predicate<String> predicate);
    public Boolean hasMatchingVerb(Predicate<String> predicate);
    public A withVerbs(List<String> verbs);
    public A withVerbs(String... verbs);
    public Boolean hasVerbs();
    public A addNewVerb(String arg1);
    public A addNewVerb(StringBuilder arg1);
    public A addNewVerb(StringBuffer arg1);
    public interface ClusterVersionAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterVersionFluent<PolicyRuleFluent.ClusterVersionAttributeRestrictionsNested<N>> {

        public N and();
        public N endClusterVersionAttributeRestrictions();    }


    public interface ImageStreamImportAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageStreamImportFluent<PolicyRuleFluent.ImageStreamImportAttributeRestrictionsNested<N>> {

        public N and();
        public N endImageStreamImportAttributeRestrictions();    }


    public interface ProxyAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ProxyFluent<PolicyRuleFluent.ProxyAttributeRestrictionsNested<N>> {

        public N and();
        public N endProxyAttributeRestrictions();    }


    public interface ProjectAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ProjectFluent<PolicyRuleFluent.ProjectAttributeRestrictionsNested<N>> {

        public N and();
        public N endProjectAttributeRestrictions();    }


    public interface ClusterOperatorAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterOperatorFluent<PolicyRuleFluent.ClusterOperatorAttributeRestrictionsNested<N>> {

        public N and();
        public N endClusterOperatorAttributeRestrictions();    }


    public interface BuildConfigAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BuildConfigFluent<PolicyRuleFluent.BuildConfigAttributeRestrictionsNested<N>> {

        public N and();
        public N endBuildConfigAttributeRestrictions();    }


    public interface InfrastructureAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,InfrastructureFluent<PolicyRuleFluent.InfrastructureAttributeRestrictionsNested<N>> {

        public N and();
        public N endInfrastructureAttributeRestrictions();    }


    public interface SchedulerAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SchedulerFluent<PolicyRuleFluent.SchedulerAttributeRestrictionsNested<N>> {

        public N and();
        public N endSchedulerAttributeRestrictions();    }


    public interface RangeAllocationAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RangeAllocationFluent<PolicyRuleFluent.RangeAllocationAttributeRestrictionsNested<N>> {

        public N and();
        public N endRangeAllocationAttributeRestrictions();    }


    public interface RouteAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RouteFluent<PolicyRuleFluent.RouteAttributeRestrictionsNested<N>> {

        public N and();
        public N endRouteAttributeRestrictions();    }


    public interface ClusterNetworkAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterNetworkFluent<PolicyRuleFluent.ClusterNetworkAttributeRestrictionsNested<N>> {

        public N and();
        public N endClusterNetworkAttributeRestrictions();    }


    public interface OAuthAuthorizeTokenAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OAuthAuthorizeTokenFluent<PolicyRuleFluent.OAuthAuthorizeTokenAttributeRestrictionsNested<N>> {

        public N and();
        public N endOAuthAuthorizeTokenAttributeRestrictions();    }


    public interface OAuthAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OAuthFluent<PolicyRuleFluent.OAuthAttributeRestrictionsNested<N>> {

        public N and();
        public N endOAuthAttributeRestrictions();    }


    public interface OperatorHubAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OperatorHubFluent<PolicyRuleFluent.OperatorHubAttributeRestrictionsNested<N>> {

        public N and();
        public N endOperatorHubAttributeRestrictions();    }


    public interface ClusterRoleBindingAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterRoleBindingFluent<PolicyRuleFluent.ClusterRoleBindingAttributeRestrictionsNested<N>> {

        public N and();
        public N endClusterRoleBindingAttributeRestrictions();    }


    public interface ClusterResourceQuotaAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterResourceQuotaFluent<PolicyRuleFluent.ClusterResourceQuotaAttributeRestrictionsNested<N>> {

        public N and();
        public N endClusterResourceQuotaAttributeRestrictions();    }


    public interface ProjectRequestAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ProjectRequestFluent<PolicyRuleFluent.ProjectRequestAttributeRestrictionsNested<N>> {

        public N and();
        public N endProjectRequestAttributeRestrictions();    }


    public interface TemplateAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TemplateFluent<PolicyRuleFluent.TemplateAttributeRestrictionsNested<N>> {

        public N and();
        public N endTemplateAttributeRestrictions();    }


    public interface OAuthClientAuthorizationAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OAuthClientAuthorizationFluent<PolicyRuleFluent.OAuthClientAuthorizationAttributeRestrictionsNested<N>> {

        public N and();
        public N endOAuthClientAuthorizationAttributeRestrictions();    }


    public interface ClusterRoleAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterRoleFluent<PolicyRuleFluent.ClusterRoleAttributeRestrictionsNested<N>> {

        public N and();
        public N endClusterRoleAttributeRestrictions();    }


    public interface ImageTagAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageTagFluent<PolicyRuleFluent.ImageTagAttributeRestrictionsNested<N>> {

        public N and();
        public N endImageTagAttributeRestrictions();    }


    public interface DeploymentConfigAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DeploymentConfigFluent<PolicyRuleFluent.DeploymentConfigAttributeRestrictionsNested<N>> {

        public N and();
        public N endDeploymentConfigAttributeRestrictions();    }


    public interface OAuthAccessTokenAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OAuthAccessTokenFluent<PolicyRuleFluent.OAuthAccessTokenAttributeRestrictionsNested<N>> {

        public N and();
        public N endOAuthAccessTokenAttributeRestrictions();    }


    public interface RoleBindingAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RoleBindingFluent<PolicyRuleFluent.RoleBindingAttributeRestrictionsNested<N>> {

        public N and();
        public N endRoleBindingAttributeRestrictions();    }


    public interface ImageAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageFluent<PolicyRuleFluent.ImageAttributeRestrictionsNested<N>> {

        public N and();
        public N endImageAttributeRestrictions();    }


    public interface APIServerAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,APIServerFluent<PolicyRuleFluent.APIServerAttributeRestrictionsNested<N>> {

        public N and();
        public N endAPIServerAttributeRestrictions();    }


    public interface PersistentVolumeClaimAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PersistentVolumeClaimFluent<PolicyRuleFluent.PersistentVolumeClaimAttributeRestrictionsNested<N>> {

        public N and();
        public N endPersistentVolumeClaimAttributeRestrictions();    }


    public interface ImageStreamMappingAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageStreamMappingFluent<PolicyRuleFluent.ImageStreamMappingAttributeRestrictionsNested<N>> {

        public N and();
        public N endImageStreamMappingAttributeRestrictions();    }


    public interface RoleAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RoleFluent<PolicyRuleFluent.RoleAttributeRestrictionsNested<N>> {

        public N and();
        public N endRoleAttributeRestrictions();    }


    public interface FeatureGateAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,FeatureGateFluent<PolicyRuleFluent.FeatureGateAttributeRestrictionsNested<N>> {

        public N and();
        public N endFeatureGateAttributeRestrictions();    }


    public interface UserAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,UserFluent<PolicyRuleFluent.UserAttributeRestrictionsNested<N>> {

        public N and();
        public N endUserAttributeRestrictions();    }


    public interface ImageStreamImageAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageStreamImageFluent<PolicyRuleFluent.ImageStreamImageAttributeRestrictionsNested<N>> {

        public N and();
        public N endImageStreamImageAttributeRestrictions();    }


    public interface BuildAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BuildFluent<PolicyRuleFluent.BuildAttributeRestrictionsNested<N>> {

        public N and();
        public N endBuildAttributeRestrictions();    }


    public interface RoleBindingRestrictionAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RoleBindingRestrictionFluent<PolicyRuleFluent.RoleBindingRestrictionAttributeRestrictionsNested<N>> {

        public N and();
        public N endRoleBindingRestrictionAttributeRestrictions();    }


    public interface ImageStreamTagAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageStreamTagFluent<PolicyRuleFluent.ImageStreamTagAttributeRestrictionsNested<N>> {

        public N and();
        public N endImageStreamTagAttributeRestrictions();    }


    public interface GroupAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,GroupFluent<PolicyRuleFluent.GroupAttributeRestrictionsNested<N>> {

        public N and();
        public N endGroupAttributeRestrictions();    }


    public interface ImageSignatureAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageSignatureFluent<PolicyRuleFluent.ImageSignatureAttributeRestrictionsNested<N>> {

        public N and();
        public N endImageSignatureAttributeRestrictions();    }


    public interface AppliedClusterResourceQuotaAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,AppliedClusterResourceQuotaFluent<PolicyRuleFluent.AppliedClusterResourceQuotaAttributeRestrictionsNested<N>> {

        public N and();
        public N endAppliedClusterResourceQuotaAttributeRestrictions();    }


    public interface SecurityContextConstraintsAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SecurityContextConstraintsFluent<PolicyRuleFluent.SecurityContextConstraintsAttributeRestrictionsNested<N>> {

        public N and();
        public N endSecurityContextConstraintsAttributeRestrictions();    }


    public interface BuildRequestAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BuildRequestFluent<PolicyRuleFluent.BuildRequestAttributeRestrictionsNested<N>> {

        public N and();
        public N endBuildRequestAttributeRestrictions();    }


    public interface EgressNetworkPolicyAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EgressNetworkPolicyFluent<PolicyRuleFluent.EgressNetworkPolicyAttributeRestrictionsNested<N>> {

        public N and();
        public N endEgressNetworkPolicyAttributeRestrictions();    }


    public interface NetNamespaceAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NetNamespaceFluent<PolicyRuleFluent.NetNamespaceAttributeRestrictionsNested<N>> {

        public N and();
        public N endNetNamespaceAttributeRestrictions();    }


    public interface ImageStreamAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageStreamFluent<PolicyRuleFluent.ImageStreamAttributeRestrictionsNested<N>> {

        public N and();
        public N endImageStreamAttributeRestrictions();    }


    public interface OAuthClientAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OAuthClientFluent<PolicyRuleFluent.OAuthClientAttributeRestrictionsNested<N>> {

        public N and();
        public N endOAuthClientAttributeRestrictions();    }


    public interface IdentityAttributeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,IdentityFluent<PolicyRuleFluent.IdentityAttributeRestrictionsNested<N>> {

        public N and();
        public N endIdentityAttributeRestrictions();    }


}
