package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface ImageStreamTagListFluent<A extends ImageStreamTagListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,ImageStreamTag item);
    public A setToItems(int index,ImageStreamTag item);
    public A addToItems(ImageStreamTag... items);
    public A addAllToItems(Collection<ImageStreamTag> items);
    public A removeFromItems(ImageStreamTag... items);
    public A removeAllFromItems(Collection<ImageStreamTag> items);
    public A removeMatchingFromItems(Predicate<ImageStreamTagBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<ImageStreamTag> getItems();
    public List<ImageStreamTag> buildItems();
    public ImageStreamTag buildItem(int index);
    public ImageStreamTag buildFirstItem();
    public ImageStreamTag buildLastItem();
    public ImageStreamTag buildMatchingItem(Predicate<ImageStreamTagBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<ImageStreamTagBuilder> predicate);
    public A withItems(List<ImageStreamTag> items);
    public A withItems(ImageStreamTag... items);
    public Boolean hasItems();
    public ImageStreamTagListFluent.ItemsNested<A> addNewItem();
    public ImageStreamTagListFluent.ItemsNested<A> addNewItemLike(ImageStreamTag item);
    public ImageStreamTagListFluent.ItemsNested<A> setNewItemLike(int index,ImageStreamTag item);
    public ImageStreamTagListFluent.ItemsNested<A> editItem(int index);
    public ImageStreamTagListFluent.ItemsNested<A> editFirstItem();
    public ImageStreamTagListFluent.ItemsNested<A> editLastItem();
    public ImageStreamTagListFluent.ItemsNested<A> editMatchingItem(Predicate<ImageStreamTagBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageStreamTagFluent<ImageStreamTagListFluent.ItemsNested<N>> {

        public N and();
        public N endItem();    }


}
