package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface GroupListFluent<A extends GroupListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,io.fabric8.openshift.api.model.Group item);
    public A setToItems(int index,io.fabric8.openshift.api.model.Group item);
    public A addToItems(io.fabric8.openshift.api.model.Group... items);
    public A addAllToItems(Collection<io.fabric8.openshift.api.model.Group> items);
    public A removeFromItems(io.fabric8.openshift.api.model.Group... items);
    public A removeAllFromItems(Collection<io.fabric8.openshift.api.model.Group> items);
    public A removeMatchingFromItems(Predicate<GroupBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<io.fabric8.openshift.api.model.Group> getItems();
    public List<io.fabric8.openshift.api.model.Group> buildItems();
    public io.fabric8.openshift.api.model.Group buildItem(int index);
    public io.fabric8.openshift.api.model.Group buildFirstItem();
    public io.fabric8.openshift.api.model.Group buildLastItem();
    public io.fabric8.openshift.api.model.Group buildMatchingItem(Predicate<GroupBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<GroupBuilder> predicate);
    public A withItems(List<io.fabric8.openshift.api.model.Group> items);
    public A withItems(io.fabric8.openshift.api.model.Group... items);
    public Boolean hasItems();
    public GroupListFluent.ItemsNested<A> addNewItem();
    public GroupListFluent.ItemsNested<A> addNewItemLike(io.fabric8.openshift.api.model.Group item);
    public GroupListFluent.ItemsNested<A> setNewItemLike(int index,io.fabric8.openshift.api.model.Group item);
    public GroupListFluent.ItemsNested<A> editItem(int index);
    public GroupListFluent.ItemsNested<A> editFirstItem();
    public GroupListFluent.ItemsNested<A> editLastItem();
    public GroupListFluent.ItemsNested<A> editMatchingItem(Predicate<GroupBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,GroupFluent<GroupListFluent.ItemsNested<N>> {

        public N and();
        public N endItem();    }


}
